/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.exception.service.topology.TopologyInitializationException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.definition.TopologyStorageService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.startup.TrendzStartupService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.TopologyDiscoveryJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import org.thingsboard.trendz.service.topology.InitializationService;

@Service
public class InitializationServiceImpl
implements InitializationService,
TrendzStartupService {
    private static final Logger log = LoggerFactory.getLogger(InitializationServiceImpl.class);
    private final TopologyStorageService topologyStorageService;
    private final UserManagementService userManagementService;
    private final TaskService taskService;
    private final Cache tenantInitStatusCache;
    private final ScheduledExecutorService executor;

    @Autowired
    public InitializationServiceImpl(TopologyStorageService topologyStorageService, UserManagementService userManagementService, TaskService taskService, CacheService cacheService, ExecutorManagementService executorManagementService) {
        this.topologyStorageService = topologyStorageService;
        this.userManagementService = userManagementService;
        this.taskService = taskService;
        this.tenantInitStatusCache = cacheService.getCache(CacheConfigurationName.tenantInitStatusCacheName);
        this.executor = (ScheduledExecutorService)executorManagementService.getExecutorByName(ExecutorName.INIT_STATUS);
    }

    public void onStartup(ApplicationContext context) {
        this.executor.scheduleAtFixedRate(() -> this.scheduledUserValidation(), 0L, 1445L, TimeUnit.MINUTES);
    }

    public int priority() {
        return 22;
    }

    public InitStatus getInitStatus(JwtSecurityUser user) {
        return (InitStatus)this.tenantInitStatusCache.get((Object)user.getTenantCustomerKey(), () -> {
            boolean hasAnyEntity = this.hasAnyEntity(user);
            return InitStatus.builder().inited(hasAnyEntity).inProgress(false).executionId(null).build();
        });
    }

    public void refreshInitStatus(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        boolean hasAnyEntity = this.hasAnyEntity(user);
        UUID executionId = Optional.ofNullable((InitStatus)this.tenantInitStatusCache.get((Object)user.getTenantCustomerKey(), InitStatus.class)).map(InitStatus::getExecutionId).orElse(null);
        boolean inProgress = Optional.ofNullable(executionId).flatMap(id -> this.taskService.findExecutionById(user, id)).map(execution -> execution.getStatus().isCancellable()).orElse(false);
        InitStatus initStatus = InitStatus.builder().inited(hasAnyEntity).inProgress(inProgress).executionId(executionId).build();
        this.tenantInitStatusCache.put((Object)user.getTenantCustomerKey(), (Object)initStatus);
    }

    public InitStatus initTopology(JwtSecurityUser user, String jwtToken) {
        InitStatus currentStatus = this.getInitStatus(user);
        if (currentStatus.isInProgress()) {
            throw new TopologyInitializationException("Other initialization request is in progress. Skip");
        }
        TopologyDiscoveryJob job = new TopologyDiscoveryJob(DiscoverConfig.getDefault());
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.TOPOLOGY_DISCOVERY, user.getTenantId().toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, taskReference).orElseThrow(() -> new TaskNotFoundException(taskReference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, true);
        InitStatus newStatus = InitStatus.builder().inited(false).inProgress(true).executionId(executionId).build();
        this.tenantInitStatusCache.put((Object)user.getTenantCustomerKey(), (Object)newStatus);
        return newStatus;
    }

    private boolean hasAnyEntity(JwtSecurityUser user) {
        log.debug("Checking if any entity exists for user {}", (Object)user.getTenantCustomerKey());
        return !this.topologyStorageService.loadAllEntities(user).getEntityMap().isEmpty();
    }

    private void scheduledUserValidation() {
        try {
            Page usersPage;
            log.info("Scheduled user validation: started");
            int page = 0;
            int pageSize = 100;
            do {
                usersPage = this.userManagementService.getAllUserIds(page, pageSize);
                for (JwtSecurityUser user : usersPage.getContent()) {
                    try {
                        boolean isValid = this.userManagementService.validateUser(user);
                        if (!isValid) continue;
                        this.getInitStatus(user);
                    }
                    catch (Exception e) {
                        log.error("Error during user validation (tenant: {}, customer: {}, user: {}", new Object[]{user.getTenantId(), user.getCustomerId(), user.getUserId(), e});
                    }
                }
                ++page;
            } while (usersPage.hasNext());
            log.info("Scheduled user validation: finished");
        }
        catch (Exception e) {
            log.error("Error during scheduled user validation", (Throwable)e);
        }
    }
}

