/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.widget;

import com.google.common.collect.Sets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleConfigCollectionV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleConfigV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleItemV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetTypeItemV2;
import org.thingsboard.trendz.exception.tbwidget.InvalidActualConfiguration;
import org.thingsboard.trendz.exception.tbwidget.NativeWidgetBundleException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleService;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class NativeWidgetBundleServiceV2
implements NativeWidgetBundleService {
    private static final Logger log = LoggerFactory.getLogger(NativeWidgetBundleServiceV2.class);
    private static final List<String> TYPE_FQN_SET = List.of("trendz_builder", "trendz_view_latest", "trendz_view_static", "trendz_view_latest_chat");
    private static final String FILE_V_ANG15__3_6_0 = "native_trendz_bundle_ang15__3_6_0.json";
    private static final String FILE_V_ANG15__3_6_1 = "native_trendz_bundle_ang15__3_6_1.json";
    private static final String FILE_V_ANG18 = "native_trendz_bundle_ang18.json";
    private final AuthenticationService authenticationService;
    private final TbVersionChecker versionChecker;
    private final TbRestDataSource restDataSource;
    private final ApplicationPropertyService applicationPropertyService;
    private final CustomizationService customizationService;
    private final int maxDuplicatesCount;

    @Autowired
    public NativeWidgetBundleServiceV2(AuthenticationService authenticationService, TbVersionChecker versionChecker, TbRestDataSource restDataSource, ApplicationPropertyService applicationPropertyService, CustomizationService customizationService, @Value(value="${tb.api.widgetBundle.maxExpectedDuplicateCount}") int maxDuplicatesCount) {
        this.authenticationService = authenticationService;
        this.versionChecker = versionChecker;
        this.restDataSource = restDataSource;
        this.applicationPropertyService = applicationPropertyService;
        this.customizationService = customizationService;
        this.maxDuplicatesCount = maxDuplicatesCount;
    }

    public boolean bundleExists(JwtSecurityUser user) {
        TbVersion version;
        String jwtToken = this.authenticationService.getToken(user);
        TbWidgetBundleConfigCollectionV2 actualConfigCollection = this.loadConfigCollectionLite(jwtToken, version = this.versionChecker.getVersion(jwtToken));
        return !actualConfigCollection.isEmpty();
    }

    public TbResourceStatus getBundleStatus(JwtSecurityUser user, String domain, String externalUrl) {
        try {
            String jwtToken = this.authenticationService.getToken(user);
            TbVersion version = this.versionChecker.getVersion(jwtToken);
            CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
            String urlPrefix = customViewSettings.getUrl();
            String companyName = this.customizationService.getCompanyName(urlPrefix);
            TbWidgetBundleConfigCollectionV2 expectedConfigCollection = this.loadWidgetBundleDataForUploading(version, urlPrefix, companyName, externalUrl);
            TbWidgetBundleConfigCollectionV2 actualConfigCollection = this.loadConfigCollection(jwtToken, version);
            if (actualConfigCollection.isEmpty()) {
                this.applicationPropertyService.deleteProperty("trendz_bundle");
                return TbResourceStatus.DO_NOT_EXIST;
            }
            this.mergeHeadlessWidgetTypes(actualConfigCollection);
            TbWidgetBundleConfigV2 config = this.validateActualCollection(actualConfigCollection);
            Map expectedToActualMap = this.makeAliasFqnMapping(version, config);
            this.validateActualConfig(config, expectedToActualMap, version);
            boolean isEqual = this.compareWidgetBundles(actualConfigCollection, expectedConfigCollection, expectedToActualMap, version);
            if (isEqual) {
                return TbResourceStatus.LATEST;
            }
            return TbResourceStatus.OUTDATED;
        }
        catch (InvalidActualConfiguration e) {
            log.error("The bundle status is {}", (Object)TbResourceStatus.INVALID);
            return TbResourceStatus.INVALID;
        }
    }

    public UploadTbResourceStatus uploadNativeWidgetBundle(JwtSecurityUser user, String domain, String externalUrl) {
        String jwtToken = this.authenticationService.getToken(user);
        TbVersion version = this.versionChecker.getVersion(jwtToken);
        CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
        String urlPrefix = customViewSettings.getUrl();
        String companyName = this.customizationService.getCompanyName(urlPrefix);
        TbWidgetBundleConfigCollectionV2 expectedConfigCollection = this.loadWidgetBundleDataForUploading(version, urlPrefix, companyName, externalUrl);
        TbWidgetBundleConfigCollectionV2 actualConfigCollection = this.loadConfigCollection(jwtToken, version);
        if (actualConfigCollection.isEmpty()) {
            log.info("The version of TB is {} {} {}", new Object[]{version.getVersion(), version.isPe() ? "PE" : "CE", version.isCloud() ? "Cloud" : "Self-Managed"});
            TbWidgetBundleConfigCollectionV2 savedCollection = this.createWidgetBundleOnTB(expectedConfigCollection, jwtToken);
            String alias = ((TbWidgetBundleConfigV2)savedCollection.getConfigList().iterator().next()).getWidgetsBundle().getAlias();
            this.applicationPropertyService.setProperty("trendz_bundle", alias);
            return UploadTbResourceStatus.CREATED;
        }
        this.mergeHeadlessWidgetTypes(actualConfigCollection);
        TbWidgetBundleConfigV2 config = this.validateActualCollection(actualConfigCollection);
        Map expectedToActualMap = this.makeAliasFqnMapping(version, config);
        this.validateActualConfig(config, expectedToActualMap, version);
        boolean isEqual = this.compareWidgetBundles(actualConfigCollection, expectedConfigCollection, expectedToActualMap, version);
        if (isEqual) {
            String currentAlias = config.getWidgetsBundle().getAlias();
            this.applicationPropertyService.setProperty("trendz_bundle", currentAlias);
            return UploadTbResourceStatus.ALREADY_EXISTS;
        }
        TbWidgetBundleConfigCollectionV2 savedCollection = this.updateWidgetBundleOnTB(actualConfigCollection, expectedConfigCollection, expectedToActualMap, jwtToken);
        String savedAlias = ((TbWidgetBundleConfigV2)savedCollection.getConfigList().iterator().next()).getWidgetsBundle().getAlias();
        this.applicationPropertyService.setProperty("trendz_bundle", savedAlias);
        return UploadTbResourceStatus.UPDATED;
    }

    private String getWidgetPrefixGlobal(TbVersion version) {
        if (version.getVersion().less(TbVersionNumber.V_3_6_1)) {
            return "tenant.";
        }
        return "tenant.trendz_bundle.";
    }

    private String getWidgetPrefixLocal(TbVersion version) {
        if (version.getVersion().less(TbVersionNumber.V_3_6_1)) {
            return "";
        }
        return "trendz_bundle.";
    }

    private Map<String, String> makeAliasFqnMapping(TbVersion version, TbWidgetBundleConfigV2 config) {
        TbWidgetBundleItemV2 widgetsBundle = config.getWidgetsBundle();
        List widgetTypes = config.getWidgetTypes();
        Map<String, Long> uniqTypeFqns = widgetTypes.stream().collect(Collectors.groupingBy(TbWidgetTypeItemV2::getFqn, Collectors.counting()));
        Map<String, String> expectedToActualMap = uniqTypeFqns.keySet().stream().map(actualFqn -> {
            for (String expectedFqn : TYPE_FQN_SET) {
                String expectedFqnFull = this.getWidgetPrefixLocal(version) + expectedFqn;
                String pattern = "^%s\\d*_%s\\d*$".formatted("trendz_bundle", expectedFqn);
                if (!actualFqn.matches(pattern)) continue;
                return Map.entry(expectedFqnFull, actualFqn);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
        if (widgetsBundle != null) {
            expectedToActualMap.put("trendz_bundle", widgetsBundle.getAlias());
        }
        return expectedToActualMap;
    }

    private TbWidgetBundleConfigCollectionV2 loadConfigCollectionLite(String jwtToken, TbVersion version) {
        ArrayList<TbWidgetBundleConfigV2> configs = new ArrayList<TbWidgetBundleConfigV2>();
        List widgetBundles = this.loadTrendzWidgetBundles(jwtToken);
        for (TbWidgetBundleItemV2 widgetBundle : widgetBundles) {
            WidgetsBundleId id = widgetBundle.getId();
            List widgetTypeItem = (List)DonReactive.block((Mono)this.restDataSource.loadWidgetTypeInfos(id.getId(), jwtToken));
            Set fqnSet = widgetTypeItem.stream().map(TbWidgetTypeItemV2::getFqn).collect(Collectors.toSet());
            TbWidgetBundleConfigV2 config = new TbWidgetBundleConfigV2(widgetBundle, widgetTypeItem, fqnSet);
            configs.add(config);
        }
        return new TbWidgetBundleConfigCollectionV2(configs);
    }

    private TbWidgetBundleConfigCollectionV2 loadConfigCollection(String jwtToken, TbVersion version) {
        List widgetBundles = this.loadTrendzWidgetBundles(jwtToken);
        List widgetTypes = this.loadTrendzWidgetTypes(jwtToken, version);
        Map widgetTypesMap = widgetTypes.stream().collect(Collectors.toMap(TbWidgetTypeItemV2::getFqn, Function.identity()));
        HashMap<String, Set> typeToBundleListMap = new HashMap<String, Set>();
        HashMap<String, Set> bundleToTypeListMap = new HashMap<String, Set>();
        for (TbWidgetBundleItemV2 widgetBundle : widgetBundles) {
            String alias = widgetBundle.getAlias();
            Set fqns = (Set)DonReactive.block((Mono)this.restDataSource.loadWidgetTypeFqnsByBundleIdV2(widgetBundle.getId().getId(), jwtToken));
            bundleToTypeListMap.computeIfAbsent(alias, i -> new HashSet());
            for (String fqn2 : fqns) {
                typeToBundleListMap.computeIfAbsent(fqn2, i -> new HashSet()).add(alias);
                ((Set)bundleToTypeListMap.get(alias)).add(fqn2);
            }
        }
        ArrayList<TbWidgetBundleConfigV2> configs = new ArrayList<TbWidgetBundleConfigV2>();
        ArrayList<TbWidgetTypeItemV2> headlessWidgetTypes = new ArrayList<TbWidgetTypeItemV2>();
        for (TbWidgetTypeItemV2 widgetType : widgetTypes) {
            String fqn3 = widgetType.getFqn();
            if (typeToBundleListMap.containsKey(fqn3)) continue;
            typeToBundleListMap.put(fqn3, new HashSet());
            headlessWidgetTypes.add(widgetType);
        }
        if (!headlessWidgetTypes.isEmpty()) {
            TbWidgetBundleConfigV2 headlessConfig = new TbWidgetBundleConfigV2(null, headlessWidgetTypes, Collections.emptySet());
            configs.add(headlessConfig);
        }
        for (TbWidgetBundleItemV2 currentBundle : widgetBundles) {
            String alias = currentBundle.getAlias();
            Set fqns = (Set)bundleToTypeListMap.get(alias);
            List<TbWidgetTypeItemV2> currentWidgetTypes = fqns.stream().map(fqn -> widgetTypesMap.getOrDefault(fqn, this.makeBlankItemForUnknownFqn(fqn))).toList();
            TbWidgetBundleConfigV2 config = new TbWidgetBundleConfigV2(currentBundle, currentWidgetTypes, fqns);
            configs.add(config);
        }
        return new TbWidgetBundleConfigCollectionV2(configs);
    }

    private List<TbWidgetBundleItemV2> loadTrendzWidgetBundles(String jwtToken) {
        List allBundles = (List)DonReactive.block((Mono)this.restDataSource.loadAllWidgetBundlesV2(jwtToken));
        assert (allBundles != null);
        ArrayList<TbWidgetBundleItemV2> trendzBundles = new ArrayList<TbWidgetBundleItemV2>();
        for (int i = 0; i < this.maxDuplicatesCount; ++i) {
            Object suffix = i == 0 ? "" : "" + i;
            String alias = "trendz_bundle" + (String)suffix;
            List<TbWidgetBundleItemV2> currentBundles = allBundles.stream().filter(bundleItem -> bundleItem.getAlias().equals(alias)).sorted().toList();
            trendzBundles.addAll(currentBundles);
        }
        return trendzBundles;
    }

    private List<TbWidgetTypeItemV2> loadTrendzWidgetTypes(String jwtToken, TbVersion version) {
        ArrayList<TbWidgetTypeItemV2> trendzTypes = new ArrayList<TbWidgetTypeItemV2>();
        for (String typeFqn : TYPE_FQN_SET) {
            for (int i = 0; i < this.maxDuplicatesCount; ++i) {
                Object suffix;
                String prefix = this.getWidgetPrefixGlobal(version);
                String fqn = prefix + typeFqn + (String)(suffix = i == 0 ? "" : "" + i);
                Optional typeOpt = (Optional)DonReactive.block((Mono)this.restDataSource.loadWidgetTypeLiteByFqnV2(fqn, jwtToken));
                if (!typeOpt.isPresent()) continue;
                TbWidgetTypeItemV2 fullType = (TbWidgetTypeItemV2)DonReactive.block((Mono)this.restDataSource.loadWidgetTypeFullByIdV2(((TbWidgetTypeItemV2)typeOpt.get()).getId().getId(), jwtToken));
                trendzTypes.add(fullType);
            }
        }
        return trendzTypes;
    }

    private TbWidgetTypeItemV2 makeBlankItemForUnknownFqn(String fqn) {
        return TbWidgetTypeItemV2.builder().fqn(fqn).build();
    }

    private TbWidgetBundleConfigCollectionV2 loadWidgetBundleDataForUploading(TbVersion version, String urlPrefix, String companyName, String externalUrl) {
        TbWidgetBundleConfigV2 config = this.loadWidgetBundleFromFile(version);
        TbWidgetBundleItemV2 widgetsBundle = config.getWidgetsBundle();
        List widgetTypes = config.getWidgetTypes();
        for (TbWidgetTypeItemV2 widgetsType : widgetTypes) {
            Map descriptor = (Map)widgetsType.getAdditionalProperties().get("descriptor");
            List resourceList = (List)descriptor.get("resources");
            if (resourceList.isEmpty()) continue;
            Map resource = (Map)resourceList.iterator().next();
            String url = resource.get("url").toString();
            String newUrl = externalUrl + "/" + urlPrefix + url.substring(7);
            resource.put("url", newUrl);
        }
        if (!companyName.equals("Trendz")) {
            String title = this.replaceCompanyLabel(widgetsBundle.getTitle(), companyName);
            String name = this.replaceCompanyLabel(widgetsBundle.getName(), companyName);
            String description = this.replaceCompanyLabel(widgetsBundle.getDescription(), companyName);
            widgetsBundle.setTitle(title);
            widgetsBundle.setName(name);
            widgetsBundle.setDescription(description);
            for (TbWidgetTypeItemV2 widgetsType : widgetTypes) {
                String typeName = this.replaceCompanyLabel(widgetsType.getName(), companyName);
                widgetsType.setName(typeName);
                Map descriptor = (Map)widgetsType.getAdditionalProperties().get("descriptor");
                String typeTemplateHtml = this.replaceCompanyLabel(descriptor.get("templateHtml").toString(), companyName);
                String typeDefaultConfig = this.replaceCompanyLabel(descriptor.get("defaultConfig").toString(), companyName);
                descriptor.put("templateHtml", typeTemplateHtml);
                descriptor.put("defaultConfig", typeDefaultConfig);
            }
        }
        return new TbWidgetBundleConfigCollectionV2(List.of(config));
    }

    private TbWidgetBundleConfigV2 loadWidgetBundleFromFile(TbVersion version) {
        TbVersionNumber versionNumber = version.getVersion();
        try {
            Path path = version.getVersion().less(TbVersionNumber.V_3_6_1) ? Path.of(this.getClass().getClassLoader().getResource("native-widgets-bundle/native_trendz_bundle_ang15__3_6_0.json").toURI()) : (version.getVersion().less(TbVersionNumber.V_3_9_0) ? Path.of(this.getClass().getClassLoader().getResource("native-widgets-bundle/native_trendz_bundle_ang15__3_6_1.json").toURI()) : Path.of(this.getClass().getClassLoader().getResource("native-widgets-bundle/native_trendz_bundle_ang18.json").toURI()));
            String data = Files.readString(path);
            return (TbWidgetBundleConfigV2)JsonUtils.fromJson((String)data, TbWidgetBundleConfigV2.class);
        }
        catch (Exception e) {
            throw new NativeWidgetBundleException("Can not load widget bundle from file, version: " + String.valueOf(versionNumber), (Throwable)e);
        }
    }

    private String replaceCompanyLabel(String input, String companyLabel) {
        if (input == null || companyLabel == null) {
            return input;
        }
        return input.replaceAll("Trendz", companyLabel);
    }

    private TbWidgetBundleConfigV2 validateActualCollection(TbWidgetBundleConfigCollectionV2 configCollection) {
        if (configCollection.isEmpty()) {
            throw new InvalidActualConfiguration("no bundle detected - need just to be installed");
        }
        if (configCollection.size() != 1) {
            throw new InvalidActualConfiguration("bundle/types duplicate detected - check duplicates and SAFELY remove them");
        }
        return (TbWidgetBundleConfigV2)configCollection.getConfigList().iterator().next();
    }

    private void validateActualConfig(TbWidgetBundleConfigV2 config, Map<String, String> expectedToActualMap, TbVersion version) {
        TbWidgetBundleItemV2 widgetsBundle = config.getWidgetsBundle();
        if (widgetsBundle != null && widgetsBundle.isSystem()) {
            throw new InvalidActualConfiguration("the bundle is added by sysadmin - remove it from sysadmin account and create as tenant again");
        }
        List widgetTypes = config.getWidgetTypes();
        Map<String, Long> uniqTypeFqns = widgetTypes.stream().collect(Collectors.groupingBy(TbWidgetTypeItemV2::getFqn, Collectors.counting()));
        Set expectedFqns = TYPE_FQN_SET.stream().map(fqn -> {
            String fullFqn = this.getWidgetPrefixLocal(version) + fqn;
            return (String)((Object)expectedToActualMap.getOrDefault(fullFqn, fullFqn));
        }).collect(Collectors.toSet());
        Set<String> actualFqns = uniqTypeFqns.keySet();
        Sets.SetView difference = Sets.difference(actualFqns, expectedFqns);
        if (!difference.isEmpty()) {
            String message = "unknown widget types were detected (%s) - SAFELY remove them".formatted(difference);
            throw new InvalidActualConfiguration(message);
        }
        Set duplicatedTypes = uniqTypeFqns.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!duplicatedTypes.isEmpty()) {
            String message = "duplicated widget types were detected (%s) - check duplicates and SAFELY remove them".formatted(duplicatedTypes);
            throw new InvalidActualConfiguration(message);
        }
    }

    private boolean compareWidgetBundles(TbWidgetBundleConfigCollectionV2 actualCollection, TbWidgetBundleConfigCollectionV2 expectedCollection, Map<String, String> expectedToActualMap, TbVersion version) {
        boolean equals = true;
        if (actualCollection.size() != expectedCollection.size()) {
            return false;
        }
        int configCount = expectedCollection.size();
        for (int i = 0; i < configCount; ++i) {
            Set expectedFqnSet;
            TbWidgetBundleConfigV2 actualConfig = (TbWidgetBundleConfigV2)actualCollection.getConfigList().get(i);
            TbWidgetBundleConfigV2 expectedConfig = (TbWidgetBundleConfigV2)expectedCollection.getConfigList().get(i);
            Set actualFqnSet = actualConfig.getWidgetTypeFqns();
            if (!actualFqnSet.equals(expectedFqnSet = expectedConfig.getWidgetTypeFqns().stream().map(fqn -> {
                String fullFqn = this.getWidgetPrefixLocal(version) + fqn;
                return (String)((Object)expectedToActualMap.getOrDefault(fullFqn, fullFqn));
            }).collect(Collectors.toSet()))) {
                return false;
            }
            TbWidgetBundleItemV2 actualWidgetsBundle = actualConfig.getWidgetsBundle();
            TbWidgetBundleItemV2 expectedWidgetsBundle = expectedConfig.getWidgetsBundle();
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV2::getAlias, expectedToActualMap);
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV2::getTitle);
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV2::getName);
            boolean bl = equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV2::getDescription);
            if (version.getVersion().less(TbVersionNumber.V_3_6_2)) {
                boolean bl2 = equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV2::getImage);
            }
            if (!equals) {
                return false;
            }
            List actualWidgetTypesJsonList = actualConfig.getWidgetTypes();
            List expectedWidgetTypesJsonList = expectedConfig.getWidgetTypes();
            Map actualBundleWidgetTypesNodeMap = actualWidgetTypesJsonList.stream().collect(Collectors.toMap(TbWidgetTypeItemV2::getFqn, Function.identity()));
            Map expectedBundleWidgetTypesNodeMap = expectedWidgetTypesJsonList.stream().collect(Collectors.toMap(item -> expectedToActualMap.getOrDefault(item.getFqn(), item.getFqn()), Function.identity()));
            Set<String> actualKeySet = actualBundleWidgetTypesNodeMap.keySet();
            Set<String> expectedKeySet = expectedBundleWidgetTypesNodeMap.keySet();
            boolean bl3 = equals = equals && actualKeySet.containsAll(expectedKeySet);
            if (!equals) {
                return false;
            }
            for (String alias : expectedKeySet) {
                TbWidgetTypeItemV2 actualWidgetType = (TbWidgetTypeItemV2)actualBundleWidgetTypesNodeMap.get(alias);
                TbWidgetTypeItemV2 expectedWidgetType = (TbWidgetTypeItemV2)expectedBundleWidgetTypesNodeMap.get(alias);
                equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV2::getFqn, expectedToActualMap);
                boolean bl4 = equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV2::getName);
                if (version.getVersion().less(TbVersionNumber.V_3_6_2)) {
                    equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV2::getImage);
                }
                Map actualDescriptor = (Map)actualWidgetType.getAdditionalProperties().get("descriptor");
                Map expectedDescriptor = (Map)expectedWidgetType.getAdditionalProperties().get("descriptor");
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("templateHtml"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("templateCss"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("controllerScript"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("settingsSchema"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("dataKeySettingsSchema"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("defaultConfig"));
                List actualResourceList = (List)actualDescriptor.get("resources");
                List expectedResourceList = (List)expectedDescriptor.get("resources");
                if (!equals || actualResourceList.size() != expectedResourceList.size()) {
                    return false;
                }
                if (actualResourceList.isEmpty()) continue;
                Object actualResource = actualResourceList.iterator().next();
                Object expectedResource = expectedResourceList.iterator().next();
                equals = equals && this.compareFieldMap(actualResource, expectedResource, item -> item.get("url"));
                if (equals = equals && this.compareFieldMap(actualResource, expectedResource, item -> item.get("isModule"))) continue;
                return false;
            }
        }
        return equals;
    }

    private boolean compareField(TbWidgetBundleItemV2 actualItem, TbWidgetBundleItemV2 expectedItem, Function<TbWidgetBundleItemV2, String> fieldFunction, Map<String, String> expectedToActualMap) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        String actualValue = fieldFunction.apply(actualItem);
        String expectedValue = fieldFunction.apply(expectedItem);
        String translatedExpectedValue = expectedToActualMap.getOrDefault(expectedValue, expectedValue);
        return Objects.equals(actualValue, translatedExpectedValue);
    }

    private boolean compareField(TbWidgetBundleItemV2 actualItem, TbWidgetBundleItemV2 expectedItem, Function<TbWidgetBundleItemV2, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Object actualValue = fieldFunction.apply(actualItem);
        Object expectedValue = fieldFunction.apply(expectedItem);
        return Objects.equals(actualValue, expectedValue);
    }

    private boolean compareField(TbWidgetTypeItemV2 actualItem, TbWidgetTypeItemV2 expectedItem, Function<TbWidgetTypeItemV2, String> fieldFunction, Map<String, String> expectedToActualMap) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        String actualValue = fieldFunction.apply(actualItem);
        String expectedValue = fieldFunction.apply(expectedItem);
        String translatedExpectedValue = expectedToActualMap.getOrDefault(expectedValue, expectedValue);
        return Objects.equals(actualValue, translatedExpectedValue);
    }

    private boolean compareField(TbWidgetTypeItemV2 actualItem, TbWidgetTypeItemV2 expectedItem, Function<TbWidgetTypeItemV2, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Object actualValue = fieldFunction.apply(actualItem);
        Object expectedValue = fieldFunction.apply(expectedItem);
        return Objects.equals(actualValue, expectedValue);
    }

    private boolean compareFieldMap(Object actualItem, Object expectedItem, Function<Map<String, Object>, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Map actualMap = (Map)actualItem;
        Map expectedMap = (Map)expectedItem;
        Object actualValue = fieldFunction.apply(actualMap);
        Object expectedValue = fieldFunction.apply(expectedMap);
        return Objects.equals(actualValue, expectedValue);
    }

    private void mergeHeadlessWidgetTypes(TbWidgetBundleConfigCollectionV2 configCollection) {
        if (configCollection.size() != 2) {
            return;
        }
        List configList = configCollection.getConfigList();
        Optional<TbWidgetBundleConfigV2> headlessConfigOpt = configList.stream().filter(config -> config.getWidgetsBundle() == null).findAny();
        if (headlessConfigOpt.isEmpty()) {
            return;
        }
        TbWidgetBundleConfigV2 headlessConfig = headlessConfigOpt.orElseThrow();
        TbWidgetBundleConfigV2 headfullConfig = configList.stream().filter(config -> config.getWidgetsBundle() != null).findAny().orElseThrow();
        List headlessWidgetTypes = headlessConfig.getWidgetTypes();
        List headfullWidgetTypes = headfullConfig.getWidgetTypes();
        headfullWidgetTypes.addAll(headlessWidgetTypes);
        configList.removeIf(config -> config.getWidgetsBundle() == null);
    }

    private TbWidgetBundleConfigCollectionV2 createWidgetBundleOnTB(TbWidgetBundleConfigCollectionV2 configCollection, String jwtToken) {
        ArrayList<TbWidgetBundleConfigV2> savedConfigList = new ArrayList<TbWidgetBundleConfigV2>();
        for (TbWidgetBundleConfigV2 config : configCollection.getConfigList()) {
            TbWidgetBundleItemV2 widgetsBundle = config.getWidgetsBundle();
            List widgetTypesList = config.getWidgetTypes();
            TbWidgetBundleItemV2 savedWidgetBundle = (TbWidgetBundleItemV2)DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleV2(widgetsBundle, jwtToken));
            assert (savedWidgetBundle != null);
            ArrayList<TbWidgetTypeItemV2> savedWidgetTypes = new ArrayList<TbWidgetTypeItemV2>();
            for (TbWidgetTypeItemV2 widgetType : widgetTypesList) {
                TbWidgetTypeItemV2 savedWidgetType = (TbWidgetTypeItemV2)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV2(widgetType, jwtToken));
                assert (savedWidgetType != null);
                savedWidgetTypes.add(savedWidgetType);
            }
            Set widgetTypeIdSet = savedWidgetTypes.stream().map(TbWidgetTypeItemV2::getId).map(UUIDBased::getId).collect(Collectors.toSet());
            Set widgetTypeFqnSet = savedWidgetTypes.stream().map(TbWidgetTypeItemV2::getFqn).collect(Collectors.toSet());
            DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleJoinsToTypes(savedWidgetBundle.getId().getId(), widgetTypeIdSet, jwtToken));
            TbWidgetBundleConfigV2 savedConfig = new TbWidgetBundleConfigV2(savedWidgetBundle, savedWidgetTypes, widgetTypeFqnSet);
            savedConfigList.add(savedConfig);
        }
        return new TbWidgetBundleConfigCollectionV2(savedConfigList);
    }

    private TbWidgetBundleConfigCollectionV2 updateWidgetBundleOnTB(TbWidgetBundleConfigCollectionV2 actualCollection, TbWidgetBundleConfigCollectionV2 expectedCollection, Map<String, String> expectedToActualMap, String jwtToken) {
        TbWidgetBundleConfigV2 actualConfig = (TbWidgetBundleConfigV2)actualCollection.getConfigList().iterator().next();
        TbWidgetBundleConfigV2 expectedConfig = (TbWidgetBundleConfigV2)expectedCollection.getConfigList().iterator().next();
        TbWidgetBundleItemV2 actualWidgetsBundle = actualConfig.getWidgetsBundle();
        TbWidgetBundleItemV2 expectedWidgetsBundle = expectedConfig.getWidgetsBundle();
        if (actualWidgetsBundle != null) {
            WidgetsBundleId actualBundleId = actualWidgetsBundle.getId();
            TenantId actualBundleTenantId = actualWidgetsBundle.getTenantId();
            String actualBundleAlias = actualWidgetsBundle.getAlias();
            int actualBundleVersion = actualWidgetsBundle.getVersion();
            expectedWidgetsBundle.setId(actualBundleId);
            expectedWidgetsBundle.setTenantId(actualBundleTenantId);
            expectedWidgetsBundle.setAlias(actualBundleAlias);
            expectedWidgetsBundle.setVersion(actualBundleVersion);
        }
        TbWidgetBundleItemV2 savedBundle = (TbWidgetBundleItemV2)DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleV2(expectedWidgetsBundle, jwtToken));
        assert (savedBundle != null);
        List actualWidgetTypes = actualConfig.getWidgetTypes();
        List expectedWidgetTypes = expectedConfig.getWidgetTypes();
        Map actualBundleWidgetTypesMap = actualWidgetTypes.stream().collect(Collectors.toMap(TbWidgetTypeItemV2::getFqn, Function.identity()));
        Map expectedBundleWidgetTypesMap = expectedWidgetTypes.stream().collect(Collectors.toMap(TbWidgetTypeItemV2::getFqn, Function.identity()));
        HashSet<UUID> widgetTypeIdSet = new HashSet<UUID>();
        ArrayList<TbWidgetTypeItemV2> savedWidgetTypes = new ArrayList<TbWidgetTypeItemV2>();
        for (String expectedFqn : expectedBundleWidgetTypesMap.keySet()) {
            String actualFqn = expectedToActualMap.getOrDefault(expectedFqn, expectedFqn);
            TbWidgetTypeItemV2 actualWidgetType = (TbWidgetTypeItemV2)actualBundleWidgetTypesMap.get(actualFqn);
            TbWidgetTypeItemV2 expectedWidgetType = (TbWidgetTypeItemV2)expectedBundleWidgetTypesMap.get(expectedFqn);
            if (actualWidgetType == null) {
                TbWidgetTypeItemV2 savedWidgetType = (TbWidgetTypeItemV2)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV2(expectedWidgetType, jwtToken));
                assert (savedWidgetType != null);
                savedWidgetTypes.add(savedWidgetType);
                widgetTypeIdSet.add(savedWidgetType.getId().getId());
                continue;
            }
            WidgetTypeId typeId = actualWidgetType.getId();
            TenantId typeTenantId = actualWidgetType.getTenantId();
            int typeVersion = actualWidgetType.getVersion();
            expectedWidgetType.setId(typeId);
            expectedWidgetType.setTenantId(typeTenantId);
            expectedWidgetType.setFqn(actualFqn);
            expectedWidgetType.setVersion(typeVersion);
            TbWidgetTypeItemV2 savedWidgetType = (TbWidgetTypeItemV2)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV2(expectedWidgetType, jwtToken));
            assert (savedWidgetType != null);
            savedWidgetTypes.add(savedWidgetType);
            widgetTypeIdSet.add(savedWidgetType.getId().getId());
        }
        DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleJoinsToTypes(savedBundle.getId().getId(), widgetTypeIdSet, jwtToken));
        Set widgetTypeFqnSet = savedWidgetTypes.stream().map(TbWidgetTypeItemV2::getFqn).collect(Collectors.toSet());
        TbWidgetBundleConfigV2 savedConfig = new TbWidgetBundleConfigV2(savedBundle, savedWidgetTypes, widgetTypeFqnSet);
        return new TbWidgetBundleConfigCollectionV2(List.of(savedConfig));
    }
}

