/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.trendz_settings;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.tb.trendz_settings.TrendzSettings;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.ApiKeyService;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class TbTrendzSettingsService {
    private static final Logger log = LoggerFactory.getLogger(TbTrendzSettingsService.class);
    private final AuthenticationService authenticationService;
    private final TbVersionChecker versionChecker;
    private final CustomizationService customizationService;
    private final TbRestDataSource restDataSource;
    private final ApiKeyService apiKeyService;

    @Autowired
    public TbTrendzSettingsService(AuthenticationService authenticationService, TbVersionChecker versionChecker, CustomizationService customizationService, TbRestDataSource restDataSource, ApiKeyService apiKeyService) {
        this.authenticationService = authenticationService;
        this.versionChecker = versionChecker;
        this.customizationService = customizationService;
        this.restDataSource = restDataSource;
        this.apiKeyService = apiKeyService;
    }

    public TbResourceStatus checkSettings(JwtSecurityUser user, String domain, String url) {
        String jwtToken = this.authenticationService.getToken(user);
        TbVersion version = this.versionChecker.getVersion(jwtToken);
        if (version.getVersion().less(TbVersionNumber.V_4_1_0)) {
            return TbResourceStatus.NOT_SUPPORTED_TB_VERSION;
        }
        TrendzSettings expectedData = this.expectedData(user, domain, url);
        TrendzSettings actualData = this.actualData(jwtToken);
        if (TrendzSettings.BLANK_SETTINGS.equals((Object)actualData)) {
            return TbResourceStatus.DO_NOT_EXIST;
        }
        if (!actualData.equals((Object)expectedData)) {
            return TbResourceStatus.OUTDATED;
        }
        return TbResourceStatus.LATEST;
    }

    public UploadTbResourceStatus refreshSettings(JwtSecurityUser user, String domain, String url) {
        String jwtToken = this.authenticationService.getToken(user);
        TbVersion version = this.versionChecker.getVersion(jwtToken);
        if (version.getVersion().less(TbVersionNumber.V_4_1_0)) {
            return UploadTbResourceStatus.NOT_SUPPORTED_TB_VERSION;
        }
        TrendzSettings expectedData = this.expectedData(user, domain, url);
        TrendzSettings actualData = this.actualData(jwtToken);
        if (actualData.equals((Object)expectedData)) {
            return UploadTbResourceStatus.ALREADY_EXISTS;
        }
        TrendzSettings saved = this.saveData(jwtToken, expectedData);
        if (TrendzSettings.BLANK_SETTINGS.equals((Object)actualData)) {
            return UploadTbResourceStatus.CREATED;
        }
        return UploadTbResourceStatus.UPDATED;
    }

    private TrendzSettings expectedData(JwtSecurityUser user, String domain, String url) {
        CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
        String urlPrefix = customViewSettings.getUrl();
        String fullUrl = url.replaceAll("/$", "") + "/" + urlPrefix;
        String apiToken = this.apiKeyService.getApiKeyByTenantId(user.getTenantId());
        return new TrendzSettings(true, fullUrl, apiToken);
    }

    private TrendzSettings actualData(String jwtToken) {
        return (TrendzSettings)DonReactive.block((Mono)this.restDataSource.loadTbTrendzSettings(jwtToken));
    }

    private TrendzSettings saveData(String jwtToken, TrendzSettings settings) {
        return (TrendzSettings)DonReactive.block((Mono)this.restDataSource.saveTbTrendzSettings(settings, jwtToken));
    }
}

