/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.module;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.tb.module.TbModuleService;
import org.thingsboard.trendz.service.tb.module.TbModuleServiceImpl;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class TbModuleServiceImpl
implements TbModuleService {
    private final AuthenticationService authenticationService;
    private final CustomizationService customizationService;
    private final TbRestDataSource restDataSource;
    private final byte[] currentModule;

    @Autowired
    public TbModuleServiceImpl(AuthenticationService authenticationService, CustomizationService customizationService, TbRestDataSource restDataSource) {
        this.authenticationService = authenticationService;
        this.customizationService = customizationService;
        this.restDataSource = restDataSource;
        try {
            ClassPathResource resource = new ClassPathResource("modules/trendz-ai-summary.js");
            this.currentModule = Files.readAllBytes(resource.getFile().toPath());
        }
        catch (IOException e) {
            throw new TrendzException("Failed to load module file", (Throwable)e);
        }
    }

    public TbResourceStatus getModuleStatus(JwtSecurityUser user, String domain) {
        String jwtToken = this.authenticationService.getToken(user);
        return (TbResourceStatus)this.getStatusResourcePair(user, jwtToken, domain).getLeft();
    }

    public UploadTbResourceStatus uploadModule(JwtSecurityUser user, String domain) {
        String jwtToken = this.authenticationService.getToken(user);
        Pair tbResourceStatusUuidPair = this.getStatusResourcePair(user, jwtToken, domain);
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$tb$widget$base$TbResourceStatus[((TbResourceStatus)tbResourceStatusUuidPair.getLeft()).ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> UploadTbResourceStatus.NOT_SUPPORTED_TB_VERSION;
            case 2 -> {
                DonReactive.block((Mono)this.restDataSource.uploadTbResource(jwtToken, this.generateTbResource(user, domain)));
                yield UploadTbResourceStatus.CREATED;
            }
            case 3 -> {
                TbResource tbResource = (TbResource)tbResourceStatusUuidPair.getRight();
                tbResource.setData(this.currentModule);
                DonReactive.block((Mono)this.restDataSource.uploadTbResource(jwtToken, tbResource));
                yield UploadTbResourceStatus.UPDATED;
            }
            case 4 -> UploadTbResourceStatus.ALREADY_EXISTS;
            case 5 -> throw new IllegalStateException();
        };
    }

    private Pair<TbResourceStatus, TbResource> getStatusResourcePair(JwtSecurityUser user, String jwtToken, String domain) {
        TbVersion tbVersion = this.restDataSource.getTbVersionValidating(jwtToken);
        if (tbVersion.getVersion().less(TbVersionNumber.V_3_9_0)) {
            return Pair.of((Object)TbResourceStatus.NOT_SUPPORTED_TB_VERSION, null);
        }
        Optional tbResource = (Optional)DonReactive.block((Mono)this.restDataSource.getResourceByName(jwtToken, this.generateTitle(user, domain)));
        return tbResource.map(resource -> Pair.of((Object)(Arrays.equals(this.currentModule, resource.getData()) ? TbResourceStatus.LATEST : TbResourceStatus.OUTDATED), (Object)resource)).orElse(Pair.of((Object)TbResourceStatus.DO_NOT_EXIST, null));
    }

    private TbResource generateTbResource(JwtSecurityUser user, String domain) {
        TbResource tbResource = new TbResource();
        tbResource.setData(this.currentModule);
        tbResource.setFileName("ai-summary-module.js");
        tbResource.setResourceType(ResourceType.JS_MODULE);
        tbResource.setResourceSubType(ResourceSubType.MODULE);
        tbResource.setTitle(this.generateTitle(user, domain));
        return tbResource;
    }

    private String generateTitle(JwtSecurityUser user, String domain) {
        CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
        String urlPrefix = customViewSettings.getUrl();
        String companyName = this.customizationService.getCompanyName(urlPrefix);
        return "%s %s".formatted(companyName, " AI Summary Module");
    }
}

