/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;

public class TaskSequence
implements TrendzEntity {
    private UUID id;
    private JwtSecurityUser user;
    private long createdTs;
    private long updatedTs;
    private String name;
    private boolean enabled;
    private TaskSchedule schedule;
    private List<TaskSequenceItem> sequenceItems;

    public TaskSequence(TaskSequence that) {
        this.id = that.id;
        this.user = that.user == null ? null : new JwtSecurityUser(that.user);
        this.createdTs = that.createdTs;
        this.updatedTs = that.updatedTs;
        this.name = that.name;
        this.enabled = that.enabled;
        this.schedule = new TaskSchedule(that.schedule);
        this.sequenceItems = that.sequenceItems == null ? null : that.sequenceItems.stream().map(TaskSequenceItem::new).sorted().collect(Collectors.toList());
    }

    @JsonIgnore
    public UUID getTenantId() {
        return this.user.getTenantId();
    }

    public static TaskSequenceBuilder builder() {
        return new TaskSequenceBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public JwtSecurityUser getUser() {
        return this.user;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getUpdatedTs() {
        return this.updatedTs;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    public List<TaskSequenceItem> getSequenceItems() {
        return this.sequenceItems;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    public void setSequenceItems(List<TaskSequenceItem> sequenceItems) {
        this.sequenceItems = sequenceItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSequence)) {
            return false;
        }
        TaskSequence other = (TaskSequence)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskSchedule this$schedule = this.getSchedule();
        TaskSchedule other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        List this$sequenceItems = this.getSequenceItems();
        List other$sequenceItems = other.getSequenceItems();
        return !(this$sequenceItems == null ? other$sequenceItems != null : !((Object)this$sequenceItems).equals(other$sequenceItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskSchedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        List $sequenceItems = this.getSequenceItems();
        result = result * 59 + ($sequenceItems == null ? 43 : ((Object)$sequenceItems).hashCode());
        return result;
    }

    public String toString() {
        return "TaskSequence(id=" + String.valueOf(this.getId()) + ", user=" + String.valueOf(this.getUser()) + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", schedule=" + String.valueOf(this.getSchedule()) + ", sequenceItems=" + String.valueOf(this.getSequenceItems()) + ")";
    }

    public TaskSequence() {
    }

    public TaskSequence(UUID id, JwtSecurityUser user, long createdTs, long updatedTs, String name, boolean enabled, TaskSchedule schedule, List<TaskSequenceItem> sequenceItems) {
        this.id = id;
        this.user = user;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.sequenceItems = sequenceItems;
    }
}

