/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgressStep;

public class TaskExecutionProgressStep
implements Comparable<TaskExecutionProgressStep> {
    private UUID id;
    private UUID taskExecutionId;
    private UUID parentStepId;
    private List<TaskExecutionProgressStep> childrenSteps;
    private String name;
    private long startTs;
    private long finishTs;

    public TaskExecutionProgressStep(TaskExecutionProgressStep that) {
        this.id = that.id;
        this.taskExecutionId = that.taskExecutionId;
        this.parentStepId = that.parentStepId;
        this.childrenSteps = that.childrenSteps == null ? null : that.childrenSteps.stream().map(TaskExecutionProgressStep::new).collect(Collectors.toList());
        this.name = that.name;
        this.startTs = that.startTs;
        this.finishTs = that.finishTs;
    }

    @Override
    public int compareTo(TaskExecutionProgressStep that) {
        return Long.compare(this.startTs, that.startTs);
    }

    public static TaskExecutionProgressStepBuilder builder() {
        return new TaskExecutionProgressStepBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public UUID getParentStepId() {
        return this.parentStepId;
    }

    public List<TaskExecutionProgressStep> getChildrenSteps() {
        return this.childrenSteps;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getFinishTs() {
        return this.finishTs;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTaskExecutionId(UUID taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
    }

    public void setParentStepId(UUID parentStepId) {
        this.parentStepId = parentStepId;
    }

    public void setChildrenSteps(List<TaskExecutionProgressStep> childrenSteps) {
        this.childrenSteps = childrenSteps;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionProgressStep)) {
            return false;
        }
        TaskExecutionProgressStep other = (TaskExecutionProgressStep)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$taskExecutionId = this.getTaskExecutionId();
        UUID other$taskExecutionId = other.getTaskExecutionId();
        if (this$taskExecutionId == null ? other$taskExecutionId != null : !((Object)this$taskExecutionId).equals(other$taskExecutionId)) {
            return false;
        }
        UUID this$parentStepId = this.getParentStepId();
        UUID other$parentStepId = other.getParentStepId();
        if (this$parentStepId == null ? other$parentStepId != null : !((Object)this$parentStepId).equals(other$parentStepId)) {
            return false;
        }
        List this$childrenSteps = this.getChildrenSteps();
        List other$childrenSteps = other.getChildrenSteps();
        if (this$childrenSteps == null ? other$childrenSteps != null : !((Object)this$childrenSteps).equals(other$childrenSteps)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionProgressStep;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $taskExecutionId = this.getTaskExecutionId();
        result = result * 59 + ($taskExecutionId == null ? 43 : ((Object)$taskExecutionId).hashCode());
        UUID $parentStepId = this.getParentStepId();
        result = result * 59 + ($parentStepId == null ? 43 : ((Object)$parentStepId).hashCode());
        List $childrenSteps = this.getChildrenSteps();
        result = result * 59 + ($childrenSteps == null ? 43 : ((Object)$childrenSteps).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "TaskExecutionProgressStep(id=" + String.valueOf(this.getId()) + ", taskExecutionId=" + String.valueOf(this.getTaskExecutionId()) + ", parentStepId=" + String.valueOf(this.getParentStepId()) + ", childrenSteps=" + String.valueOf(this.getChildrenSteps()) + ", name=" + this.getName() + ", startTs=" + this.getStartTs() + ", finishTs=" + this.getFinishTs() + ")";
    }

    public TaskExecutionProgressStep() {
    }

    public TaskExecutionProgressStep(UUID id, UUID taskExecutionId, UUID parentStepId, List<TaskExecutionProgressStep> childrenSteps, String name, long startTs, long finishTs) {
        this.id = id;
        this.taskExecutionId = taskExecutionId;
        this.parentStepId = parentStepId;
        this.childrenSteps = childrenSteps;
        this.name = name;
        this.startTs = startTs;
        this.finishTs = finishTs;
    }
}

