/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.UUID;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgress;
import org.thingsboard.trendz.service.task.model.TaskExecutionStatus;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.tools.json.JsonRawDeserializer;
import org.thingsboard.trendz.tools.json.JsonRawSerializer;

public class TaskExecution
implements Comparable<TaskExecution> {
    private UUID id;
    private UUID taskId;
    private JwtSecurityUser user;
    private TaskExecutionStatus status;
    private long createdTs;
    private long startTs;
    private long finishTs;
    private long duration;
    private TaskJobType jobType;
    private TaskJob job;
    @JsonSerialize(using=JsonRawSerializer.class)
    @JsonDeserialize(using=JsonRawDeserializer.class)
    private String jsonResult;
    private TaskExecutionProgress taskExecutionProgress;

    public TaskExecution(TaskExecution that) {
        this.id = that.id;
        this.taskId = that.taskId;
        this.user = that.user == null ? null : new JwtSecurityUser(that.user);
        this.status = that.status;
        this.createdTs = that.createdTs;
        this.startTs = that.startTs;
        this.finishTs = that.finishTs;
        this.duration = that.duration;
        this.jobType = that.jobType;
        this.job = that.job.clone();
        this.jsonResult = that.jsonResult;
        this.taskExecutionProgress = that.taskExecutionProgress == null ? null : new TaskExecutionProgress(that.taskExecutionProgress);
    }

    @Override
    public int compareTo(TaskExecution that) {
        return Long.compare(this.createdTs, that.createdTs);
    }

    public static TaskExecutionBuilder builder() {
        return new TaskExecutionBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public JwtSecurityUser getUser() {
        return this.user;
    }

    public TaskExecutionStatus getStatus() {
        return this.status;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getFinishTs() {
        return this.finishTs;
    }

    public long getDuration() {
        return this.duration;
    }

    public TaskJobType getJobType() {
        return this.jobType;
    }

    public TaskJob getJob() {
        return this.job;
    }

    public String getJsonResult() {
        return this.jsonResult;
    }

    public TaskExecutionProgress getTaskExecutionProgress() {
        return this.taskExecutionProgress;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    public void setStatus(TaskExecutionStatus status) {
        this.status = status;
    }

    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setJobType(TaskJobType jobType) {
        this.jobType = jobType;
    }

    public void setJob(TaskJob job) {
        this.job = job;
    }

    @JsonDeserialize(using=JsonRawDeserializer.class)
    public void setJsonResult(String jsonResult) {
        this.jsonResult = jsonResult;
    }

    public void setTaskExecutionProgress(TaskExecutionProgress taskExecutionProgress) {
        this.taskExecutionProgress = taskExecutionProgress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecution)) {
            return false;
        }
        TaskExecution other = (TaskExecution)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        TaskExecutionStatus this$status = this.getStatus();
        TaskExecutionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TaskJobType this$jobType = this.getJobType();
        TaskJobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        TaskJob this$job = this.getJob();
        TaskJob other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$jsonResult = this.getJsonResult();
        String other$jsonResult = other.getJsonResult();
        if (this$jsonResult == null ? other$jsonResult != null : !this$jsonResult.equals(other$jsonResult)) {
            return false;
        }
        TaskExecutionProgress this$taskExecutionProgress = this.getTaskExecutionProgress();
        TaskExecutionProgress other$taskExecutionProgress = other.getTaskExecutionProgress();
        return !(this$taskExecutionProgress == null ? other$taskExecutionProgress != null : !this$taskExecutionProgress.equals(other$taskExecutionProgress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        TaskExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TaskJobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        TaskJob $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $jsonResult = this.getJsonResult();
        result = result * 59 + ($jsonResult == null ? 43 : $jsonResult.hashCode());
        TaskExecutionProgress $taskExecutionProgress = this.getTaskExecutionProgress();
        result = result * 59 + ($taskExecutionProgress == null ? 43 : $taskExecutionProgress.hashCode());
        return result;
    }

    public String toString() {
        return "TaskExecution(id=" + String.valueOf(this.getId()) + ", taskId=" + String.valueOf(this.getTaskId()) + ", user=" + String.valueOf(this.getUser()) + ", status=" + String.valueOf(this.getStatus()) + ", createdTs=" + this.getCreatedTs() + ", startTs=" + this.getStartTs() + ", finishTs=" + this.getFinishTs() + ", duration=" + this.getDuration() + ", jobType=" + String.valueOf(this.getJobType()) + ", job=" + String.valueOf(this.getJob()) + ", jsonResult=" + this.getJsonResult() + ", taskExecutionProgress=" + String.valueOf(this.getTaskExecutionProgress()) + ")";
    }

    public TaskExecution() {
    }

    public TaskExecution(UUID id, UUID taskId, JwtSecurityUser user, TaskExecutionStatus status, long createdTs, long startTs, long finishTs, long duration, TaskJobType jobType, TaskJob job, String jsonResult, TaskExecutionProgress taskExecutionProgress) {
        this.id = id;
        this.taskId = taskId;
        this.user = user;
        this.status = status;
        this.createdTs = createdTs;
        this.startTs = startTs;
        this.finishTs = finishTs;
        this.duration = duration;
        this.jobType = jobType;
        this.job = job;
        this.jsonResult = jsonResult;
        this.taskExecutionProgress = taskExecutionProgress;
    }
}

