/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job.metric;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.metric.agent.developer.PythonDeveloperExpertAgent;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;
import org.thingsboard.trendz.service.metric.topology.TopologyDetailsService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionImplementationJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionImplementationContent;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class MetricDefinitionImplementationJobExecutor
implements TaskJobExecutor {
    private final MetricExplorationService metricExplorationService;
    private final Scheduler threadPoolScheduler;
    private final BusinessEntityService businessEntityService;
    private final ItemDetailsService itemDetailsService;
    private final TopologyDetailsService topologyDetailsService;
    private final PythonDeveloperExpertAgent pythonDeveloperExpertAgent;

    @Autowired
    public MetricDefinitionImplementationJobExecutor(MetricExplorationService metricExplorationService, ExecutorManagementService executorManagementService, BusinessEntityService businessEntityService, ItemDetailsService itemDetailsService, TopologyDetailsService topologyDetailsService, PythonDeveloperExpertAgent pythonDeveloperExpertAgent) {
        this.metricExplorationService = metricExplorationService;
        this.businessEntityService = businessEntityService;
        this.itemDetailsService = itemDetailsService;
        this.topologyDetailsService = topologyDetailsService;
        this.pythonDeveloperExpertAgent = pythonDeveloperExpertAgent;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"metric calculation generator processor");
    }

    public TaskJobType getJobType() {
        return TaskJobType.METRIC_DEFINITION_IMPLEMENT;
    }

    public Class<MetricDefinitionImplementationJob> getJobClass() {
        return MetricDefinitionImplementationJob.class;
    }

    public MetricDefinitionImplementationContent createProgressContent() {
        return new MetricDefinitionImplementationContent();
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        MetricDefinitionImplementationJob job = (MetricDefinitionImplementationJob)this.mapJob(taskJob);
        MetricDefinitionImplementationContent mutableContent = (MetricDefinitionImplementationContent)progressBuilder.getMutableContent();
        try (TaskExecutionProgressStepBuilder step = progressBuilder.makeStep("Metric calculation generation");){
            String source;
            TaskExecutionProgressStepBuilder stepPrepareMetadata = step.makeStep("Prepare metadata");
            mutableContent.setState(MetricDefinitionImplementationContent.State.PREPARE_METADATA);
            MetricDefinition metricDefinition = this.metricExplorationService.getMetricDefinitionById(job.getMetricDefinitionId(), user);
            ArrayList agentMetadataContainer = new ArrayList();
            BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, metricDefinition.getBusinessEntityId()).orElseThrow(() -> new BusinessEntityNotFoundException(metricDefinition.getBusinessEntityId(), user.getTenantId()));
            ZoneId zoneId = DateTimeUtils.fromTzName((String)job.getTzName());
            stepPrepareMetadata.close();
            if (metricDefinition.isAdvancedMode()) {
                TaskExecutionProgressStepBuilder stepPrepareTopologyData = step.makeStep("Prepare topology data");
                mutableContent.setState(MetricDefinitionImplementationContent.State.PREPARE_TOPOLOGY_DATA);
                source = this.topologyDetailsService.mapWideTopologyForItem(businessEntity.getId(), user);
                stepPrepareTopologyData.close();
            } else {
                TaskExecutionProgressStepBuilder stepLoadItemDetails = step.makeStep("Load item details");
                mutableContent.setState(MetricDefinitionImplementationContent.State.LOAD_ITEM_DETAILS);
                source = this.itemDetailsService.loadItemDetailsAsString(user, businessEntity, metricDefinition.getItem().getId(), job.getDatePickerConfig(), zoneId);
                stepLoadItemDetails.close();
            }
            TestResult testResult = this.pythonDeveloperExpertAgent.calculateMetric(step, metricDefinition, user, source, businessEntity, agentMetadataContainer, job.getDatePickerConfig(), zoneId, List.of("Implement metric definition."));
            this.metricExplorationService.save(metricDefinition);
            Mono mono = Mono.just((Object)testResult);
            return mono;
        }
    }
}

