/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job.metric;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.metric.MetricCreationResult;
import org.thingsboard.trendz.domain.metric.MetricFinderRequest;
import org.thingsboard.trendz.domain.metric.MetricGenerationResult;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionGenerateJob;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionGenerateJobExecutor;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionGenerateContent;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class MetricDefinitionGenerateJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(MetricDefinitionGenerateJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final MetricExplorationService metricExplorationService;

    @Autowired
    public MetricDefinitionGenerateJobExecutor(ExecutorManagementService executorManagementService, MetricExplorationService metricExplorationService) {
        this.metricExplorationService = metricExplorationService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"metric finder processor");
    }

    public TaskJobType getJobType() {
        return TaskJobType.METRIC_DEFINITION_GENERATE;
    }

    public Class<MetricDefinitionGenerateJob> getJobClass() {
        return MetricDefinitionGenerateJob.class;
    }

    public MetricDefinitionGenerateContent createProgressContent() {
        return new MetricDefinitionGenerateContent();
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        MetricDefinitionGenerateJob metricDefinitionGenerateJob = (MetricDefinitionGenerateJob)this.mapJob(taskJob);
        MetricDefinitionGenerateContent mutableContent = (MetricDefinitionGenerateContent)progressBuilder.getMutableContent();
        MetricFinderRequest metricFinderRequest = metricDefinitionGenerateJob.getMetricFinderRequest();
        UUID businessEntityId = metricDefinitionGenerateJob.getBusinessEntityId();
        UUID itemId = metricDefinitionGenerateJob.getItemId();
        return ((Mono)progressBuilder.makeStep("Metric definition generation", stepBuilder -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$metric$MetricFinderRequest$Mode[metricFinderRequest.getMode().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                MetricFinderRequest.AiSuggestionsRequest request = metricFinderRequest.getAiSuggestionsRequest();
                MetricGenerationResult result = this.metricExplorationService.generateMetricDefinitions(stepBuilder, user, businessEntityId, itemId, metricFinderRequest.getDatePickerConfig(), metricFinderRequest.getZoneId(), request.getCountSimple(), request.getCountAdvanced(), request.getSeed());
                yield Mono.just((Object)result);
            }
            case 2 -> {
                MetricFinderRequest.ManualRequest request = metricFinderRequest.getManualRequest();
                MetricCreationResult result = this.metricExplorationService.create(stepBuilder, user, businessEntityId, itemId, metricFinderRequest.getDatePickerConfig(), metricFinderRequest.getZoneId(), request.getName(), request.getDescription(), request.isAdvancedMode());
                yield Mono.just((Object)result);
            }
        })).doOnNext(o -> log.info("Metric definition generation completed"));
    }
}

