/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class ViewReportBuildJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(ViewReportBuildJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final ViewBuildingService viewBuildingService;

    @Autowired
    public ViewReportBuildJobExecutor(ExecutorManagementService executorManagementService, ViewBuildingService viewBuildingService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.UI_BUILD);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"view report build scheduler");
        this.viewBuildingService = viewBuildingService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.VIEW_REPORT_BUILD;
    }

    public Class<ViewReportBuildJob> getJobClass() {
        return ViewReportBuildJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        ViewReportBuildJob job = (ViewReportBuildJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        ViewConfig viewConfig = job.getViewConfig();
        viewConfig.setRequestPriority(RequestPriority.HIGH);
        return this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(ViewBuildingResult::getViewReport);
    }
}

