/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.exception.service.topology.TopologyRefreshException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.TopologyDiscoveryJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import org.thingsboard.trendz.service.topology.TopologyDiscoveryService;
import org.thingsboard.trendz.service.topology.TopologyMergeService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class TopologyDiscoveryJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(TopologyDiscoveryJobExecutor.class);
    private final BusinessEntityService businessEntityService;
    private final TopologyDiscoveryService topologyDiscoveryService;
    private final TopologyMergeService topologyMergeService;
    private final Scheduler threadPoolScheduler;
    private final Cache tenantInitStatusCache;

    @Autowired
    public TopologyDiscoveryJobExecutor(ExecutorManagementService executorManagementService, BusinessEntityService businessEntityService, TopologyDiscoveryService topologyDiscoveryService, TopologyMergeService topologyMergeService, CacheService cacheService) {
        this.businessEntityService = businessEntityService;
        this.topologyDiscoveryService = topologyDiscoveryService;
        this.topologyMergeService = topologyMergeService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.TOPOLOGY_DISCOVERY);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"topology discovery scheduler");
        this.tenantInitStatusCache = cacheService.getCache(CacheConfigurationName.tenantInitStatusCacheName);
    }

    public TaskJobType getJobType() {
        return TaskJobType.TOPOLOGY_DISCOVERY;
    }

    public Class<TopologyDiscoveryJob> getJobClass() {
        return TopologyDiscoveryJob.class;
    }

    public Class<TopologyDiscoveryProgressContent> getProgressContentClass() {
        return TopologyDiscoveryProgressContent.class;
    }

    public TaskExecutionProgressContent createProgressContent() {
        return new TopologyDiscoveryProgressContent();
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        TopologyDiscoveryJob job = (TopologyDiscoveryJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        DiscoverConfig discoverConfig = job.getDiscoverConfig();
        return (Mono)progressBuilder.makeStep("Topology discovery", stepBuilder -> Mono.just((Object)new Object()).map(o -> {
            TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)stepBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
            mutableContent.setStartTs(System.currentTimeMillis());
            mutableContent.setDiscoverConfig(discoverConfig);
            mutableContent.setCurrentState("Starting");
            List oldEntities = this.businessEntityService.getAllEntities(user);
            List freshTopology = this.topologyDiscoveryService.discoverTopology(stepBuilder, discoverConfig, user);
            List mergedTopology = this.topologyMergeService.merge(stepBuilder, (Collection)oldEntities, (Collection)freshTopology);
            this.businessEntityService.saveAllEntities(mergedTopology, user);
            mutableContent.setCurrentState("Finished");
            this.refreshStatusSuccess(user);
            String message = "Topology discovery completed for tenant: " + String.valueOf(user.getTenantId());
            log.info(message);
            return message;
        }).onErrorMap(e -> new TopologyRefreshException("Topology refresh error", e)));
    }

    public void doOnError(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder rootStepBuilder) {
        this.refreshStatusFailed(user);
    }

    public void doOnCancel(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        this.refreshStatusFailed(user);
    }

    private void refreshStatusSuccess(JwtSecurityUser user) {
        InitStatus initStatus = InitStatus.builder().inited(true).inProgress(false).executionId(null).build();
        this.tenantInitStatusCache.put((Object)user.getTenantCustomerKey(), (Object)initStatus);
    }

    private void refreshStatusFailed(JwtSecurityUser user) {
        this.tenantInitStatusCache.evict((Object)user.getTenantCustomerKey());
    }
}

