/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.startup.TrendzStartupService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.TestJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.progress_content.DefaultJobProgressContent;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class TestJobExecutor
implements TaskJobExecutor,
TrendzStartupService {
    private static final Logger log = LoggerFactory.getLogger(TestJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private TestJobExecutor selfProxy;

    @Autowired
    public TestJobExecutor(ExecutorManagementService executorManagementService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.UI_BUILD);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"test scheduler");
    }

    public void onStartup(ApplicationContext context) {
        this.selfProxy = (TestJobExecutor)context.getBean(TestJobExecutor.class);
    }

    public int priority() {
        return 20;
    }

    public TaskJobType getJobType() {
        return TaskJobType.TEST;
    }

    public Class<TestJob> getJobClass() {
        return TestJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        TestJob job = (TestJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        String input = job.getInput();
        TaskExecutionProgressStepBuilder step1 = progressBuilder.makeStep("Execution 1");
        TaskExecutionProgressStepBuilder step11 = step1.makeStep("Execution 1 - sub-step 1");
        this.sleep(1);
        step11.close();
        TaskExecutionProgressStepBuilder step12 = step1.makeStep("Execution 1 - sub-step 2");
        this.sleep(1);
        step1.close();
        try (TaskExecutionProgressStepBuilder step2 = progressBuilder.makeStep("Execution 2");){
            try (TaskExecutionProgressStepBuilder step21 = step2.makeStep("Execution 2 - sub-step 1");){
                this.sleep(1);
            }
            try (TaskExecutionProgressStepBuilder step22 = step2.makeStep("Execution 2 - sub-step 2");){
                this.sleep(1);
            }
        }
        TaskExecutionProgressStepBuilder step3 = progressBuilder.makeStep("Execution 3");
        this.selfProxy.publicSubtaskForDecoratorWithVoid("publicSubtaskForDecoratorWithVoid");
        this.selfProxy.publicSubtaskForDecoratorWithVoid(step3, "publicSubtaskForDecoratorWithVoid2");
        String resultStep3_1 = this.selfProxy.publicSubtaskForDecoratorWithReturnType(step3, "publicSubtaskForDecoratorWithReturnType");
        String resultStep3_2 = (String)DonReactive.block((Mono)this.selfProxy.publicSubtaskForDecoratorWithReturnMonoType(step3, "publicSubtaskForDecoratorWithReturnMonoType"));
        String resultStep3_3 = (String)DonReactive.block((Mono)this.selfProxy.publicSubtaskForDecoratorWithReturnFluxType(step3, "publicSubtaskForDecoratorWithReturnFluxType").collectList().map(list -> StringUtils.join((Iterable)list, (String)", ")));
        step3.close();
        TaskExecutionProgressStepBuilder step4 = progressBuilder.makeStep("Execution 4");
        return Mono.just((Object)input).flatMap(i -> {
            step4.makeStep("Execution 4 - sub-step 1", () -> this.subtasksSimpleVoid());
            step4.makeStep("Execution 4 - sub-step 2", stepBuilder -> this.subtasksSimpleVoid());
            String result = (String)step4.makeStep("Execution 4 - sub-step 3", stepBuilder -> this.subtasksSimpleReturn());
            Mono resultMono1 = step4.makeStep("Execution 4 - sub-step 4", this.subtaskReactiveMono("sub-step 4"));
            Mono resultMono2 = resultMono1.flatMap(o -> (Mono)step4.makeStep("Execution 4 - sub-step 5", stepBuilder -> this.subtaskReactiveMono("sub-step 5")));
            return resultMono2;
        }).flatMap(result -> step4.makeStep("Execution 4 - sub-step 6", this.subtaskReactiveFlux("sub-step 6")).collectList().map(list -> StringUtils.join((Iterable)list, (String)", "))).flatMap(result -> ((Flux)step4.makeStep("Execution 4 - sub-step 7", stepBuilder -> this.subtaskReactiveFlux("sub-step 7"))).collectList().map(list -> StringUtils.join((Iterable)list, (String)", "))).doOnSuccess(o -> {
            step4.close();
            log.info("Finished = {}", (Object)progressBuilder);
        }).doOnError(t -> {
            step4.close();
            log.info("Failed = {}", (Object)progressBuilder);
        });
    }

    @TaskExecutionProgressDecorator(name="Execution 3 - decorator + no step builder")
    public void publicSubtaskForDecoratorWithVoid(String input) {
        this.sleep(1);
    }

    @TaskExecutionProgressDecorator(name="Execution 3 - decorator + void")
    public void publicSubtaskForDecoratorWithVoid(TaskExecutionProgressStepBuilder stepBuilder, String input) {
        this.sleep(1);
        DefaultJobProgressContent stepContent = (DefaultJobProgressContent)stepBuilder.getStepContent(DefaultJobProgressContent.class);
        Properties properties = stepContent.getProperties();
        properties.put("publicSubtaskForDecoratorWithVoid2", input);
    }

    @TaskExecutionProgressDecorator(name="Execution 3 - decorator + return type")
    public String publicSubtaskForDecoratorWithReturnType(TaskExecutionProgressStepBuilder stepBuilder, String input) {
        this.sleep(1);
        DefaultJobProgressContent stepContent = (DefaultJobProgressContent)stepBuilder.getStepContent(DefaultJobProgressContent.class);
        Properties properties = stepContent.getProperties();
        properties.put("publicSubtaskForDecoratorWithReturnType", input);
        return input;
    }

    @TaskExecutionProgressDecorator(name="Execution 3 - decorator + mono type")
    public Mono<String> publicSubtaskForDecoratorWithReturnMonoType(TaskExecutionProgressStepBuilder stepBuilder, String input) {
        this.sleep(1);
        DefaultJobProgressContent stepContent = (DefaultJobProgressContent)stepBuilder.getStepContent(DefaultJobProgressContent.class);
        Properties properties = stepContent.getProperties();
        properties.put("publicSubtaskForDecoratorWithReturnMonoType", input);
        return Mono.just((Object)new Object()).doOnNext(o -> this.sleep(1)).map(o -> input);
    }

    @TaskExecutionProgressDecorator(name="Execution 3 - decorator + flux type")
    public Flux<String> publicSubtaskForDecoratorWithReturnFluxType(TaskExecutionProgressStepBuilder stepBuilder, String input) {
        this.sleep(1);
        DefaultJobProgressContent stepContent = (DefaultJobProgressContent)stepBuilder.getStepContent(DefaultJobProgressContent.class);
        Properties properties = stepContent.getProperties();
        properties.put("publicSubtaskForDecoratorWithReturnFluxType", input);
        return Flux.fromIterable(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).doOnNext(o -> this.sleep(1)).map(o -> input + " " + o);
    }

    private void subtasksSimpleVoid() {
        this.sleep(1);
    }

    private String subtasksSimpleReturn() {
        this.sleep(1);
        return "subtasksSimpleReturn";
    }

    private Mono<String> subtaskReactiveMono(String input) {
        return Mono.create(sink -> {
            try {
                this.sleep(1);
                sink.success((Object)input);
            }
            catch (Exception e) {
                sink.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }).doOnNext(o -> this.sleep(1));
    }

    private Flux<String> subtaskReactiveFlux(String input) {
        return Flux.create(sink -> {
            try {
                for (int i = 1; i <= 3; ++i) {
                    sink.next((Object)(input + " " + i));
                }
            }
            catch (Exception e) {
                sink.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                sink.complete();
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER).doOnNext(o -> this.sleep(1));
    }

    private void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
            log.info("DO");
        }
        catch (InterruptedException e) {
            log.warn("interrupted sleep");
        }
    }
}

