/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTestingRequest;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTestingResponse;
import org.thingsboard.trendz.domain.definition.calculation.CalculationTestMode;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.TestCalculationFieldJob;
import org.thingsboard.trendz.service.task.job.TestCalculationFieldJobExecutor;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class TestCalculationFieldJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(TestCalculationFieldJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final ViewBuildingService viewBuildingService;
    private final BusinessEntityService businessEntityService;

    @Autowired
    public TestCalculationFieldJobExecutor(ExecutorManagementService executorManagementService, ViewBuildingService viewBuildingService, BusinessEntityService businessEntityService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.UI_BUILD);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"test calculation field scheduler");
        this.viewBuildingService = viewBuildingService;
        this.businessEntityService = businessEntityService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.TEST_CALCULATION_FIELD;
    }

    public Class<TestCalculationFieldJob> getJobClass() {
        return TestCalculationFieldJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        TestCalculationFieldJob job = (TestCalculationFieldJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        CalculationFieldTestingRequest request = job.getRequest();
        return Mono.just((Object)new Object()).flatMap(o -> this.test(user, request));
    }

    public Mono<CalculationFieldTestingResponse> test(JwtSecurityUser user, CalculationFieldTestingRequest request) {
        CalculationField field = request.getCalculationField();
        CalculationTestMode testMode = request.getTestMode();
        Item item = request.getItem();
        long startTs = request.getStartTs();
        long endTs = request.getEndTs();
        String tzName = request.getTzName();
        ManualDataset dataset = field.getManualDataset();
        UUID calculationFieldId = TimeStampUUIDGenerator.generateId();
        return Mono.just((Object)new Object()).flatMap(o -> {
            ViewConfig config = this.makeViewConfig(user, field, item, startTs, endTs, tzName, testMode, dataset, calculationFieldId);
            return this.viewBuildingService.buildView(config, user, new MeasurementReport());
        }).map(ViewBuildingResult::getViewReport).map(viewReport -> CalculationFieldTestingResponse.builder().targetFieldId(calculationFieldId).report(viewReport).build());
    }

    private ViewConfig makeViewConfig(JwtSecurityUser user, CalculationField field, Item item, long startTs, long endTs, String tzName, CalculationTestMode testMode, ManualDataset dataset, UUID calculationFieldId) {
        ViewConfig config = new ViewConfig();
        config.setName("Calculation field test config: " + field.getName());
        config.setDatePickerConfig(new DatePickerConfig(startTs, endTs, field.getGroupingInterval()));
        config.setTzName(tzName);
        config.setDatasetEnableMap(new HashMap());
        config.setDatasetItemMap(new HashMap());
        config.setDatasetDataMap(new HashMap());
        ViewField dateField = new ViewField();
        dateField.setId(TimeStampUUIDGenerator.generateId());
        dateField.setLabel("Date (RAW)");
        dateField.setVirtualDateField(true);
        dateField.setDateGrouping(DateAggregationType.RAW);
        ViewField calculatedField = new ViewField();
        calculatedField.setId(calculationFieldId);
        calculatedField.setLabel(field.getName());
        calculatedField.setCalculatedField(true);
        calculatedField.setBusinessEntityId(field.getBusinessEntityId());
        calculatedField.setScriptLanguage(field.getLanguage());
        calculatedField.setCalcFunction(field.getScript());
        calculatedField.setFillGapSettings(field.getFillGapSettings());
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$calculation$CalculationFieldType[field.getCalculationFieldType().ordinal()]) {
            case 1: {
                calculatedField.setNativeCalculation(false);
                calculatedField.setBatchCalculation(false);
                break;
            }
            case 2: {
                calculatedField.setNativeCalculation(false);
                calculatedField.setBatchCalculation(true);
                calculatedField.setAggregationType(field.getFieldAggregation());
                break;
            }
            case 3: {
                calculatedField.setNativeCalculation(true);
                calculatedField.setBatchCalculation(false);
                calculatedField.setAggregationType(field.getFieldAggregation());
                break;
            }
            default: {
                throw new TrendzException("Unsupported calculation field type: " + String.valueOf(field.getCalculationFieldType()));
            }
        }
        config.getXAxis().add(dateField);
        config.getXAxis().add(calculatedField);
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$calculation$CalculationTestMode[testMode.ordinal()]) {
            case 1: {
                calculatedField.setCollectDebugDataSample(true);
                calculatedField.setDebugDataSample(new HashMap());
                BusinessEntity entity = (BusinessEntity)this.businessEntityService.findEntityById(user, field.getBusinessEntityId()).orElseThrow(() -> new BusinessEntityNotFoundException(field.getBusinessEntityId(), user.getTenantId()));
                BusinessEntityField entityField = entity.getFields().stream().filter(bef -> bef.getQuery().getQueryType() == FieldQueryType.ENTITY_NAME).findAny().orElseThrow();
                ViewField filterField = new ViewField();
                filterField.setId(TimeStampUUIDGenerator.generateId());
                filterField.setLabel("Filter field");
                filterField.setBusinessEntityId(field.getBusinessEntityId());
                filterField.setEntityFieldId(entityField.getId());
                filterField.setAggregationType(FieldAggregation.UNIQ);
                RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
                runtimeFilterField.setName("Filter");
                runtimeFilterField.setViewFieldId(filterField.getId());
                runtimeFilterField.setCondition(FilterCondition.ONE_OF);
                runtimeFilterField.setOptions(Set.of(item.getName()));
                runtimeFilterField.setSelection(Set.of(item.getName()));
                config.getXAxis().add(filterField);
                config.getRuntimeFilters().add(runtimeFilterField);
                break;
            }
            case 2: {
                config.getDatasetEnableMap().put(calculatedField.getId(), true);
                config.getDatasetItemMap().put(calculatedField.getId(), item);
                config.getDatasetDataMap().put(calculatedField.getId(), dataset);
                break;
            }
            default: {
                throw new TrendzException("Unsupported test mode: " + String.valueOf(testMode));
            }
        }
        return config;
    }
}

