/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.cache.SavingCalculatedTelemetryService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.SaveTelemetryToTbJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class SaveTelemetryToTbJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(SaveTelemetryToTbJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final ViewConfigService viewConfigService;
    private final SavingCalculatedTelemetryService savingCalculatedTelemetryService;
    private final AuthenticationService authenticationService;

    @Autowired
    public SaveTelemetryToTbJobExecutor(ExecutorManagementService executorManagementService, ViewConfigService viewConfigService, SavingCalculatedTelemetryService savingCalculatedTelemetryService, AuthenticationService authenticationService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"save telemetry to TB scheduler");
        this.viewConfigService = viewConfigService;
        this.savingCalculatedTelemetryService = savingCalculatedTelemetryService;
        this.authenticationService = authenticationService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.SAVE_TELEMETRY_TO_TB;
    }

    public Class<SaveTelemetryToTbJob> getJobClass() {
        return SaveTelemetryToTbJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        SaveTelemetryToTbJob job = (SaveTelemetryToTbJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        return Mono.just((Object)new Object()).map(o -> {
            long startExecutionTime = System.currentTimeMillis();
            String jwtToken = this.authenticationService.getToken(user);
            ViewConfig viewConfig = (ViewConfig)this.viewConfigService.findConfigById(user, job.getViewConfigId()).orElseThrow();
            try {
                this.savingCalculatedTelemetryService.validateViewConfig(user, viewConfig);
            }
            catch (Exception e) {
                throw new IllegalStateException("The given View Config is not valid for telemetry saving job: " + e.getMessage(), e);
            }
            TimeRange timeRange = new TimeRange(job.getLastExecutionTime(), startExecutionTime);
            this.savingCalculatedTelemetryService.saveTelemetryToTb(jwtToken, user, viewConfig, timeRange, true);
            job.setLastExecutionTime(startExecutionTime);
            return String.format("The saving job is finished successfully - %s to %s", DateTimeUtils.fromTs((long)job.getLastExecutionTime()), DateTimeUtils.fromTs((long)startExecutionTime));
        });
    }
}

