/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTimeRangeStrategy;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.cache.SavingCalculatedTelemetryService;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.calculation.LatestTelemetryStoreService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.script.ScriptFieldPreprocessor;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.SaveCalculationFieldToTbJob;
import org.thingsboard.trendz.service.task.job.SaveCalculationFieldToTbJobExecutor;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.service.view.ViewBuildingServiceImpl;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class SaveCalculationFieldToTbJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(SaveCalculationFieldToTbJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final SavingCalculatedTelemetryService savingCalculatedTelemetryService;
    private final AuthenticationService authenticationService;
    private final CalculationFieldService calculationFieldService;
    private final ViewBuildingService viewBuildingService;
    private final BusinessEntityService businessEntityService;
    private final ScriptFieldPreprocessor scriptFieldPreprocessor;
    private final LatestTelemetryStoreService latestTelemetryStoreService;
    private final int concurrentProcessingItemCount;

    @Autowired
    public SaveCalculationFieldToTbJobExecutor(ExecutorManagementService executorManagementService, SavingCalculatedTelemetryService savingCalculatedTelemetryService, AuthenticationService authenticationService, CalculationFieldService calculationFieldService, ViewBuildingService viewBuildingService, BusinessEntityService businessEntityService, ScriptFieldPreprocessor scriptFieldPreprocessor, LatestTelemetryStoreService latestTelemetryStoreService, @Value(value="${tb.api.limits.send.items}") int concurrentProcessingItemCount) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"save calculated telemetry to TB scheduler");
        this.savingCalculatedTelemetryService = savingCalculatedTelemetryService;
        this.authenticationService = authenticationService;
        this.calculationFieldService = calculationFieldService;
        this.viewBuildingService = viewBuildingService;
        this.businessEntityService = businessEntityService;
        this.scriptFieldPreprocessor = scriptFieldPreprocessor;
        this.latestTelemetryStoreService = latestTelemetryStoreService;
        this.concurrentProcessingItemCount = concurrentProcessingItemCount;
    }

    public TaskJobType getJobType() {
        return TaskJobType.SAVE_CALCULATION_TO_TB;
    }

    public Class<SaveCalculationFieldToTbJob> getJobClass() {
        return SaveCalculationFieldToTbJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        SaveCalculationFieldToTbJob job = (SaveCalculationFieldToTbJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        UUID calculationId = job.getCalculationId();
        boolean reprocess = job.isReprocess();
        long executionStartTs = job.getExecutionStartTs();
        long executionEndTs = job.getExecutionEndTs();
        String tzName = job.getTzName();
        Set filterItems = Objects.requireNonNullElse(job.getFilterItems(), Collections.emptySet());
        long now = System.currentTimeMillis();
        TimeRange executionTimeRange = new TimeRange(executionStartTs, executionEndTs);
        CalculationField calculationField = (CalculationField)this.calculationFieldService.findById(user, calculationId).orElseThrow(() -> new CalculationFieldNotFoundException(calculationId));
        UUID businessEntityId = calculationField.getBusinessEntityId();
        CalculationFieldTimeRangeStrategy timeRangeStrategy = calculationField.getTimeRangeStrategy();
        BusinessEntityField nameEntityField = ((BusinessEntity)this.businessEntityService.findEntityById(user, businessEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(businessEntityId, user.getTenantId()))).getFields().stream().filter(bef -> bef.getQuery().getQueryType() == FieldQueryType.ENTITY_NAME).findAny().orElseThrow();
        ViewConfig latestTelemetryViewConfig = this.createLatestTelemetryViewConfigFromCalculationField(user, calculationField, nameEntityField, filterItems, tzName);
        return Mono.just((Object)new Object()).flatMap(o -> this.viewBuildingService.buildView(latestTelemetryViewConfig, user, new MeasurementReport())).map(viewBuildingResult -> {
            ViewContext context = viewBuildingResult.getViewContext();
            Set itemIdSet = (Set)context.getBusinessEntityIdToItemIdSet().get(businessEntityId);
            Map<UUID, Item> itemMap = context.getIdToItemMap().entrySet().stream().filter(entry -> itemIdSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (itemMap.isEmpty()) {
                return String.format("The calculation field (%s) saving job is finished: no items were found!", calculationField.getName());
            }
            if (reprocess) {
                return this.doReprocess(user, itemMap, calculationField, nameEntityField, executionTimeRange, tzName);
            }
            if (timeRangeStrategy == CalculationFieldTimeRangeStrategy.FIXED) {
                return this.doRefreshFixed(user, itemMap, calculationField, nameEntityField, tzName, now);
            }
            return this.doRefreshDynamic(user, itemMap, calculationField, nameEntityField, executionStartTs, tzName, now, context);
        });
    }

    private String doReprocess(JwtSecurityUser user, Map<UUID, Item> itemMap, CalculationField calculationField, BusinessEntityField nameEntityField, TimeRange executionTimeRange, String tzName) {
        if (executionTimeRange.duration().isZero()) {
            return "The calculation saving job (reprocess) is skipped: zero duration: " + String.valueOf(executionTimeRange);
        }
        ZoneId zoneId = ZoneId.of(tzName);
        List<ItemLite> itemNameList = itemMap.values().stream().map(Item::toLite).toList();
        List partitionList = Lists.partition(itemNameList, (int)this.concurrentProcessingItemCount);
        int i = 0;
        for (List partition : partitionList) {
            log.debug("partition: {}", (Object)i++);
            ViewConfig uploadTelemetryConfig = this.makeUploadConfigForItem(user, calculationField, nameEntityField, tzName, new HashSet(partition));
            this.processViewConfigWithTimerangeSplit(user, calculationField.isSplitTimeRange(), calculationField.getSplitTimeRangeTimeUnit(), uploadTelemetryConfig, executionTimeRange, zoneId);
        }
        return "The calculation saving job (reprocess) is finished successfully";
    }

    private String doRefreshFixed(JwtSecurityUser user, Map<UUID, Item> itemMap, CalculationField calculationField, BusinessEntityField nameEntityField, String tzName, long now) {
        ZoneId zoneId = ZoneId.of(tzName);
        DatePickerConfig fixedStrategyDatePicker = calculationField.getFixedStrategyDatePicker();
        TimeRange timeRange = fixedStrategyDatePicker.buildStartEndPair(zoneId, now);
        List<ItemLite> itemList = itemMap.values().stream().map(Item::toLite).toList();
        List partitionList = Lists.partition(itemList, (int)this.concurrentProcessingItemCount);
        int i = 0;
        for (List partition : partitionList) {
            log.debug("partition: {}", (Object)i++);
            ViewConfig uploadTelemetryConfig = this.makeUploadConfigForItem(user, calculationField, nameEntityField, tzName, new HashSet(partition));
            this.processViewConfigWithTimerangeSplit(user, calculationField.isSplitTimeRange(), calculationField.getSplitTimeRangeTimeUnit(), uploadTelemetryConfig, timeRange, zoneId);
        }
        return "The calculation saving job (refresh, fixed) is finished successfully";
    }

    private String doRefreshDynamic(JwtSecurityUser user, Map<UUID, Item> itemMap, CalculationField calculationField, BusinessEntityField nameEntityField, long executionStartTs, String tzName, long now, ViewContext context) {
        Map itemToKeyToLatestTsMapAfter;
        Map allItemsMap;
        Set allDataKeys = context.getIdToItemMap().values().stream().map(Item::getLatestTelemetry).filter(Objects::nonNull).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        ZoneId zoneId = ZoneId.of(tzName);
        ChronoUnit groupingUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)calculationField.getGroupingInterval()));
        ZonedDateTime nowDate = DateTimeUtils.fromTs((long)now, (ZoneId)zoneId);
        ZonedDateTime truncatedNowDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)nowDate, (ChronoUnit)groupingUnit);
        long truncatedNow = DateTimeUtils.toTs((ZonedDateTime)truncatedNowDate);
        if (allDataKeys.isEmpty()) {
            Set itemLites = itemMap.values().stream().map(Item::toLite).collect(Collectors.toSet());
            long startTs = truncatedNow;
            long endTs = DateTimeUtils.toTs((ZonedDateTime)DateTimeUtils.fromTs((long)startTs, (ZoneId)zoneId).plus(1L, groupingUnit));
            TimeRange timeRange = new TimeRange(startTs, endTs);
            ViewConfig uploadTelemetryConfig = this.makeUploadConfigForItem(user, calculationField, nameEntityField, tzName, itemLites);
            this.processViewConfigWithTimerangeSplit(user, false, null, uploadTelemetryConfig, timeRange, zoneId);
            return "The calculation saving job (refresh, dynamic) was performed with default time range (current time unit) because no telemetry (values depended on time) was found";
        }
        UUID calculationFieldId = calculationField.getId();
        Map itemToKeyToLatestTsMapBefore = this.latestTelemetryStoreService.getLatest(calculationFieldId, (allItemsMap = context.getIdToItemMap()).keySet(), allDataKeys);
        if (itemToKeyToLatestTsMapBefore.equals(itemToKeyToLatestTsMapAfter = allItemsMap.keySet().stream().collect(Collectors.toMap(Functions.identity(), childId -> this.latestTelemetryToLong(((Item)allItemsMap.get(childId)).getLatestTelemetry()))))) {
            return "The calculation saving job (refresh, dynamic) is skipped: no changes were found";
        }
        for (Item item : itemMap.values()) {
            long endTs;
            Map itemIdToKeyToLatestAfter;
            Set allChildren = this.getAllChildrenRecursive(item.getId(), context.getParentItemIdToChildItemIdSetMap());
            Map itemIdToToKeyToLatestBefore = allChildren.stream().collect(Collectors.toMap(Functions.identity(), childId -> itemToKeyToLatestTsMapBefore.getOrDefault(childId, Collections.emptyMap())));
            if (itemIdToToKeyToLatestBefore.equals(itemIdToKeyToLatestAfter = allChildren.stream().collect(Collectors.toMap(Functions.identity(), childId -> itemToKeyToLatestTsMapAfter.getOrDefault(childId, Collections.emptyMap()))))) continue;
            Set latestTelemetryTimestampsBefore = itemIdToToKeyToLatestBefore.values().stream().flatMap(latestTelemetryValuesDb -> latestTelemetryValuesDb.values().stream()).collect(Collectors.toSet());
            Set latestTelemetryTimestampsAfter = allChildren.stream().map(allItemsMap::get).map(childItem -> Objects.requireNonNullElse(childItem.getLatestTelemetry(), Map.of())).flatMap(latestTelemetry -> latestTelemetry.values().stream()).filter(ts -> !ts.isEmpty()).map(TsValue::getTs).collect(Collectors.toSet());
            Set timestampsSet = this.getLatestTsStatistics(latestTelemetryTimestampsBefore, latestTelemetryTimestampsAfter, truncatedNow, executionStartTs);
            LongSummaryStatistics timestampsStatistic = timestampsSet.stream().mapToLong(ts -> ts).summaryStatistics();
            long startTs = Math.max(timestampsStatistic.getMin(), executionStartTs);
            long truncatedStartTs = DateTimeUtils.extendedTruncateTo((long)startTs, (ZoneId)zoneId, (ChronoUnit)groupingUnit);
            TimeRange intervalTimeRange = new TimeRange(truncatedStartTs, endTs = DateTimeUtils.toTs((ZonedDateTime)DateTimeUtils.fromTs((long)timestampsStatistic.getMax(), (ZoneId)zoneId).plus(1L, groupingUnit)) - 1L);
            if (intervalTimeRange.getEndTs() <= intervalTimeRange.getStartTs()) {
                String message = String.format("The interval is not valid: %s", intervalTimeRange);
                throw new TrendzException(message);
            }
            ViewConfig uploadTelemetryConfig = this.makeUploadConfigForItem(user, calculationField, nameEntityField, tzName, Set.of(item.toLite()));
            this.processViewConfigWithTimerangeSplit(user, calculationField.isSplitTimeRange(), calculationField.getSplitTimeRangeTimeUnit(), uploadTelemetryConfig, intervalTimeRange, zoneId);
        }
        this.latestTelemetryStoreService.setLatestBatch(calculationFieldId, itemToKeyToLatestTsMapAfter);
        return "The calculation saving job (refresh, dynamic) is finished successfully";
    }

    private void processViewConfigWithTimerangeSplit(JwtSecurityUser user, boolean splitTimeRange, DateAggregationUnit splitTimeRangeTimeUnit, ViewConfig uploadTelemetryConfig, TimeRange intervalTimeRange, ZoneId zoneId) {
        List rangesToProcess = splitTimeRange ? intervalTimeRange.splitTimeRange(splitTimeRangeTimeUnit, zoneId) : List.of(intervalTimeRange);
        for (TimeRange timeRange : rangesToProcess) {
            String jwtToken = this.authenticationService.getToken(user);
            this.savingCalculatedTelemetryService.validateViewConfig(user, uploadTelemetryConfig);
            this.savingCalculatedTelemetryService.saveTelemetryToTb(jwtToken, user, uploadTelemetryConfig, timeRange, false);
        }
    }

    private Set<Long> getLatestTsStatistics(Set<Long> latestTelemetryTimestampsBefore, Set<Long> latestTelemetryTimestampsAfter, long truncatedNow, long executionStartTs) {
        HashSet<Long> resultTsSet = new HashSet<Long>(latestTelemetryTimestampsBefore);
        resultTsSet.addAll(latestTelemetryTimestampsAfter);
        resultTsSet.add(truncatedNow);
        if (latestTelemetryTimestampsBefore.isEmpty() || latestTelemetryTimestampsAfter.isEmpty()) {
            resultTsSet.add(executionStartTs);
        }
        return resultTsSet;
    }

    private Set<UUID> getAllChildrenRecursive(UUID parentId, Map<UUID, Set<UUID>> parentItemIdToChildItemIdSetMap) {
        Set<UUID> children = parentItemIdToChildItemIdSetMap.get(parentId);
        if (children == null || children.isEmpty()) {
            return Set.of(parentId);
        }
        Set<UUID> ids = children.stream().map(childId -> this.getAllChildrenRecursive(childId, parentItemIdToChildItemIdSetMap)).flatMap(Collection::stream).collect(Collectors.toSet());
        ids.add(parentId);
        return ids;
    }

    private Map<String, Long> latestTelemetryToLong(Map<String, TsValue> latestTelemetry) {
        return Objects.requireNonNullElse(latestTelemetry, Map.of()).entrySet().stream().filter(entry -> !((TsValue)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TsValue)entry.getValue()).getTs()));
    }

    private ViewConfig createLatestTelemetryViewConfigFromCalculationField(JwtSecurityUser user, CalculationField calculationField, BusinessEntityField nameEntityField, Set<ItemLite> filterItems, String tzName) {
        ViewField calculationViewField = this.getCalculationField(calculationField, false);
        List conditionalFieldsForScript = this.scriptFieldPreprocessor.process(calculationViewField, user);
        calculationViewField.setBusinessEntityId(calculationField.getBusinessEntityId());
        List<ViewField> latestTelemetryFieldsForConditionals = conditionalFieldsForScript.stream().map(conditionalField -> ViewBuildingServiceImpl.getLatestTelemetryViewField((String)conditionalField.getLabel(), (UUID)conditionalField.getBusinessEntityId(), (UUID)conditionalField.getEntityFieldId(), (boolean)false)).toList();
        ViewField entityField = this.getEntityViewField(calculationField, nameEntityField.getId());
        RuntimeFilterField runtimeFilterField = this.getRuntimeFilterField(calculationField, filterItems, entityField.getId());
        ViewConfig viewConfig = this.makeEmptyViewConfig(user, calculationField, tzName);
        viewConfig.getHiddenFields().addAll(latestTelemetryFieldsForConditionals);
        viewConfig.getHiddenFields().add(entityField);
        viewConfig.getRuntimeFilters().add(runtimeFilterField);
        return viewConfig;
    }

    private ViewConfig makeUploadConfigForItem(JwtSecurityUser user, CalculationField field, BusinessEntityField nameEntityField, String tzName, Set<ItemLite> filterItems) {
        ViewField dateField = this.getDateField(field);
        ViewField calculationField = this.getCalculationField(field, true);
        ViewField entityField = this.getEntityViewField(field, nameEntityField.getId());
        RuntimeFilterField runtimeFilterField = this.getRuntimeFilterField(field, filterItems, entityField.getId());
        ViewConfig config = this.makeEmptyViewConfig(user, field, tzName);
        config.setRowClickEntityId(field.getBusinessEntityId());
        config.getXAxis().add(dateField);
        config.getXAxis().add(calculationField);
        config.getXAxis().add(entityField);
        config.getRuntimeFilters().add(runtimeFilterField);
        return config;
    }

    private ViewConfig makeEmptyViewConfig(JwtSecurityUser user, CalculationField field, String tzName) {
        ViewConfig config = new ViewConfig();
        config.setCacheSettings(CacheSettings.noCaching());
        config.setName("Calculation field Task config: " + field.getName());
        config.setDatePickerConfig(new DatePickerConfig(1L, 2L, field.getGroupingInterval()));
        config.setTzName(tzName);
        config.setTenantId(user.getTenantId());
        config.setCustomerId(user.getCustomerId());
        config.setRootEntityId(field.getBusinessEntityId());
        return config;
    }

    private ViewField getCalculationField(CalculationField field, boolean localCalculation) {
        ViewField calculationField = new ViewField();
        calculationField.setId(field.getId());
        calculationField.setLabel(field.getTbTelemetryKey());
        calculationField.setCalculatedField(true);
        calculationField.setBusinessEntityId(field.getBusinessEntityId());
        calculationField.setEntityFieldId(field.getAssociatedEntityFieldId());
        calculationField.setScriptLanguage(field.getLanguage());
        calculationField.setCalcFunction(field.getScript());
        calculationField.setLocalCalculation(localCalculation);
        calculationField.setFillGapSettings(field.getFillGapSettings());
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$calculation$CalculationFieldType[field.getCalculationFieldType().ordinal()]) {
            case 1: {
                calculationField.setNativeCalculation(false);
                calculationField.setBatchCalculation(false);
                calculationField.setAggregationType(FieldAggregation.NONE);
                break;
            }
            case 2: {
                calculationField.setNativeCalculation(false);
                calculationField.setBatchCalculation(true);
                calculationField.setAggregationType(field.getFieldAggregation());
                break;
            }
            case 3: {
                calculationField.setNativeCalculation(true);
                calculationField.setBatchCalculation(false);
                calculationField.setAggregationType(field.getFieldAggregation());
                break;
            }
            default: {
                throw new TrendzException("Unsupported calculation field type: " + String.valueOf(field.getCalculationFieldType()));
            }
        }
        return calculationField;
    }

    private ViewField getDateField(CalculationField field) {
        ViewField dateField = new ViewField();
        dateField.setId(TimeStampUUIDGenerator.generateId());
        dateField.setLabel("Date Field: " + field.getName());
        dateField.setVirtualDateField(true);
        dateField.setDateGrouping(DateAggregationType.getDateGroupingFromPicker((String)field.getGroupingInterval()));
        return dateField;
    }

    private ViewField getEntityViewField(CalculationField field, UUID businessEntityFieldId) {
        ViewField entityField = new ViewField();
        entityField.setId(field.getBusinessEntityId());
        entityField.setBusinessEntityId(field.getBusinessEntityId());
        entityField.setEntityFieldId(businessEntityFieldId);
        entityField.setLabel("Entity Name field for Calculation Field: " + field.getName());
        entityField.setAggregationType(FieldAggregation.UNIQ);
        return entityField;
    }

    private RuntimeFilterField getRuntimeFilterField(CalculationField field, Set<ItemLite> filterItems, UUID entityNameFieldId) {
        FilterCondition filterCondition = filterItems.isEmpty() ? FilterCondition.ANY : FilterCondition.ONE_OF;
        Set filterNames = filterItems.stream().map(ItemLite::getName).collect(Collectors.toSet());
        RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
        runtimeFilterField.setName("Filter field for Calculation Field: " + field.getName());
        runtimeFilterField.setViewFieldId(entityNameFieldId);
        runtimeFilterField.setCondition(filterCondition);
        runtimeFilterField.setOptions(filterNames);
        runtimeFilterField.setSelection(filterNames);
        return runtimeFilterField;
    }
}

