/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.job.SaveCalculationFieldToTbJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;

public class SaveCalculationFieldToTbJob
implements TaskJob {
    private UUID calculationId;
    private boolean reprocess;
    private long executionStartTs;
    private long executionEndTs;
    private String tzName;
    private Set<ItemLite> filterItems;

    public SaveCalculationFieldToTbJob(SaveCalculationFieldToTbJob that) {
        this.calculationId = that.calculationId;
        this.reprocess = that.reprocess;
        this.executionStartTs = that.executionStartTs;
        this.executionEndTs = that.executionEndTs;
        this.tzName = that.tzName;
        this.filterItems = that.filterItems == null ? null : that.filterItems.stream().map(ItemLite::new).collect(Collectors.toSet());
    }

    public TaskJobType getJobType() {
        return TaskJobType.SAVE_CALCULATION_TO_TB;
    }

    public SaveCalculationFieldToTbJob clone() {
        return new SaveCalculationFieldToTbJob(this);
    }

    public static SaveCalculationFieldToTbJobBuilder builder() {
        return new SaveCalculationFieldToTbJobBuilder();
    }

    public UUID getCalculationId() {
        return this.calculationId;
    }

    public boolean isReprocess() {
        return this.reprocess;
    }

    public long getExecutionStartTs() {
        return this.executionStartTs;
    }

    public long getExecutionEndTs() {
        return this.executionEndTs;
    }

    public String getTzName() {
        return this.tzName;
    }

    public Set<ItemLite> getFilterItems() {
        return this.filterItems;
    }

    public void setCalculationId(UUID calculationId) {
        this.calculationId = calculationId;
    }

    public void setReprocess(boolean reprocess) {
        this.reprocess = reprocess;
    }

    public void setExecutionStartTs(long executionStartTs) {
        this.executionStartTs = executionStartTs;
    }

    public void setExecutionEndTs(long executionEndTs) {
        this.executionEndTs = executionEndTs;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public void setFilterItems(Set<ItemLite> filterItems) {
        this.filterItems = filterItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveCalculationFieldToTbJob)) {
            return false;
        }
        SaveCalculationFieldToTbJob other = (SaveCalculationFieldToTbJob)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isReprocess() != other.isReprocess()) {
            return false;
        }
        if (this.getExecutionStartTs() != other.getExecutionStartTs()) {
            return false;
        }
        if (this.getExecutionEndTs() != other.getExecutionEndTs()) {
            return false;
        }
        UUID this$calculationId = this.getCalculationId();
        UUID other$calculationId = other.getCalculationId();
        if (this$calculationId == null ? other$calculationId != null : !((Object)this$calculationId).equals(other$calculationId)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        Set this$filterItems = this.getFilterItems();
        Set other$filterItems = other.getFilterItems();
        return !(this$filterItems == null ? other$filterItems != null : !((Object)this$filterItems).equals(other$filterItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaveCalculationFieldToTbJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReprocess() ? 79 : 97);
        long $executionStartTs = this.getExecutionStartTs();
        result = result * 59 + (int)($executionStartTs >>> 32 ^ $executionStartTs);
        long $executionEndTs = this.getExecutionEndTs();
        result = result * 59 + (int)($executionEndTs >>> 32 ^ $executionEndTs);
        UUID $calculationId = this.getCalculationId();
        result = result * 59 + ($calculationId == null ? 43 : ((Object)$calculationId).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        Set $filterItems = this.getFilterItems();
        result = result * 59 + ($filterItems == null ? 43 : ((Object)$filterItems).hashCode());
        return result;
    }

    public String toString() {
        return "SaveCalculationFieldToTbJob(calculationId=" + String.valueOf(this.getCalculationId()) + ", reprocess=" + this.isReprocess() + ", executionStartTs=" + this.getExecutionStartTs() + ", executionEndTs=" + this.getExecutionEndTs() + ", tzName=" + this.getTzName() + ", filterItems=" + String.valueOf(this.getFilterItems()) + ")";
    }

    public SaveCalculationFieldToTbJob() {
    }

    public SaveCalculationFieldToTbJob(UUID calculationId, boolean reprocess, long executionStartTs, long executionEndTs, String tzName, Set<ItemLite> filterItems) {
        this.calculationId = calculationId;
        this.reprocess = reprocess;
        this.executionStartTs = executionStartTs;
        this.executionEndTs = executionEndTs;
        this.tzName = tzName;
        this.filterItems = filterItems;
    }
}

