/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.PredictionModelTrainingJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class PredictionModelTrainingJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelTrainingJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final PredictionModelService predictionModelService;

    @Autowired
    public PredictionModelTrainingJobExecutor(ExecutorManagementService executorManagementService, PredictionModelService predictionModelService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"prediction model creation scheduler");
        this.predictionModelService = predictionModelService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.PREDICTION_MODEL_TRAIN;
    }

    public Class<PredictionModelTrainingJob> getJobClass() {
        return PredictionModelTrainingJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        PredictionModelTrainingJob job = (PredictionModelTrainingJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        UUID modelId = job.getModelId();
        boolean avoidDisabling = job.isAvoidDisabling();
        PredictionModel initialModel = (PredictionModel)this.predictionModelService.findById(user, modelId).orElseThrow();
        long now = System.currentTimeMillis();
        return this.predictionModelService.fitModel(user, initialModel, now, avoidDisabling).doOnNext(model -> log.info("Training of prediction model {} completed successfully", (Object)model.getName())).map(model -> "Success!");
    }
}

