/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.job.PredictionModelRefreshJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;

public class PredictionModelRefreshJob
implements TaskJob {
    private UUID predictionModelId;
    private Set<ItemLite> itemSet;
    private boolean enabledPartialFit;

    public PredictionModelRefreshJob(PredictionModelRefreshJob that) {
        this.predictionModelId = that.predictionModelId;
        this.itemSet = that.itemSet == null ? null : that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.enabledPartialFit = that.enabledPartialFit;
    }

    public TaskJobType getJobType() {
        return TaskJobType.PREDICTION_MODEL_REFRESH;
    }

    public PredictionModelRefreshJob clone() {
        return new PredictionModelRefreshJob(this);
    }

    public static PredictionModelRefreshJobBuilder builder() {
        return new PredictionModelRefreshJobBuilder();
    }

    public UUID getPredictionModelId() {
        return this.predictionModelId;
    }

    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    public boolean isEnabledPartialFit() {
        return this.enabledPartialFit;
    }

    public void setPredictionModelId(UUID predictionModelId) {
        this.predictionModelId = predictionModelId;
    }

    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    public void setEnabledPartialFit(boolean enabledPartialFit) {
        this.enabledPartialFit = enabledPartialFit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModelRefreshJob)) {
            return false;
        }
        PredictionModelRefreshJob other = (PredictionModelRefreshJob)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabledPartialFit() != other.isEnabledPartialFit()) {
            return false;
        }
        UUID this$predictionModelId = this.getPredictionModelId();
        UUID other$predictionModelId = other.getPredictionModelId();
        if (this$predictionModelId == null ? other$predictionModelId != null : !((Object)this$predictionModelId).equals(other$predictionModelId)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        return !(this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredictionModelRefreshJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabledPartialFit() ? 79 : 97);
        UUID $predictionModelId = this.getPredictionModelId();
        result = result * 59 + ($predictionModelId == null ? 43 : ((Object)$predictionModelId).hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        return result;
    }

    public String toString() {
        return "PredictionModelRefreshJob(predictionModelId=" + String.valueOf(this.getPredictionModelId()) + ", itemSet=" + String.valueOf(this.getItemSet()) + ", enabledPartialFit=" + this.isEnabledPartialFit() + ")";
    }

    public PredictionModelRefreshJob() {
    }

    public PredictionModelRefreshJob(UUID predictionModelId, Set<ItemLite> itemSet, boolean enabledPartialFit) {
        this.predictionModelId = predictionModelId;
        this.itemSet = itemSet;
        this.enabledPartialFit = enabledPartialFit;
    }
}

