/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.PredictionModelAccuracyRequestJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class PredictionModelAccuracyRequestJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelAccuracyRequestJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final PredictionModelService predictionModelService;
    private final AccuracyService accuracyService;

    @Autowired
    public PredictionModelAccuracyRequestJobExecutor(ExecutorManagementService executorManagementService, PredictionModelService predictionModelService, AccuracyService accuracyService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"prediction model accuracy request scheduler");
        this.predictionModelService = predictionModelService;
        this.accuracyService = accuracyService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.PREDICTION_MODEL_ACCURACY;
    }

    public Class<PredictionModelAccuracyRequestJob> getJobClass() {
        return PredictionModelAccuracyRequestJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        PredictionModelAccuracyRequestJob job = (PredictionModelAccuracyRequestJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        UUID modelId = job.getModelId();
        Set itemSet = job.getItemSet();
        Set accuracyDataSet = job.getAccuracyMethodDataSet();
        boolean autoDefineSettings = job.isAutoDefineSettings();
        Set repeatedMethodTypes = accuracyDataSet.stream().collect(Collectors.groupingBy(AccuracyMethodData::getType, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!repeatedMethodTypes.isEmpty()) {
            throw new TrendzException("There are duplicates for the next accuracies methods: {}" + String.valueOf(repeatedMethodTypes));
        }
        PredictionModel model = (PredictionModel)this.predictionModelService.findById(user, modelId).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        if (model.getStatus() != PredictionModelStatus.READY) {
            return Mono.error((Throwable)new TrendzException("The model is not ready yet"));
        }
        Set usedItemIdSet = (itemSet.isEmpty() ? model.getTrainedItemsSet() : itemSet).stream().map(ItemLite::getId).collect(Collectors.toSet());
        return Mono.just((Object)new Object()).flatMap(o -> this.accuracyService.processAccuracyRequest(user, model, usedItemIdSet, accuracyDataSet, autoDefineSettings));
    }
}

