/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.migration.MigrationData;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.migration.MigrationService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.MigrationImportJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class MigrationImportJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(MigrationImportJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final MigrationService migrationService;

    @Autowired
    public MigrationImportJobExecutor(ExecutorManagementService executorManagementService, MigrationService migrationService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.MIGRATION_SCHEDULING);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"migration scheduler");
        this.migrationService = migrationService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.MIGRATION_IMPORT;
    }

    public Class<MigrationImportJob> getJobClass() {
        return MigrationImportJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        MigrationImportJob job = (MigrationImportJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        MigrationData migrationData = job.getMigrationData();
        return Mono.just((Object)new Object()).map(o -> this.migrationService.importMigrationData(migrationData, user));
    }
}

