/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.CustomPromptJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class CustomPromptJobExecutor
implements TaskJobExecutor {
    private final Scheduler threadPoolScheduler;
    private final CustomPromptService customPromptService;

    @Autowired
    public CustomPromptJobExecutor(ExecutorManagementService executorManagementService, CustomPromptService customPromptService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"custom prompt processor");
        this.customPromptService = customPromptService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.AI_PROMPT_EXECUTION;
    }

    public Class<? extends CustomPromptJob> getJobClass() {
        return CustomPromptJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        CustomPromptJob job = (CustomPromptJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        return Mono.just((Object)this.customPromptService.executeCustomPrompt(job.getCustomPromptExecutionRequest(), user));
    }
}

