/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.time.ZoneId;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyReprocessRequest;
import org.thingsboard.trendz.domain.anomaly.CrossJobJoinTsConfig;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.anomaly.AnomalyAlarmService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyTbService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.AnomalyModelReprocessJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class AnomalyModelReprocessJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelReprocessJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final AnomalyModelService anomalyModelService;
    private final AnomalyAlarmService anomalyAlarmService;
    private final AnomalyTbService anomalyTbService;
    private final AnomalyService anomalyService;

    @Autowired
    public AnomalyModelReprocessJobExecutor(ExecutorManagementService executorManagementService, AnomalyModelService anomalyModelService, AnomalyAlarmService anomalyAlarmService, AnomalyTbService anomalyTbService, AnomalyService anomalyService) {
        this.anomalyAlarmService = anomalyAlarmService;
        this.anomalyTbService = anomalyTbService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.ANOMLALY_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"anomaly model reprocess scheduler");
        this.anomalyModelService = anomalyModelService;
        this.anomalyService = anomalyService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.ANOMALY_MODEL_REPROCESS;
    }

    public Class<AnomalyModelReprocessJob> getJobClass() {
        return AnomalyModelReprocessJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        AnomalyModelReprocessJob job = (AnomalyModelReprocessJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        UUID modelId = job.getModelId();
        AnomalyReprocessRequest request = job.getAnomalyReprocessRequest();
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, modelId);
        this.anomalyModelService.validate(anomalyModel);
        DatasetConfig datasetConfig = new DatasetConfig(anomalyModel.getDatasetConfig());
        datasetConfig.setItemSet(request.getItemSet());
        datasetConfig.setStartTs(request.getStartTs());
        datasetConfig.setEndTs(request.getEndTs());
        datasetConfig.setTzName(request.getTzName());
        this.anomalyModelService.populateAnomalyModelWithScoreThreshold(user, anomalyModel);
        CrossJobJoinTsConfig crossJobJoinTsConfig = CrossJobJoinTsConfig.getInstance((MlProperties)anomalyModel.getProperties(), (DatasetConfig)datasetConfig, (String)anomalyModel.getTelemetrySavePeriodUnit());
        datasetConfig.setStartTs(crossJobJoinTsConfig.getStartTsOfDiscoveryArea());
        datasetConfig.setEndTs(crossJobJoinTsConfig.getEndTsOfDiscoveryArea());
        datasetConfig.setBusinessEntityId(anomalyModel.getDatasetConfig().getBusinessEntityId());
        List anomalies = this.anomalyService.discoverAnomalies(user, anomalyModel, datasetConfig).getAnomalyList();
        AnomalyPersistenceReport anomalyPersistenceReport = this.anomalyService.saveForReprocess(modelId, datasetConfig.getItemSet() == null ? null : datasetConfig.getItemSet().stream().map(ItemLite::getId).collect(Collectors.toSet()), anomalies, crossJobJoinTsConfig.getStartTsOfSavingArea(), crossJobJoinTsConfig.getEndTsOfSavingArea(), anomalyModel.getProperties().getAnomalyExtractProperties().getMinAnomalyDurationMs());
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (anomalyModel.getTaskData() != null && anomalyModel.getTaskData().isEnabledSaveToTb() && job.getAnomalyReprocessRequest().isSaveToTbEnabled()) {
                return this.anomalyTbService.saveAnomaliesToTb(anomalyModel, datasetConfig.getItemSet(), anomalyPersistenceReport.getSavedAnomalies(), crossJobJoinTsConfig.getStartTsOfSavingArea(), crossJobJoinTsConfig.getEndTsOfSavingArea(), ZoneId.of(datasetConfig.getTzName()), crossJobJoinTsConfig.getChronoUnit());
            }
            return Mono.just((Object)true);
        }).flatMap(bool -> {
            if (job.getAnomalyReprocessRequest().isAlarmCreationEnabled()) {
                return this.anomalyAlarmService.createAlarms(user, anomalyModel, anomalyPersistenceReport.getSavedAnomalies(), System.currentTimeMillis(), anomalyModel.getAnomalyAlarmConfig()).map(anomalyAlarmReport -> {
                    if (anomalyAlarmReport.isCreatedNew()) {
                        this.anomalyService.populateAlarmId(anomalyAlarmReport.getAnomaly(), anomalyAlarmReport.getAlarm().getId().getId());
                    }
                    return anomalyAlarmReport;
                }).collectList().doOnNext(anomalyAlarmReports -> {
                    long newAlarmsCreated = anomalyAlarmReports.stream().filter(AnomalyAlarmReport::isCreatedNew).count();
                    long alarmsModified = (long)anomalyAlarmReports.size() - newAlarmsCreated;
                    log.info("Anomaly Alarms: {} created, {} modified", (Object)newAlarmsCreated, (Object)alarmsModified);
                }).thenReturn(bool);
            }
            return Mono.just((Object)bool);
        }).flatMap(bool -> this.anomalyAlarmService.clearOrDeleteAlarmsFrom(user, anomalyPersistenceReport.getDeletedAnomalies(), anomalyModel.isEnabledAlarmDeletion()));
    }
}

