/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.UUID;
import org.thingsboard.trendz.domain.anomaly.AnomalyReprocessRequest;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelReprocessJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;

public class AnomalyModelReprocessJob
implements TaskJob {
    private UUID modelId;
    private AnomalyReprocessRequest anomalyReprocessRequest;

    public AnomalyModelReprocessJob(AnomalyModelReprocessJob that) {
        this.modelId = that.modelId;
        this.anomalyReprocessRequest = that.anomalyReprocessRequest == null ? null : new AnomalyReprocessRequest(that.anomalyReprocessRequest);
    }

    public TaskJobType getJobType() {
        return TaskJobType.ANOMALY_MODEL_REPROCESS;
    }

    public AnomalyModelReprocessJob clone() {
        return new AnomalyModelReprocessJob(this);
    }

    public static AnomalyModelReprocessJobBuilder builder() {
        return new AnomalyModelReprocessJobBuilder();
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public AnomalyReprocessRequest getAnomalyReprocessRequest() {
        return this.anomalyReprocessRequest;
    }

    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    public void setAnomalyReprocessRequest(AnomalyReprocessRequest anomalyReprocessRequest) {
        this.anomalyReprocessRequest = anomalyReprocessRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyModelReprocessJob)) {
            return false;
        }
        AnomalyModelReprocessJob other = (AnomalyModelReprocessJob)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        AnomalyReprocessRequest this$anomalyReprocessRequest = this.getAnomalyReprocessRequest();
        AnomalyReprocessRequest other$anomalyReprocessRequest = other.getAnomalyReprocessRequest();
        return !(this$anomalyReprocessRequest == null ? other$anomalyReprocessRequest != null : !this$anomalyReprocessRequest.equals(other$anomalyReprocessRequest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnomalyModelReprocessJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        AnomalyReprocessRequest $anomalyReprocessRequest = this.getAnomalyReprocessRequest();
        result = result * 59 + ($anomalyReprocessRequest == null ? 43 : $anomalyReprocessRequest.hashCode());
        return result;
    }

    public String toString() {
        return "AnomalyModelReprocessJob(modelId=" + String.valueOf(this.getModelId()) + ", anomalyReprocessRequest=" + String.valueOf(this.getAnomalyReprocessRequest()) + ")";
    }

    public AnomalyModelReprocessJob() {
    }

    public AnomalyModelReprocessJob(UUID modelId, AnomalyReprocessRequest anomalyReprocessRequest) {
        this.modelId = modelId;
        this.anomalyReprocessRequest = anomalyReprocessRequest;
    }
}

