/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.time.ZoneId;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyContext;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyReport;
import org.thingsboard.trendz.domain.anomaly.CrossJobJoinTsConfig;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.anomaly.AnomalyAlarmService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyTbService;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.AnomalyModelRefreshJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.view.ItemService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class AnomalyModelRefreshJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelRefreshJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final AnomalyModelService anomalyModelService;
    private final AnomalyAlarmService anomalyAlarmService;
    private final AnomalyTbService anomalyTbService;
    private final AnomalyService anomalyService;
    private final ItemService itemService;

    @Autowired
    public AnomalyModelRefreshJobExecutor(ExecutorManagementService executorManagementService, AnomalyModelService anomalyModelService, AnomalyAlarmService anomalyAlarmService, AnomalyTbService anomalyTbService, AnomalyService anomalyService, ItemService itemService) {
        this.anomalyAlarmService = anomalyAlarmService;
        this.anomalyTbService = anomalyTbService;
        this.itemService = itemService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.ANOMLALY_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"anomaly model refresh scheduler");
        this.anomalyModelService = anomalyModelService;
        this.anomalyService = anomalyService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.ANOMALY_MODEL_REFRESH;
    }

    public Class<AnomalyModelRefreshJob> getJobClass() {
        return AnomalyModelRefreshJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        AnomalyModelRefreshJob job = (AnomalyModelRefreshJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        UUID modelId = job.getModelId();
        long now = System.currentTimeMillis();
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, modelId);
        this.anomalyModelService.populateAnomalyModelWithScoreThreshold(user, anomalyModel);
        this.anomalyModelService.validate(anomalyModel);
        job.setItemIdLastSegmentMap(job.getItemIdLastSegmentMap() == null ? new ConcurrentHashMap() : new ConcurrentHashMap(job.getItemIdLastSegmentMap()));
        return this.itemService.loadItems(anomalyModel.getDatasetConfig().getBusinessEntityId(), job.getItemSet(), user).map(item -> {
            AnomalyContext anomalyContext = new AnomalyContext();
            DatasetConfig datasetConfig = new DatasetConfig(anomalyModel.getDatasetConfig());
            anomalyContext.setDatasetConfig(datasetConfig);
            datasetConfig.setItemSet(Set.of(item.toLite()));
            datasetConfig.setStartTs(this.findPerfectTimeForStartForItem(item.toLite(), job, now, anomalyModel.getProperties()));
            datasetConfig.setEndTs(now);
            CrossJobJoinTsConfig crossJobJoinTsConfig = CrossJobJoinTsConfig.getInstance((MlProperties)anomalyModel.getProperties(), (DatasetConfig)datasetConfig, (String)anomalyModel.getTelemetrySavePeriodUnit());
            anomalyContext.setCrossJobJoinTsConfig(crossJobJoinTsConfig);
            datasetConfig.setStartTs(crossJobJoinTsConfig.getStartTsOfDiscoveryArea());
            datasetConfig.setEndTs(crossJobJoinTsConfig.getEndTsOfDiscoveryArea());
            AnomalyReport anomalyReport = this.anomalyService.discoverAnomalies(user, anomalyModel, datasetConfig);
            long endSavingTs = anomalyReport.getEndOfTheLastSegmentPerItem().getOrDefault(item.getId(), datasetConfig.getEndTs());
            crossJobJoinTsConfig.setEndTsOfSavingArea(endSavingTs);
            AnomalyPersistenceReport anomalyPersistenceReport = this.anomalyService.saveForReprocess(modelId, Set.of(item.getId()), anomalyReport.getAnomalyList(), crossJobJoinTsConfig.getStartTsOfSavingArea(), crossJobJoinTsConfig.getEndTsOfSavingArea(), anomalyModel.getProperties().getAnomalyExtractProperties().getMinAnomalyDurationMs());
            anomalyContext.setAnomalyPersistenceReport(anomalyPersistenceReport);
            anomalyReport.getEndOfTheLastSegmentPerItem().forEach((itemId, maxTs) -> job.getItemIdLastSegmentMap().merge(itemId, maxTs, Long::max));
            return anomalyContext;
        }).flatMap(anomalyContext -> {
            DatasetConfig datasetConfig = anomalyContext.getDatasetConfig();
            CrossJobJoinTsConfig crossJobJoinTsConfig = anomalyContext.getCrossJobJoinTsConfig();
            AnomalyPersistenceReport anomalyPersistenceReport = anomalyContext.getAnomalyPersistenceReport();
            if (anomalyModel.getTaskData() != null && anomalyModel.getTaskData().isEnabledRefresh() && anomalyModel.getTaskData().isEnabledSaveToTb()) {
                return this.anomalyTbService.saveAnomaliesToTb(anomalyModel, datasetConfig.getItemSet(), anomalyPersistenceReport.getSavedAnomalies(), crossJobJoinTsConfig.getStartTsOfSavingArea(), crossJobJoinTsConfig.getEndTsOfSavingArea(), ZoneId.of(datasetConfig.getTzName()), crossJobJoinTsConfig.getChronoUnit()).thenReturn(anomalyContext);
            }
            return Mono.just((Object)anomalyContext);
        }).flatMap(anomalyContext -> {
            CrossJobJoinTsConfig crossJobJoinTsConfig = anomalyContext.getCrossJobJoinTsConfig();
            AnomalyPersistenceReport anomalyPersistenceReport = anomalyContext.getAnomalyPersistenceReport();
            if (anomalyModel.getTaskData() != null && anomalyModel.getTaskData().isEnabledRefresh() && anomalyModel.getTaskData().isEnabledAlarmCreation()) {
                if (anomalyPersistenceReport.getDeletedAnomalies().size() == 1 && !anomalyPersistenceReport.getSavedAnomalies().isEmpty()) {
                    Anomaly deletedAnomaly = (Anomaly)anomalyPersistenceReport.getDeletedAnomalies().get(0);
                    Anomaly recreatedAnomaly = (Anomaly)anomalyPersistenceReport.getSavedAnomalies().get(0);
                    recreatedAnomaly.setAlarmId(deletedAnomaly.getAlarmId());
                    deletedAnomaly.setAlarmId(null);
                }
                return this.anomalyAlarmService.createAlarms(user, anomalyModel, anomalyPersistenceReport.getSavedAnomalies(), crossJobJoinTsConfig.getEndTsOfSavingArea(), anomalyModel.getAnomalyAlarmConfig()).map(anomalyAlarmReport -> {
                    if (anomalyAlarmReport.isCreatedNew()) {
                        this.anomalyService.populateAlarmId(anomalyAlarmReport.getAnomaly(), anomalyAlarmReport.getAlarm().getId().getId());
                    }
                    return anomalyAlarmReport;
                }).collectList().doOnNext(anomalyAlarmReports -> {
                    long newAlarmsCreated = anomalyAlarmReports.stream().filter(AnomalyAlarmReport::isCreatedNew).count();
                    long alarmsModified = (long)anomalyAlarmReports.size() - newAlarmsCreated;
                    log.info("Anomaly Alarms: {} created, {} modified", (Object)newAlarmsCreated, (Object)alarmsModified);
                }).thenReturn(anomalyContext);
            }
            return Mono.just((Object)anomalyContext);
        }).flatMap(anomalyContext -> this.anomalyAlarmService.clearOrDeleteAlarmsFrom(user, anomalyContext.getAnomalyPersistenceReport().getDeletedAnomalies(), anomalyModel.isEnabledAlarmDeletion())).collect(Collectors.toSet()).doOnNext(contexts -> job.setLastExecutionTs(now));
    }

    private long findPerfectTimeForStartForItem(ItemLite itemLite, AnomalyModelRefreshJob job, long now, MlProperties properties) {
        long lastAnalyzedSegment = job.getItemIdLastSegmentMap() == null ? job.getLastExecutionTs() : job.getItemIdLastSegmentMap().getOrDefault(itemLite.getId(), job.getLastExecutionTs()).longValue();
        lastAnalyzedSegment = lastAnalyzedSegment == 0L ? now : lastAnalyzedSegment;
        AnomalyFilter anomalyFilter = new AnomalyFilter();
        anomalyFilter.setItemIds(Set.of(itemLite.getId()));
        anomalyFilter.setModelIds(Set.of(job.getModelId()));
        anomalyFilter.setStartTs(Long.valueOf(lastAnalyzedSegment - properties.getAnomalyExtractProperties().getMinAnomalyDurationMs()));
        anomalyFilter.setEndTs(Long.valueOf(lastAnalyzedSegment));
        return this.anomalyService.findAnomaliesByFilter(anomalyFilter).stream().mapToLong(Anomaly::getStartTs).max().orElse(lastAnalyzedSegment - properties.getAnomalyExtractProperties().getMinAnomalyDurationMs());
    }
}

