/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.alarm.AlarmService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.AlarmRequestJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class AlarmRequestJobExecutor
implements TaskJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AlarmRequestJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final AlarmService alarmService;

    @Autowired
    public AlarmRequestJobExecutor(ExecutorManagementService executorManagementService, AlarmService alarmService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.ALARM_REQUEST);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"alarm request scheduler");
        this.alarmService = alarmService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.ALARM_REQUEST;
    }

    public Class<AlarmRequestJob> getJobClass() {
        return AlarmRequestJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        AlarmRequestJob job = (AlarmRequestJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        DatePickerConfig datePickerConfig = job.getDatePickerConfig();
        String tzName = job.getTzName();
        return Mono.just((Object)new Object()).flatMap(o -> this.alarmService.buildAlarmReport(datePickerConfig, tzName, user));
    }
}

