/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.task.TaskDao;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgress;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgressStep;

@Service
public class TaskExecutionProgressService {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionProgressService.class);
    private final TaskDao taskDao;
    private final Map<UUID, TaskExecutionProgressStepBuilder> currentStepBuilders;
    private final Set<UUID> persistedClosedStepIds;
    private final ScheduledExecutorService schedulingExecutor;

    @Autowired
    public TaskExecutionProgressService(ExecutorManagementService executorManagementService, TaskDao taskDao) {
        this.taskDao = taskDao;
        this.currentStepBuilders = new ConcurrentHashMap();
        this.persistedClosedStepIds = ConcurrentHashMap.newKeySet();
        this.schedulingExecutor = (ScheduledExecutorService)executorManagementService.getExecutorByName(ExecutorName.TASK_PROGRESS_STEP_SERVICE_SCHEDULING);
        this.schedulingExecutor.scheduleWithFixedDelay(() -> this.schedule(), 0L, 3L, TimeUnit.SECONDS);
    }

    public void trigger(TaskExecutionProgressStepBuilder progressStepBuilder) {
        this.currentStepBuilders.put(progressStepBuilder.getId(), progressStepBuilder);
    }

    public void schedule() {
        try {
            List<TaskExecutionProgressStepBuilder> roots = this.currentStepBuilders.values().stream().filter(arg_0 -> this.isRoot(arg_0)).toList();
            for (TaskExecutionProgressStepBuilder root : roots) {
                if (this.save(root) && (!root.isClosed() || !this.persistedClosedStepIds.contains(root.getId()))) continue;
                this.removeTree(root);
            }
        }
        catch (Exception e) {
            log.error("Error during task execution progress service routine", (Throwable)e);
        }
    }

    private boolean isRoot(TaskExecutionProgressStepBuilder progressStepBuilder) {
        return EntityId.NULL_UUID.equals(progressStepBuilder.getParentStepId());
    }

    private TaskExecutionProgressStep buildStep(TaskExecutionProgressStepBuilder builder, List<TaskExecutionProgressStep> childrenSteps) {
        return TaskExecutionProgressStep.builder().id(builder.getId()).taskExecutionId(builder.getExecutionId()).parentStepId(builder.getParentStepId()).name(builder.getName()).startTs(builder.getStartTs()).finishTs(builder.getEndTs()).childrenSteps(childrenSteps).build();
    }

    private boolean save(TaskExecutionProgressStepBuilder rootBuilder) {
        UUID executionId = rootBuilder.getExecutionId();
        TaskExecutionProgress progress = this.convertToTaskExecutionProgress(rootBuilder);
        return this.taskDao.updateProgress(executionId, progress);
    }

    private TaskExecutionProgressStep convertStep(TaskExecutionProgressStepBuilder builder) {
        if (builder.isClosed() && this.persistedClosedStepIds.contains(builder.getId())) {
            return this.buildStep(builder, Collections.emptyList());
        }
        List<TaskExecutionProgressStep> childrenSteps = builder.getChildrenSteps().stream().map(arg_0 -> this.convertStep(arg_0)).filter(Objects::nonNull).sorted().toList();
        if (builder.isClosed()) {
            this.persistedClosedStepIds.add(builder.getId());
        }
        return this.buildStep(builder, childrenSteps);
    }

    private TaskExecutionProgress convertToTaskExecutionProgress(TaskExecutionProgressStepBuilder rootBuilder) {
        return TaskExecutionProgress.builder().content(rootBuilder.getMutableContent() == null ? null : rootBuilder.getMutableContent().clone()).rootStep(this.convertStep(rootBuilder)).build();
    }

    private void removeTree(TaskExecutionProgressStepBuilder builder) {
        this.currentStepBuilders.remove(builder.getId());
        this.persistedClosedStepIds.remove(builder.getId());
        for (TaskExecutionProgressStepBuilder child : builder.getChildrenSteps()) {
            this.removeTree(child);
        }
    }
}

