/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class TaskExecutionProgressAspect {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionProgressAspect.class);

    @Around(value="@annotation(TaskExecutionProgressDecorator)")
    public Object wrapWithProgressStep(ProceedingJoinPoint pjp) throws Throwable {
        Object result;
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        TaskExecutionProgressDecorator annotation = signature.getMethod().getAnnotation(TaskExecutionProgressDecorator.class);
        TaskExecutionProgressStepBuilder parentStep = this.getStepBuilder(pjp);
        if (parentStep == null) {
            return pjp.proceed();
        }
        String stepName = annotation.name();
        TaskExecutionProgressStepBuilder childStep = parentStep.makeStep(stepName);
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Parameter[] parameters = methodSignature.getMethod().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getType() != TaskExecutionProgressStepBuilder.class) continue;
            args[i] = childStep;
            break;
        }
        try {
            result = pjp.proceed(args);
        }
        catch (Throwable t) {
            childStep.close();
            throw t;
        }
        if (result instanceof Mono) {
            return ((Mono)result).doFinally(signal -> childStep.close());
        }
        if (result instanceof Flux) {
            Flux flux = (Flux)result;
            return flux.doFinally(signal -> childStep.close());
        }
        childStep.close();
        return result;
    }

    private TaskExecutionProgressStepBuilder getStepBuilder(ProceedingJoinPoint pjp) {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Parameter[] parameters = methodSignature.getMethod().getParameters();
        Object[] args = pjp.getArgs();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getType() != TaskExecutionProgressStepBuilder.class) continue;
            return (TaskExecutionProgressStepBuilder)args[i];
        }
        log.warn("Method {} is labeled by @TaskExecutionProgressDecorator, but there is no TaskExecutionProgressStepBuilder in the arguments", (Object)pjp.getSignature());
        return null;
    }
}

