/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.system;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.system.ApplicationPropertyDao;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.exception.security.JwtTokenException;
import org.thingsboard.trendz.exception.system.SigningKeySetupException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.MfaAuthResponse;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.system.SysadminCredentials;
import org.thingsboard.trendz.service.system.SysadminTokenRequest;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class SigningKeySetupService {
    private static final Logger log = LoggerFactory.getLogger(SigningKeySetupService.class);
    public static final String SIGNING_KEY_APPLICATION_PROPERTY = "signing_key";
    private final TbRestDataSource restDataSource;
    private final ApplicationPropertyDao applicationPropertyDao;
    private final AuthenticationService authenticationService;
    private final TokenExtractor tokenExtractor;
    private final boolean cloud;
    private final boolean test;

    @Autowired
    public SigningKeySetupService(TbRestDataSource restDataSource, ApplicationPropertyDao applicationPropertyDao, AuthenticationService authenticationService, TokenExtractor tokenExtractor, @Value(value="${deployment.cloud}") boolean cloud, @Value(value="${deployment.test}") boolean test) {
        this.restDataSource = restDataSource;
        this.applicationPropertyDao = applicationPropertyDao;
        this.authenticationService = authenticationService;
        this.tokenExtractor = tokenExtractor;
        this.cloud = cloud;
        this.test = test;
    }

    public boolean checkSigningKey(JwtSecurityUser user) {
        if (this.cloud) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        String jwtToken = this.authenticationService.createTokenFromSigningKey(user);
        return this.authenticationService.validateToken(jwtToken);
    }

    public AuthToken loginAsSysadmin(JwtSecurityUser user, SysadminCredentials credentials) {
        if (this.cloud) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (user != null && user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        AuthToken authToken = (AuthToken)DonReactive.block((Mono)this.restDataSource.login(credentials.getLogin(), credentials.getPassword()).onErrorMap(throwable -> {
            if (throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
                return new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            return throwable;
        }));
        if (Objects.isNull(authToken.getRefreshToken())) {
            if (!this.ifUserSysadmin(authToken)) {
                throw new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            return new MfaAuthResponse(authToken);
        }
        return authToken;
    }

    public void setupSigningKey(JwtSecurityUser user, SysadminTokenRequest sysadminTokenRequest) {
        if (this.cloud) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (user != null && user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        Mono signingKeyMono = Mono.just((Object)sysadminTokenRequest.getToken()).flatMap(arg_0 -> ((TbRestDataSource)this.restDataSource).fetchSigningKeyWithSysadminToken(arg_0)).onErrorMap(throwable -> {
            if (throwable.getCause() instanceof WebClientResponseException.Forbidden) {
                return new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            if (throwable instanceof JwtTokenException) {
                return new SigningKeySetupException("Can not extract sysadmin JWT token");
            }
            return throwable;
        }).map(JwtSettings::getTokenSigningKey);
        String signingKey = (String)DonReactive.block((Mono)signingKeyMono);
        ApplicationProperty property = new ApplicationProperty(SIGNING_KEY_APPLICATION_PROPERTY, signingKey);
        this.applicationPropertyDao.saveProperty(property);
        log.info("The signing key property was fetched and saved successfully.");
    }

    public void setupSigningKeyAnonymously(SysadminCredentials credentials) {
        AuthToken authToken = this.loginAsSysadmin(null, credentials);
        this.setupSigningKey(null, new SysadminTokenRequest(authToken.getToken()));
    }

    private boolean ifUserSysadmin(AuthToken authToken) {
        JwtSecurityUser probablySysadmin = this.tokenExtractor.extractUser(authToken.getToken());
        return EntityId.NULL_UUID.equals(probablySysadmin.getTenantId());
    }
}

