/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.startup;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.startup.TrendzStartupService;

@Service
public class TrendzStartupManagerService
implements HealthIndicator,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(TrendzStartupManagerService.class);
    private volatile boolean isReady = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        applicationContext.getBeansOfType(TrendzStartupService.class).values().stream().sorted(Comparator.comparingInt(TrendzStartupService::priority)).peek(service -> log.info("Startup process for service {} was started", (Object)service.getClass().getSimpleName())).forEach(trendzStartupService -> trendzStartupService.onStartup(applicationContext));
        this.isReady = true;
        log.info("Startup process was completed.");
    }

    public Health health() {
        return this.isReady ? Health.up().build() : Health.down().build();
    }
}

