/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql.dialect;

import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.sql.RelationalDatabaseType;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryDialectBuilder;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryMysqlDialectBuilder;

@Component
public class SqlQueryMysqlDialectBuilder
implements SqlQueryDialectBuilder {
    public RelationalDatabaseType getType() {
        return RelationalDatabaseType.MYSQL;
    }

    public String queryTemplate() {
        return "SELECT %s\nFROM %s\nWHERE %s\nGROUP BY %s;\n";
    }

    public String quote(String s) {
        return "`" + s.replace("`", "``") + "`";
    }

    public String getDateAggregation(String dateFieldName, String tzName, DateAggregationType fullAggregation) {
        String convertedTimestamp = "CONVERT_TZ(FROM_UNIXTIME(%s / 1000), 'UTC', '%s')".formatted(this.quote(dateFieldName), tzName);
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[fullAggregation.ordinal()]) {
            case 1 -> "FLOOR(UNIX_TIMESTAMP(%s) / 60)".formatted(convertedTimestamp);
            case 2 -> "FLOOR(UNIX_TIMESTAMP(%s) / 3600)".formatted(convertedTimestamp);
            case 3 -> "DATE(%s)".formatted(convertedTimestamp);
            case 4 -> "DATE_SUB(%s, INTERVAL WEEKDAY(%s) DAY)".formatted(convertedTimestamp, convertedTimestamp);
            case 5 -> "EXTRACT(YEAR_MONTH FROM %s)".formatted(convertedTimestamp);
            case 6 -> "CONCAT(YEAR(%s), '-', QUARTER(%s))".formatted(convertedTimestamp, convertedTimestamp);
            case 7 -> "YEAR(%s)".formatted(convertedTimestamp);
            default -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(fullAggregation));
        };
    }

    public String toSelectFieldPart(String aliasSourceName, FieldAggregation aggregation, String dateFieldName) {
        String fieldPartTemplate = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[aggregation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2, 3, 4, 5 -> aggregation.name().toLowerCase() + "(%s) as %s";
            case 6, 7 -> "%s as %s";
            case 8 -> "SUBSTRING_INDEX(GROUP_CONCAT(%s ORDER BY " + this.quote(dateFieldName) + " DESC), ',', 1) AS %s";
        };
        String quotedAlias = this.makeAggregatedKeyAliasQuote(aliasSourceName, aggregation);
        return String.format(fieldPartTemplate, this.quote(aliasSourceName), quotedAlias);
    }

    public String selectAllTableNames() {
        return "SELECT table_name\nFROM information_schema.tables\nWHERE table_type = 'BASE TABLE'\n  AND table_schema = DATABASE()\nORDER BY table_name;\n";
    }

    private String makeAggregatedKeyAliasQuote(String aliasSourceName, FieldAggregation type) {
        return this.quote(aliasSourceName + "_" + type.name().toLowerCase());
    }
}

