/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql;

import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.sql.RelationalDatabaseType;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryDialectBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class SqlQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryBuilder.class);
    private final Map<RelationalDatabaseType, SqlQueryDialectBuilder> dialectBuilderMap;

    public SqlQueryBuilder(List<SqlQueryDialectBuilder> dialectBuilders) {
        this.dialectBuilderMap = dialectBuilders.stream().collect(Collectors.toMap(SqlQueryDialectBuilder::getType, Function.identity()));
    }

    public String buildQuery(String tableName, String idFieldName, String dateFieldName, RelationalDatabaseType databaseType, Collection<UUID> relatedItemsIds, Collection<ViewField> fields, ViewRequest viewRequest, Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        Map<UUID, String> entityFieldsQueryKeyMap = businessEntityFieldMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable(((BusinessEntityField)entry.getValue()).getQuery().getKey()).orElse("unknown_field")));
        SqlQueryDialectBuilder dialectBuilder = (SqlQueryDialectBuilder)this.dialectBuilderMap.get(databaseType);
        TimeRange timeRange = new TimeRange(viewRequest.getStartTs(null), viewRequest.getEndTs(null));
        String selectFieldsPart = this.makeSelectPart(dialectBuilder, idFieldName, dateFieldName, fields, entityFieldsQueryKeyMap);
        String groupByPart = this.makeGroupPart(dialectBuilder, idFieldName, dateFieldName, fields, viewRequest, entityFieldsQueryKeyMap);
        String filterPart = this.makeFilterPart(dialectBuilder, idFieldName, dateFieldName, relatedItemsIds, fields, viewRequest.getRuntimeFilters(), entityFieldsQueryKeyMap, timeRange);
        return dialectBuilder.queryTemplate().formatted(selectFieldsPart, dialectBuilder.quote(tableName), filterPart, groupByPart);
    }

    public String buildGetAllTablesQuery(RelationalDatabaseType databaseType) {
        return ((SqlQueryDialectBuilder)this.dialectBuilderMap.get(databaseType)).selectAllTableNames();
    }

    private String makeSelectPart(SqlQueryDialectBuilder dialectBuilder, String idFieldName, String dateFieldName, Collection<ViewField> fields, Map<UUID, String> entityFieldsQueryKeyMap) {
        Object selectFieldsPart = fields.stream().map(viewField -> {
            UUID entityFieldId = viewField.getEntityFieldId();
            String entityFieldQueryKey = (String)entityFieldsQueryKeyMap.get(entityFieldId);
            return dialectBuilder.toSelectFieldPart(entityFieldQueryKey, viewField.getAggregationType(), dateFieldName) + ", ";
        }).reduce("", String::concat);
        selectFieldsPart = (String)selectFieldsPart + dialectBuilder.quote(idFieldName);
        selectFieldsPart = (String)selectFieldsPart + this.getSelectDateQuery(dialectBuilder, dateFieldName);
        return selectFieldsPart;
    }

    private String getSelectDateQuery(SqlQueryDialectBuilder dialectBuilder, String dateFieldName) {
        String dateFieldNameQuoted = dialectBuilder.quote(dateFieldName);
        return ", min(" + dateFieldNameQuoted + ") as " + dateFieldNameQuoted + " ";
    }

    private String makeGroupPart(SqlQueryDialectBuilder dialectBuilder, String idFieldName, String dateFieldName, Collection<ViewField> fields, ViewRequest viewRequest, Map<UUID, String> entityFieldsQueryKeyMap) {
        StringBuilder groupByPart = new StringBuilder(" ");
        fields.stream().filter(vf -> FieldAggregation.UNIQ.equals((Object)vf.getAggregationType())).map(ViewField::getEntityFieldId).map(entityFieldsQueryKeyMap::get).collect(Collectors.toSet()).forEach(entityFieldKey -> groupByPart.append(dialectBuilder.quote(entityFieldKey)).append(", "));
        groupByPart.append(dialectBuilder.quote(idFieldName));
        if (CollectionUtils.isNotEmpty((Collection)viewRequest.getDateAggregationFieldsVisible())) {
            DateAggregationType minimalDateAggregation = viewRequest.getMinimalDateAggregation();
            DateAggregationType fullAggregation = minimalDateAggregation == DateAggregationType.RAW ? DateAggregationType.getDateGroupingFromPicker((String)viewRequest.getDatePickerConfig().getRangeBy()) : DateAggregationType.getFullType((DateAggregationType)minimalDateAggregation);
            String tzName = DateTimeUtils.toTzName((ZoneId)viewRequest.getZoneId());
            groupByPart.append(", ").append(dialectBuilder.getDateAggregation(dateFieldName, tzName, fullAggregation)).append(" ");
        }
        return groupByPart.toString();
    }

    private String makeFilterPart(SqlQueryDialectBuilder dialectBuilder, String idFieldName, String dateFieldName, Collection<UUID> relatedItemIds, Collection<ViewField> fields, List<RuntimeFilterField> runtimeFilterFields, Map<UUID, String> entityFieldsQueryKeyMap, TimeRange requestTimeRange) {
        List singleQuotedIds = relatedItemIds.stream().map(UUID::toString).map(arg_0 -> this.singleQuote(arg_0)).collect(Collectors.toList());
        StringBuilder filterPart = new StringBuilder(dialectBuilder.quote(idFieldName)).append(" in (").append(StringUtils.join(singleQuotedIds, (String)",")).append(")");
        Set externalFieldIds = fields.stream().map(ViewField::getId).collect(Collectors.toSet());
        Set filterFields = runtimeFilterFields.stream().filter(rf -> externalFieldIds.contains(rf.getViewFieldId())).collect(Collectors.toSet());
        Map<UUID, UUID> idToEntityFieldIdMap = fields.stream().collect(Collectors.toMap(ViewField::getId, ViewField::getEntityFieldId));
        filterFields.stream().filter(filter -> CollectionUtils.isNotEmpty((Collection)filter.getSelection())).forEach(filter -> {
            UUID entityFieldId = (UUID)idToEntityFieldIdMap.get(filter.getViewFieldId());
            String quotedKey = dialectBuilder.quote((String)entityFieldsQueryKeyMap.get(entityFieldId));
            List escaped = filter.getSelection().stream().map(v -> "'" + v + "'").collect(Collectors.toList());
            filterPart.append(" and ").append(quotedKey).append(" in (").append(StringUtils.join(escaped, (String)",")).append(")");
        });
        return filterPart.append(this.getDateTimeFilterQueryString(dialectBuilder.quote(dateFieldName), requestTimeRange)).append(this.getUniqFilterQueryString(dialectBuilder, fields, entityFieldsQueryKeyMap)).toString();
    }

    private String getUniqFilterQueryString(SqlQueryDialectBuilder dialectBuilder, Collection<ViewField> fields, Map<UUID, String> entityFieldsQueryKeyMap) {
        return fields.stream().filter(vf -> FieldAggregation.UNIQ.equals((Object)vf.getAggregationType())).collect(Collectors.toSet()).stream().map(ViewField::getEntityFieldId).map(entityFieldsQueryKeyMap::get).map(key -> " and " + dialectBuilder.quote(key) + " is not null ").collect(Collectors.joining());
    }

    private String getDateTimeFilterQueryString(String quotedDateFieldName, TimeRange requestTimeRange) {
        return " and %s >= %s and %s < %s ".formatted(quotedDateFieldName, requestTimeRange.getStartTs(), quotedDateFieldName, requestTimeRange.getEndTs());
    }

    private String singleQuote(String id) {
        return "'" + id + "'";
    }
}

