/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.state;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.state.State;
import org.thingsboard.trendz.service.script.state.StateCondition;
import org.thingsboard.trendz.service.script.state.StateConditionService;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class StateFieldProcessor {
    private static final Logger log = LoggerFactory.getLogger(StateFieldProcessor.class);
    private final StateConditionService stateConditionService;

    @Autowired
    public StateFieldProcessor(StateConditionService stateConditionService) {
        this.stateConditionService = stateConditionService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.STATE_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> processFieldStates(JwtSecurityUser user, Item item, ViewField viewField, ViewRequest viewRequest, Mono<Map<String, List<FieldValue>>> itemDataBundleLoaderLoadValues) {
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        DateAggregationType minimalDateAggregation = viewRequest.getMinimalDateAggregation();
        if (fieldAggregation == FieldAggregation.NONE) {
            throw new TrendzException("Aggregation is not supported: " + String.valueOf(fieldAggregation));
        }
        long viewRequestStartTs = viewRequest.getStartTs(viewField);
        long viewRequestEndTs = viewRequest.getEndTs(viewField);
        StateCondition stateCondition = this.buildCondition(viewField);
        return itemDataBundleLoaderLoadValues.map(keyToTelemetryMap -> {
            List states = this.stateConditionService.getStatesByCondition(user, viewField, viewField.getScriptLanguage(), keyToTelemetryMap, viewRequestStartTs, viewRequestEndTs, stateCondition, item);
            List fieldValues = this.statesToValue(states, item, minimalDateAggregation, viewRequest.getZoneId(), fieldAggregation, viewRequestStartTs, viewRequestEndTs);
            log.trace("States: {}, field values: {}", (Object)states.size(), (Object)fieldValues.size());
            return fieldValues;
        }).flatMapIterable(i -> i);
    }

    private StateCondition buildCondition(ViewField viewField) {
        Set keys = viewField.getConditionFieldIds().keySet();
        String[] parameterNames = keys.toArray(new String[0]);
        return new StateCondition(viewField.getParsedCondition(), parameterNames, this.getStateConditionName(viewField));
    }

    private String getStateConditionName(ViewField viewField) {
        return viewField.getLabel();
    }

    private List<FieldValue> statesToValue(List<State> states, Item item, DateAggregationType minimalDateAggregation, ZoneId zoneId, FieldAggregation fieldAggregation, long startTs, long endTs) {
        List fixedStates = this.fixStates(states, startTs, endTs, fieldAggregation);
        if (fieldAggregation == FieldAggregation.UNIQ) {
            return this.proceedUniq(fixedStates, item);
        }
        if (fieldAggregation == FieldAggregation.LATEST) {
            return this.proceedLatest(fixedStates, item);
        }
        if (minimalDateAggregation == null) {
            return this.proceedNoDateAggregation(fixedStates, item);
        }
        return this.proceedWithDateAggregation(fixedStates, item, minimalDateAggregation, zoneId, startTs, endTs);
    }

    private List<State> fixStates(List<State> states, long startTs, long endTs, FieldAggregation aggregation) {
        return states.stream().filter(state -> state.getStartTs() < endTs).map(state -> {
            long stateEndTs;
            long stateStartTs = Math.max(state.getStartTs(), startTs);
            if (stateStartTs >= (stateEndTs = Math.min(state.getEndTs(), endTs + 1L))) {
                return null;
            }
            double value = aggregation == FieldAggregation.COUNT ? 1.0 : (double)(stateEndTs - stateStartTs);
            state.setValue((Object)value);
            state.setEndTs(stateEndTs);
            state.setStartTs(stateStartTs);
            return state;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(State::getStartTs)).toList();
    }

    private List<FieldValue> proceedUniq(List<State> states, Item item) {
        List<FieldValue> fieldValues = states.stream().map(State::getValue).distinct().map(value -> new FieldValue(Collections.singleton(item), FieldType.NUMERIC, value, 0L)).toList();
        if (fieldValues.isEmpty()) {
            return Collections.singletonList(new FieldValue(Collections.singleton(item), FieldType.BLANK, null, 0L));
        }
        return fieldValues;
    }

    private List<FieldValue> proceedLatest(List<State> states, Item item) {
        FieldValue fieldValue = states.stream().max(Comparator.comparing(State::getEndTs)).map(latestState -> new FieldValue(Collections.singleton(item), FieldType.NUMERIC, latestState.getValue(), 0L)).orElse(new FieldValue(Collections.singleton(item), FieldType.BLANK, null, 0L));
        return Collections.singletonList(fieldValue);
    }

    private List<FieldValue> proceedNoDateAggregation(List<State> states, Item item) {
        List<FieldValue> fieldValues = states.stream().map(state -> {
            long ts = state.getStartTs();
            double value = (Double)state.getValue();
            return new FieldValue(Collections.singleton(item), FieldType.NUMERIC, (Object)value, ts);
        }).toList();
        if (fieldValues.isEmpty()) {
            return Collections.singletonList(new FieldValue(Collections.singleton(item), FieldType.BLANK, null, 0L));
        }
        return fieldValues;
    }

    private List<FieldValue> proceedWithDateAggregation(List<State> states, Item item, DateAggregationType minimalDateAggregation, ZoneId zoneId, long startTs, long endTs) {
        DateAggregationUnit aggregationUnit = minimalDateAggregation.mapToUnit();
        TimeRange totalTimeRange = new TimeRange(startTs, endTs);
        Map<Long, FieldValue> tsMap = totalTimeRange.makeTsList(aggregationUnit, zoneId).stream().collect(Collectors.toMap(ts -> ts, ts -> new FieldValue(Collections.singleton(item), FieldType.NUMERIC, (Object)0, ts.longValue(), 0.0, 0L)));
        for (State state : states) {
            TimeRange stateTimeRange = new TimeRange(state.getStartTs(), state.getEndTs());
            List splitTimeRanges = stateTimeRange.splitTimeRange(aggregationUnit, zoneId);
            for (TimeRange range : splitTimeRanges) {
                long ts2 = range.getStartTs();
                double value = range.duration().toMillis();
                tsMap.put(ts2, new FieldValue(Collections.singleton(item), FieldType.NUMERIC, (Object)value, ts2));
            }
        }
        return tsMap.values().stream().sorted(Comparator.comparingLong(FieldValue::getTs)).toList();
    }
}

