/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.state;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.service.script.ScriptProcessingException;
import org.thingsboard.trendz.exception.service.script.engine.JsException;
import org.thingsboard.trendz.exception.service.script.engine.PythonException;
import org.thingsboard.trendz.exception.service.script.engine.PythonExecutorException;
import org.thingsboard.trendz.exception.service.script.engine.ScriptEngineException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.engine.NashornJsService;
import org.thingsboard.trendz.service.script.engine.PythonScriptEngine;
import org.thingsboard.trendz.service.script.engine.ScriptExecutionResult;
import org.thingsboard.trendz.service.script.engine.provider.docker.model.ErrorMessage;
import org.thingsboard.trendz.service.script.engine.provider.docker.model.ErrorMessageType;
import org.thingsboard.trendz.service.script.state.State;
import org.thingsboard.trendz.service.script.state.StateCondition;
import org.thingsboard.trendz.service.script.state.StateConditionService;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class StateConditionService {
    private static final Logger log = LoggerFactory.getLogger(StateConditionService.class);
    private final NashornJsService jsService;
    private final PythonScriptEngine pythonScriptEngine;

    @Autowired
    public StateConditionService(NashornJsService jsService, PythonScriptEngine pythonScriptEngine) {
        this.jsService = jsService;
        this.pythonScriptEngine = pythonScriptEngine;
    }

    public List<State> getStatesByCondition(JwtSecurityUser user, ViewField viewField, ScriptLanguage scriptLanguage, Map<String, List<FieldValue>> fieldToValuesMap, long requestStartTs, long requestEndTs, StateCondition stateCondition, Item item) {
        try {
            fieldToValuesMap.values().forEach(values -> this.addNullFieldValueIfEmpty(values, item, requestStartTs));
            this.addBorderValues(fieldToValuesMap, requestStartTs, requestEndTs);
            List buckets = this.groupBucketByTimestamp(fieldToValuesMap);
            List rawStates = this.generateRawStates(buckets);
            rawStates = this.splitHugeStates(rawStates, viewField.getStateMaxDuration());
            return this.calculateAndMergeValueStates(user, viewField, rawStates, stateCondition, scriptLanguage);
        }
        catch (ScriptEngineException exception) {
            Function<Throwable, RuntimeException> mapToScriptProcessingException = throwable -> new ScriptProcessingException(stateCondition.getStateName(), stateCondition.getExpression(), Arrays.asList(stateCondition.getParameterNames()), scriptLanguage, throwable, null);
            Throwable throwable2 = exception.getCause();
            if (throwable2 instanceof PythonExecutorException) {
                PythonExecutorException cause = (PythonExecutorException)throwable2;
                ErrorMessage errorMessage = cause.getErrorMessage();
                if (errorMessage.getType() == ErrorMessageType.RUNTIME) {
                    throw mapToScriptProcessingException.apply((Throwable)new PythonException(errorMessage.getExecutionResult()));
                }
                throw cause;
            }
            if (exception.getCause() instanceof PythonException) {
                throw mapToScriptProcessingException.apply(exception.getCause());
            }
            if (exception instanceof JsException) {
                throw mapToScriptProcessingException.apply(exception);
            }
            throw new RuntimeException(exception);
        }
    }

    List<Pair<Map<String, FieldValue>, State>> splitHugeStates(List<Pair<Map<String, FieldValue>, State>> rawStates, long stateMaxLength) {
        if (this.isValidationStats(rawStates)) {
            return rawStates;
        }
        if (stateMaxLength == 0L) {
            return rawStates;
        }
        ArrayList<Pair<Map<String, FieldValue>, State>> result = new ArrayList<Pair<Map<String, FieldValue>, State>>(rawStates);
        for (int i = 0; i < result.size(); ++i) {
            long stateEnd;
            Pair<Map<String, FieldValue>, State> current = result.get(i);
            long stateStart = ((State)current.getRight()).getStartTs();
            if (!this.hugeState(stateStart, stateEnd = ((State)current.getRight()).getEndTs(), stateMaxLength) || !this.notBlankState(current)) continue;
            State currentState = (State)current.getRight();
            long actualEnd = currentState.getEndTs();
            currentState.setEndTs(stateStart + stateMaxLength - 1L);
            State newState = new State();
            newState.setStartTs(currentState.getEndTs() + 1L);
            newState.setEndTs(actualEnd);
            result.add(i + 1, (Pair<Map<String, FieldValue>, State>)Pair.of((Object)this.getKeyToBlankViewFieldMap((Map)current.getLeft()), (Object)newState));
        }
        return result;
    }

    private boolean notBlankState(Pair<Map<String, FieldValue>, State> state) {
        return ((Map)state.getLeft()).values().stream().anyMatch(fieldValue -> fieldValue.getFieldType() != FieldType.BLANK);
    }

    private boolean hugeState(long stateStart, long stateEnd, long stateMaxLength) {
        return stateEnd - stateMaxLength > stateStart;
    }

    private Map<String, FieldValue> getKeyToBlankViewFieldMap(Map<String, FieldValue> template) {
        return template.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, k -> this.blank((FieldValue)k.getValue())));
    }

    FieldValue blank(FieldValue from) {
        FieldValue result = new FieldValue(from);
        result.setInnerValue(null);
        result.setFieldType(FieldType.BLANK);
        return result;
    }

    private void addNullFieldValueIfEmpty(List<FieldValue> list, Item item, long requestStartTs) {
        if (list.isEmpty()) {
            list.add(new FieldValue(item, FieldType.BLANK, null, requestStartTs));
        }
    }

    private void addBorderValues(Map<String, List<FieldValue>> fieldToValuesMap, long requestStartTs, long requestEndTs) {
        for (List<FieldValue> fieldValues : fieldToValuesMap.values()) {
            if (fieldValues.isEmpty()) continue;
            long minTs = fieldValues.stream().mapToLong(FieldValue::getTs).min().orElse(Long.MIN_VALUE);
            long maxTs = fieldValues.stream().mapToLong(FieldValue::getTs).max().orElse(Long.MAX_VALUE);
            Set items = fieldValues.get(0).getItems();
            if (requestStartTs < minTs) {
                fieldValues.add(new FieldValue(items, FieldType.BLANK, null, requestStartTs));
                fieldValues.add(new FieldValue(items, FieldType.BLANK, null, minTs - 1L));
            }
            if (maxTs > requestEndTs) continue;
            fieldValues.add(new FieldValue(items, FieldType.BLANK, null, requestEndTs + 1L));
        }
    }

    private List<Map<String, FieldValue>> groupBucketByTimestamp(Map<String, List<FieldValue>> fieldToValuesMap) {
        TreeMap tsMap = Maps.newTreeMap();
        for (Map.Entry<String, List<FieldValue>> fieldToValuesEntry : fieldToValuesMap.entrySet()) {
            String fieldName = fieldToValuesEntry.getKey();
            for (FieldValue fv : fieldToValuesEntry.getValue()) {
                List bucketValues = tsMap.computeIfAbsent(fv.getTs(), ts -> new ArrayList());
                bucketValues.add(Pair.of((Object)fieldName, (Object)fv));
            }
        }
        ArrayList buckets = Lists.newArrayList();
        for (Map.Entry tsToFieldAndValuePair : tsMap.entrySet()) {
            HashMap<String, FieldValue> bucket = new HashMap<String, FieldValue>();
            for (Pair fieldAndValuePair : (List)tsToFieldAndValuePair.getValue()) {
                bucket.put((String)fieldAndValuePair.getLeft(), (FieldValue)fieldAndValuePair.getRight());
            }
            buckets.add(bucket);
        }
        return buckets;
    }

    private List<Pair<Map<String, FieldValue>, State>> generateRawStates(List<Map<String, FieldValue>> buckets) {
        ArrayList rawStates = Lists.newArrayList();
        State previousState = null;
        for (Map<String, FieldValue> params : buckets) {
            State state;
            long currentTs = params.values().iterator().next().getTs();
            if (previousState != null) {
                previousState.setEndTs(currentTs);
            }
            previousState = state = new State(null, currentTs, currentTs);
            rawStates.add(Pair.of(params, (Object)state));
        }
        return rawStates;
    }

    private List<State> calculateAndMergeValueStates(JwtSecurityUser user, ViewField viewField, List<Pair<Map<String, FieldValue>, State>> rawStates, StateCondition stateCondition, ScriptLanguage scriptLanguage) {
        List crossSection = rawStates.stream().map(Pair::getKey).map(section -> section.entrySet().stream().collect(() -> new HashMap(), (m, v) -> m.put((String)v.getKey(), ((FieldValue)v.getValue()).getInnerValue()), Map::putAll)).collect(Collectors.toList());
        List states = rawStates.stream().map(Pair::getValue).collect(Collectors.toList());
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$ScriptLanguage[scriptLanguage.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.satisfyExpressionJs(viewField, crossSection, states, stateCondition);
            case 2 -> this.satisfyExpressionPython(user, viewField, crossSection, states, stateCondition);
        };
    }

    boolean isValidationStats(List<Pair<Map<String, FieldValue>, State>> rawStates) {
        if (rawStates.size() == 5) {
            State first = (State)rawStates.get(0).getRight();
            State second = (State)rawStates.get(1).getRight();
            State middle = (State)rawStates.get(2).getRight();
            State forth = (State)rawStates.get(3).getRight();
            State last = (State)rawStates.get(4).getRight();
            return first.getStartTs() == Long.MIN_VALUE && first.getEndTs() == -1L && second.getStartTs() == -1L && second.getEndTs() == 0L && middle.getStartTs() == 0L && middle.getEndTs() == 1L && forth.getStartTs() == 1L && forth.getEndTs() == Long.MAX_VALUE && last.getStartTs() == Long.MAX_VALUE && last.getEndTs() == Long.MAX_VALUE;
        }
        return false;
    }

    private List<State> satisfyExpressionJs(ViewField viewField, List<Map<String, Object>> crossSection, List<State> states, StateCondition stateCondition) {
        String inputData = JsonUtils.toJson(crossSection);
        String expression = stateCondition.getExpression();
        List inputDataKeys = viewField.getConditionFieldIds().keySet().stream().sorted().toList();
        String inputFunctionArgumentLine = inputDataKeys.stream().reduce((o1, o2) -> o1 + ", " + o2).orElse("");
        StringBuilder inputFunctionArgumentDeclaration = new StringBuilder();
        for (String inputDataKey : inputDataKeys) {
            inputFunctionArgumentDeclaration.append("var ").append(inputDataKey).append(" = section['").append(inputDataKey).append("']; \n");
        }
        List<String> argNames = List.of("inputData");
        Object[] args = new Object[]{inputData};
        String script = "\nvar stateConditionScript = function(" + inputFunctionArgumentLine + ") { \n\t" + expression.replaceAll("\n", "\n\t") + "\n} \nvar result = [] \nfor (var i = 0; i < inputData.length; i++) { \n\tvar section = inputData[i]; \n\t" + inputFunctionArgumentDeclaration.toString().replaceAll("\n", "\n\t") + "\n\tvar calculation = stateConditionScript(" + inputFunctionArgumentLine + "); \n\tresult.push(calculation); \n} \nreturn result; \n";
        Object stringResult = this.jsService.execute(viewField, script, argNames, args);
        Object result = JsonUtils.fromJson((String)stringResult.toString(), Object.class);
        ArrayList<Boolean> stateResultList = new ArrayList<Boolean>();
        if (result instanceof List) {
            List resultList = (List)result;
            for (Object calculation : resultList) {
                if (calculation instanceof Boolean) {
                    Boolean stateResult = (Boolean)calculation;
                    stateResultList.add(stateResult);
                    continue;
                }
                throw new IllegalStateException("The result of calculation has wrong type definition! \n\tExpected: [Boolean], actual: [" + (calculation == null ? "null" : calculation.getClass().getName()) + "], value = " + String.valueOf(calculation) + "\n");
            }
        } else {
            throw new IllegalStateException("The result of calculation has wrong type definition! Provided data is not a list.");
        }
        if (crossSection.size() != stateResultList.size()) {
            throw new IllegalStateException("The result of calculation has wrong count of calculations.");
        }
        return this.mergeStates(states, stateCondition.getStateName(), stateResultList);
    }

    private List<State> satisfyExpressionPython(JwtSecurityUser user, ViewField viewField, List<Map<String, Object>> crossSection, List<State> states, StateCondition stateCondition) {
        String expression = stateCondition.getExpression();
        List inputDataKeys = viewField.getConditionFieldIds().keySet().stream().sorted().toList();
        String inputFunctionArgumentLine = inputDataKeys.stream().reduce((o1, o2) -> o1 + ", " + o2).orElse("");
        StringBuilder inputFunctionArgumentDeclaration = new StringBuilder();
        for (String inputDataKey : inputDataKeys) {
            inputFunctionArgumentDeclaration.append(inputDataKey).append(" = section['").append(inputDataKey).append("']; \n");
        }
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, Boolean.class);
        Map<String, List<Map<String, Object>>> input = Map.of("inputData", crossSection);
        String script = "\ndef stateConditionScript(" + inputFunctionArgumentLine + "): \n\t" + expression.replaceAll("\n", "\n\t") + "\n\nresult = [] \nfor i in range(0, len(inputData)): \n\tsection = inputData[i]; \n\t" + inputFunctionArgumentDeclaration.toString().replaceAll("\n", "\n\t") + "\n\tcalculation = stateConditionScript(" + inputFunctionArgumentLine + "); \n\tresult.append(calculation); \n\nreturn result; \n";
        ScriptExecutionResult executionResult = (ScriptExecutionResult)DonReactive.block((Mono)this.pythonScriptEngine.runScript(user, script, (JavaType)type, input, viewField.getScriptDebugLogId()));
        List stateResultList = (List)executionResult.getResult();
        if (crossSection.size() != stateResultList.size()) {
            throw new IllegalStateException("The result of calculation has wrong count of calculations.");
        }
        return this.mergeStates(states, stateCondition.getStateName(), stateResultList);
    }

    List<State> mergeStates(List<State> states, String stateName, List<Boolean> stateResultList) {
        State prevState = null;
        ArrayList<State> mergedStates = new ArrayList<State>();
        for (int i = 0; i < stateResultList.size(); ++i) {
            boolean stateResult = stateResultList.get(i);
            State state = states.get(i);
            if (stateResult) {
                state.setValue((Object)stateName);
                if (prevState != null && prevState.getValue().equals(stateName)) {
                    prevState.setEndTs(state.getEndTs());
                    continue;
                }
                mergedStates.add(state);
                prevState = state;
                continue;
            }
            prevState = null;
        }
        return mergedStates;
    }
}

