/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.state;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.thingsboard.trendz.service.script.state.State;

public class State {
    private Object value;
    private long startTs;
    private long endTs;

    public String toString() {
        return "State(value= " + String.valueOf(this.value) + ", startTs= " + this.startTs + " [" + String.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.startTs), ZoneId.systemDefault())) + "], endTs= " + this.endTs + " [" + String.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.endTs), ZoneId.systemDefault())) + "])";
    }

    public static StateBuilder builder() {
        return new StateBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof State;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public State() {
    }

    public State(Object value, long startTs, long endTs) {
        this.value = value;
        this.startTs = startTs;
        this.endTs = endTs;
    }
}

