/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.engine.provider.docker;

import jakarta.websocket.ContainerProvider;
import jakarta.websocket.WebSocketContainer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.thingsboard.trendz.service.script.engine.provider.docker.ThrottlingSessionProvider;
import reactor.core.publisher.Mono;

@Service
public class ThrottlingSessionProvider {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingSessionProvider.class);
    private final String dockerProviderUrl;
    private final int websocketBufferSize;
    private final Semaphore sessionSemaphore;
    private final Mono<WebSocketStompClient> stompClient = this.makeClient();
    private final Mono<StompSessionHandlerAdapter> sessionHandler = this.makeSessionHandler();

    public ThrottlingSessionProvider(@Value(value="${script-engine.docker-provider-url}") String dockerProviderUrl, @Value(value="${script-engine.websocket-buffer-size}") int websocketBufferSize, @Value(value="${script-engine.websocket-concurrency}") int websocketConcurrency) {
        this.dockerProviderUrl = dockerProviderUrl;
        this.websocketBufferSize = websocketBufferSize;
        this.sessionSemaphore = new Semaphore(websocketConcurrency);
    }

    public Mono<StompSession> getStompSession(CountDownLatch latch, AtomicReference<StompSession> sessionReference) {
        return Mono.zip((Mono)this.stompClient, (Mono)this.sessionHandler).flatMap(tuple -> {
            try {
                this.sessionSemaphore.acquire();
            }
            catch (InterruptedException e) {
                latch.countDown();
                return Mono.error((Throwable)e);
            }
            log.debug("acquired session, {} available permits.", (Object)this.sessionSemaphore.availablePermits());
            WebSocketStompClient client = (WebSocketStompClient)tuple.getT1();
            StompSessionHandlerAdapter sessionHandler = (StompSessionHandlerAdapter)tuple.getT2();
            String url = String.format("ws://%s/ws", this.dockerProviderUrl);
            return Mono.fromFuture(() -> {
                log.debug("Web socket session: opening...");
                return ((CompletableFuture)client.connect(url, (StompSessionHandler)sessionHandler, new Object[0]).completable().thenApply(stompSession -> {
                    sessionReference.set((StompSession)stompSession);
                    latch.countDown();
                    log.debug("Web socket session: is opened and set");
                    return stompSession;
                })).exceptionally(throwable -> {
                    latch.countDown();
                    log.debug("Web socket session: session creation was failed");
                    throw new RuntimeException((Throwable)throwable);
                });
            });
        }).doOnError(throwable -> latch.countDown());
    }

    public void returnSession() {
        this.sessionSemaphore.release();
        log.debug("returned session, {} available permits.", (Object)this.sessionSemaphore.availablePermits());
    }

    private Mono<WebSocketStompClient> makeClient() {
        return Mono.fromCallable(() -> {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.setDefaultMaxBinaryMessageBufferSize(this.websocketBufferSize);
            container.setDefaultMaxTextMessageBufferSize(this.websocketBufferSize);
            StandardWebSocketClient standardWebSocketClient = new StandardWebSocketClient(container);
            WebSocketStompClient stompClient = new WebSocketStompClient((WebSocketClient)standardWebSocketClient);
            stompClient.setInboundMessageSizeLimit(this.websocketBufferSize);
            stompClient.setTaskScheduler((TaskScheduler)new ConcurrentTaskScheduler());
            stompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
            return stompClient;
        }).cache();
    }

    private Mono<StompSessionHandlerAdapter> makeSessionHandler() {
        return Mono.fromCallable(() -> {
            1 stompSessionHandlerAdapter = new /* Unavailable Anonymous Inner Class!! */;
            return stompSessionHandlerAdapter;
        }).cache();
    }
}

