/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.engine.provider.docker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.service.script.engine.PythonExecutorException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.calculation.TrendzProxyService;
import org.thingsboard.trendz.service.script.engine.MyCustomLogger;
import org.thingsboard.trendz.service.script.engine.ScriptExecutionResult;
import org.thingsboard.trendz.service.script.engine.provider.EngineProvider;
import org.thingsboard.trendz.service.script.engine.provider.EngineProviderType;
import org.thingsboard.trendz.service.script.engine.provider.docker.DockerEngineProvider;
import org.thingsboard.trendz.service.script.engine.provider.docker.ThrottlingSessionProvider;
import org.thingsboard.trendz.service.script.engine.provider.docker.model.ScriptMessage;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class DockerEngineProvider
implements EngineProvider {
    private static final Logger log = LoggerFactory.getLogger(DockerEngineProvider.class);
    private final int callbackTimeoutMs;
    private final ThrottlingSessionProvider throttlingSessionProvider;
    private final MyCustomLogger customLogger;
    private final TrendzProxyService trendzProxyService;

    @Autowired
    public DockerEngineProvider(@Value(value="${script-engine.callback-timeout}") int callbackTimeoutMs, ThrottlingSessionProvider throttlingSessionProvider, MyCustomLogger customLogger, TrendzProxyService trendzProxyService) {
        this.callbackTimeoutMs = callbackTimeoutMs;
        this.throttlingSessionProvider = throttlingSessionProvider;
        this.customLogger = customLogger;
        this.trendzProxyService = trendzProxyService;
    }

    public EngineProviderType getType() {
        return EngineProviderType.DOCKER_CONTAINER;
    }

    public Mono<ScriptExecutionResult> run(JwtSecurityUser user, UUID scriptExecutionId, String script, JavaType returnType, Map<String, Object> input, UUID executionRunId) {
        AtomicReference subscriptionSuccessRef = new AtomicReference();
        AtomicReference subscriptionFailedRef = new AtomicReference();
        AtomicReference subscriptionRequestTelemetryRef = new AtomicReference();
        AtomicReference subscriptionRequestAttributeRef = new AtomicReference();
        AtomicReference subscriptionRequestRelationsRef = new AtomicReference();
        AtomicReference sessionRef = new AtomicReference();
        String messageDestination = "/app/scriptExecution/run";
        String cancelDestination = "/app/scriptExecution/cancel";
        String successDestination = "/topic/success/" + String.valueOf(scriptExecutionId);
        String failedDestination = "/topic/failed/" + String.valueOf(scriptExecutionId);
        String requestTelemetryDestination = "/topic/proxy/telemetry/" + String.valueOf(scriptExecutionId);
        String requestAttributeDestination = "/topic/proxy/attribute/" + String.valueOf(scriptExecutionId);
        String requestRelationsDestination = "/topic/proxy/relations/" + String.valueOf(scriptExecutionId);
        String requestResultDestination = "/app/result";
        ScriptMessage cancellationMessage = ScriptMessage.builder().user(user).scriptExecutionId(scriptExecutionId).build();
        CountDownLatch latch = new CountDownLatch(1);
        return Mono.just((Object)new Object()).doOnNext(o -> log.debug("Start processing execution request {}", (Object)scriptExecutionId)).flatMap(o -> this.throttlingSessionProvider.getStompSession(latch, sessionRef)).flatMap(session -> Mono.create(sink -> {
            1 successHandler = new /* Unavailable Anonymous Inner Class!! */;
            2 errorHandler = new /* Unavailable Anonymous Inner Class!! */;
            3 requestTelemetryHandler = new /* Unavailable Anonymous Inner Class!! */;
            4 requestAttributeHandler = new /* Unavailable Anonymous Inner Class!! */;
            5 requestRelationsHandler = new /* Unavailable Anonymous Inner Class!! */;
            StompSession.Subscription subscriptionSuccess = session.subscribe(successDestination, (StompFrameHandler)successHandler);
            StompSession.Subscription subscriptionFailed = session.subscribe(failedDestination, (StompFrameHandler)errorHandler);
            StompSession.Subscription subscriptionRequestTelemetry = session.subscribe(requestTelemetryDestination, (StompFrameHandler)requestTelemetryHandler);
            StompSession.Subscription subscriptionRequestAttribute = session.subscribe(requestAttributeDestination, (StompFrameHandler)requestAttributeHandler);
            StompSession.Subscription subscriptionRequestRelations = session.subscribe(requestRelationsDestination, (StompFrameHandler)requestRelationsHandler);
            subscriptionSuccessRef.set(subscriptionSuccess);
            subscriptionFailedRef.set(subscriptionFailed);
            subscriptionRequestTelemetryRef.set(subscriptionRequestTelemetry);
            subscriptionRequestAttributeRef.set(subscriptionRequestAttribute);
            subscriptionRequestTelemetryRef.set(subscriptionRequestRelations);
            ScriptMessage scriptMessage = ScriptMessage.builder().user(user).scriptExecutionId(scriptExecutionId).script(script).returnType(returnType).input(input).build();
            session.send(messageDestination, (Object)scriptMessage);
            log.debug("Execution message was sent, id = {}", (Object)scriptExecutionId);
        }).timeout(Duration.ofMillis(this.callbackTimeoutMs))).map(scriptExecutionResponse -> {
            if (!scriptExecutionResponse.isSuccess()) {
                throw new PythonExecutorException(scriptExecutionResponse.getError());
            }
            log.debug("The execution message response has been received, id = {}", (Object)scriptExecutionId);
            ScriptExecutionResult executionResult = scriptExecutionResponse.getResult();
            try {
                Object rawResult = executionResult.getResult();
                String jsonResult = JsonUtils.toJson((Object)rawResult);
                Object typedResult = JsonUtils.getObjectMapper().readValue(jsonResult, returnType);
                executionResult.setResult(typedResult);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            this.customLogger.putLog(executionRunId, executionResult.getLogs().toArray(new String[0]));
            log.debug("Finished processing execution request {}", (Object)scriptExecutionId);
            return executionResult;
        }).doOnCancel(() -> {
            this.awaitLatch(latch);
            Optional.ofNullable((StompSession)sessionRef.get()).ifPresent(session -> session.send(cancelDestination, (Object)cancellationMessage));
            log.debug("Execution message cancellation was sent, id = {}", (Object)scriptExecutionId);
        }).doOnError(throwable -> {
            this.awaitLatch(latch);
            Optional.ofNullable((StompSession)sessionRef.get()).ifPresent(session -> session.send(cancelDestination, (Object)cancellationMessage));
            log.debug("Execution message cancellation was sent, id = {}", (Object)scriptExecutionId);
        }).doFinally(signalType -> {
            this.awaitLatch(latch);
            Optional.ofNullable((StompSession.Subscription)subscriptionSuccessRef.get()).ifPresent(StompSession.Subscription::unsubscribe);
            Optional.ofNullable((StompSession.Subscription)subscriptionFailedRef.get()).ifPresent(StompSession.Subscription::unsubscribe);
            Optional.ofNullable((StompSession.Subscription)subscriptionRequestTelemetryRef.get()).ifPresent(StompSession.Subscription::unsubscribe);
            Optional.ofNullable((StompSession.Subscription)subscriptionRequestAttributeRef.get()).ifPresent(StompSession.Subscription::unsubscribe);
            Optional.ofNullable((StompSession.Subscription)subscriptionRequestRelationsRef.get()).ifPresent(StompSession.Subscription::unsubscribe);
            Optional.ofNullable((StompSession)sessionRef.get()).ifPresent(StompSession::disconnect);
            this.throttlingSessionProvider.returnSession();
        });
    }

    private void awaitLatch(CountDownLatch latch) {
        try {
            latch.await(this.callbackTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Finalization latch was interrupted");
        }
    }
}

