/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.service.script.engine.JsException;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.script.engine.MyCustomLogger;
import org.thingsboard.trendz.service.script.engine.MyCustomLoggerInterface;
import org.thingsboard.trendz.service.script.engine.ScriptStats;

@Component
public class NashornJsService {
    private static final Logger log = LoggerFactory.getLogger(NashornJsService.class);
    private ScriptEngine engine;
    private Map<UUID, String> scriptIdToNameMap = new ConcurrentHashMap();
    private Map<String, UUID> bodyToScriptId = new ConcurrentHashMap();
    private volatile Map<UUID, ScriptStats> scriptStatistic = new ConcurrentHashMap();
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong duration = new AtomicLong();

    @Autowired
    public NashornJsService(ExecutorManagementService executorManagementService, MyCustomLogger logger) throws ScriptException {
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        this.engine = factory.getScriptEngine(new String[]{"--no-java"});
        MyCustomLoggerInterface loggerInterface = (executionId, message) -> {
            if (Objects.nonNull(executionId)) {
                logger.putLog(UUID.fromString(executionId), new String[]{message});
            }
        };
        this.engine.getBindings(100).put("loggerInterface", (Object)loggerInterface);
        this.rewriteJsonParse();
        ScheduledExecutorService monitorExecutorService = (ScheduledExecutorService)executorManagementService.getExecutorByName(ExecutorName.NASHORN_JS);
        monitorExecutorService.scheduleAtFixedRate(() -> this.clearScripts(), 1L, 1L, TimeUnit.MINUTES);
    }

    private void rewriteJsonParse() throws ScriptException {
        String jsonOverride = "var nashornEngineOriginalParseJson = JSON.parse; \nJSON.parse = function(text) { \n\tvar callStack; \n\ttry { \n\t\tthrow new Error(); \n\t} catch (stackError) { \n\t\tcallStack = stackError.stack; \n\t} \n\ttry { \n\t\treturn nashornEngineOriginalParseJson(text); \n\t} catch (e) { \n\t\tthrow new Error(\"The string can not be parsed as JSON: \\\"\" + text + \"\\\"\\n\" + e + callStack); \n\t} \n};";
        this.engine.eval(jsonOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ViewField viewField, String scriptBody, List<String> argNames, Object[] args) {
        Object object;
        long startTs = System.currentTimeMillis();
        try {
            UUID scriptId = this.eval(viewField, scriptBody, argNames);
            Object result = this.invokeFunction(scriptId, args);
            object = this.handleNullResult(result);
        }
        catch (Throwable throwable) {
            long endTs = System.currentTimeMillis();
            long lDur = this.duration.addAndGet(endTs - startTs);
            long lCount = this.count.incrementAndGet();
            if (lCount % 100L == 0L) {
                log.trace("ScriptEngine Count {} Duration {} Avg {}", new Object[]{lCount, lDur, lDur / lCount});
            }
            throw throwable;
        }
        long endTs = System.currentTimeMillis();
        long lDur = this.duration.addAndGet(endTs - startTs);
        long lCount = this.count.incrementAndGet();
        if (lCount % 100L == 0L) {
            log.trace("ScriptEngine Count {} Duration {} Avg {}", new Object[]{lCount, lDur, lDur / lCount});
        }
        return object;
    }

    private Object handleNullResult(Object result) {
        if ("null".equals(result)) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID eval(ViewField viewField, String scriptBody, List<String> argNames) {
        try {
            UUID scriptId = (UUID)this.bodyToScriptId.get(scriptBody);
            if (scriptId == null) {
                NashornJsService nashornJsService = this;
                synchronized (nashornJsService) {
                    if (this.bodyToScriptId.get(scriptBody) == null) {
                        UUID newScriptId = TimeStampUUIDGenerator.generateId();
                        String functionName = "invokeInternal_" + newScriptId.toString().replace('-', '_');
                        String jsScript = this.generateScript(newScriptId, functionName, scriptBody, argNames);
                        this.engine.eval(jsScript);
                        this.scriptIdToNameMap.put(newScriptId, functionName);
                        this.bodyToScriptId.put(scriptBody, newScriptId);
                        this.scriptStatistic.put(newScriptId, new ScriptStats(newScriptId));
                    }
                }
                return (UUID)this.bodyToScriptId.get(scriptBody);
            }
            return scriptId;
        }
        catch (ScriptException e) {
            throw new JsException(e);
        }
        catch (Exception e) {
            log.error("Failed to compile JS script: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    private Object invokeFunction(UUID scriptId, Object ... args) {
        try {
            this.updateStatistic(scriptId);
            String functionName = (String)this.scriptIdToNameMap.get(scriptId);
            return ((Invocable)((Object)this.engine)).invokeFunction(functionName, args);
        }
        catch (ScriptException e) {
            throw new JsException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void doRelease(UUID scriptId) {
        String functionName = (String)this.scriptIdToNameMap.get(scriptId);
        if (functionName != null) {
            try {
                this.scriptIdToNameMap.remove(scriptId);
                this.clearScriptBodyMap(scriptId);
                this.engine.eval(functionName + " = undefined;");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String generateScript(UUID scriptId, String functionName, String scriptBody, List<String> argNames) {
        String transformPrototypeArgumentListString = argNames.stream().reduce((o1, o2) -> o1 + ", \n\t" + o2).map(result -> "\n\t" + result + "\n").orElse("");
        String transformFunctionPrototypeStart = "function transformFunction(" + transformPrototypeArgumentListString + ") { \n";
        String transformFunctionPrototypeEnd = "} \n";
        String console = "var console = { \n\tlog: function() { \n\t\tvar message = Array.prototype.map.call(arguments, function(element) { var messageItem = JSON.stringify(element); if (!messageItem) { return '\"\"' } return messageItem; }).join(', '); \n\t\tloggerInterface.log(executionId, message); \n\t} \n}; \n";
        StringBuilder transformFunctionBodyBuilder = new StringBuilder();
        transformFunctionBodyBuilder.append(console + "\n");
        transformFunctionBodyBuilder.append(scriptBody + "\n");
        String transformFunctionBody = Arrays.stream(transformFunctionBodyBuilder.toString().split("\n")).map(line -> "\t" + line + "\n").reduce((o1, o2) -> o1 + o2).orElse("");
        StringBuilder transformFunctionBuilder = new StringBuilder();
        transformFunctionBuilder.append(transformFunctionPrototypeStart);
        transformFunctionBuilder.append(transformFunctionBody);
        transformFunctionBuilder.append(transformFunctionPrototypeEnd);
        String transformFunction = transformFunctionBuilder.toString();
        String finalPrototypeOutsideArgumentPrefix = "argument_outside__";
        String finalPrototypeInsideArgumentPrefix = "argument_inside__";
        String finalPrototypeArgumentListString = argNames.stream().map(arg -> finalPrototypeOutsideArgumentPrefix + arg).reduce((o1, o2) -> o1 + ", \n\t" + o2).map(result -> "\n\t" + result + "\n").orElse("");
        String finalFunctionPrototypeStart = "function " + functionName + "(" + finalPrototypeArgumentListString + ") { \n";
        String finalFunctionPrototypeEnd = "} \n";
        String parsedArgumentsDefinition = argNames.stream().map(arg -> "var " + finalPrototypeInsideArgumentPrefix + arg + " = JSON.parse(" + finalPrototypeOutsideArgumentPrefix + arg + "); ").reduce((o1, o2) -> o1 + "\n" + o2).orElse("");
        String transformFunctionUsageArgumentListString = argNames.stream().map(arg -> finalPrototypeInsideArgumentPrefix + arg).reduce((o1, o2) -> o1 + ", \n\t" + o2).map(result -> "\n\t" + result + "\n").orElse("");
        String transformFunctionCall = "return JSON.stringify(transformFunction(" + transformFunctionUsageArgumentListString + "));";
        StringBuilder finalFunctionBodyBuilder = new StringBuilder();
        finalFunctionBodyBuilder.append(transformFunction + "\n");
        finalFunctionBodyBuilder.append("\n");
        finalFunctionBodyBuilder.append(parsedArgumentsDefinition + "\n");
        finalFunctionBodyBuilder.append("\n");
        finalFunctionBodyBuilder.append(transformFunctionCall + "\n");
        String finalFunctionBody = Arrays.stream(finalFunctionBodyBuilder.toString().split("\n")).map(line -> "\t" + line + "\n").reduce((o1, o2) -> o1 + o2).orElse("");
        StringBuilder finalFunctionBuilder = new StringBuilder();
        finalFunctionBuilder.append(finalFunctionPrototypeStart);
        finalFunctionBuilder.append(finalFunctionBody);
        finalFunctionBuilder.append(finalFunctionPrototypeEnd);
        String finalFunction = finalFunctionBuilder.toString();
        return finalFunction;
    }

    private void updateStatistic(UUID scriptId) {
        ScriptStats stats = (ScriptStats)this.scriptStatistic.get(scriptId);
        if (stats != null) {
            stats.getInvocationCount().incrementAndGet();
            stats.getLastInvocationTs().set(System.currentTimeMillis());
        }
    }

    private void clearScriptBodyMap(UUID scriptId) {
        String body = null;
        for (Map.Entry entry : this.bodyToScriptId.entrySet()) {
            if (!((UUID)entry.getValue()).equals(scriptId)) continue;
            body = (String)entry.getKey();
            break;
        }
        if (body != null) {
            this.bodyToScriptId.remove(body);
        }
    }

    private void clearScripts() {
        ArrayList scriptStats = Lists.newArrayList(this.scriptStatistic.values());
        int beforeClearSize = scriptStats.size();
        long scpritTTL = TimeUnit.HOURS.toMillis(1L);
        if (scriptStats.size() > 100) {
            scpritTTL = TimeUnit.MINUTES.toMillis(2L);
        }
        for (ScriptStats stats : scriptStats) {
            if (System.currentTimeMillis() - stats.getLastInvocationTs().get() <= scpritTTL) continue;
            try {
                this.scriptStatistic.remove(stats.getId());
                this.doRelease(stats.getId());
            }
            catch (Exception ex) {
                log.error("Error while releasing JS function", (Throwable)ex);
            }
        }
        log.debug("compiled JS Scripts before {} , after {}", (Object)beforeClearSize, (Object)this.scriptStatistic.size());
    }
}

