/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.calculatedfield;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.exception.service.script.ScriptFormatException;
import org.thingsboard.trendz.exception.service.script.ScriptProcessingException;
import org.thingsboard.trendz.exception.service.script.engine.JsException;
import org.thingsboard.trendz.exception.service.script.engine.PythonException;
import org.thingsboard.trendz.exception.service.script.engine.PythonExecutorException;
import org.thingsboard.trendz.exception.service.script.engine.ScriptEngineException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.calculatedfield.FieldDto;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;
import org.thingsboard.trendz.service.script.engine.NashornJsService;
import org.thingsboard.trendz.service.script.engine.PythonScriptEngine;
import org.thingsboard.trendz.service.script.engine.ScriptExecutionResult;
import org.thingsboard.trendz.service.script.engine.provider.docker.model.ErrorMessage;
import org.thingsboard.trendz.service.script.engine.provider.docker.model.ErrorMessageType;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class ScriptCalculationService {
    private static final Logger log = LoggerFactory.getLogger(ScriptCalculationService.class);
    public static final String EXECUTION_ID_SCRIPT_ARGUMENT = "executionId";
    private final int callbackTimeoutMs;
    private final NashornJsService jsService;
    private final PythonScriptEngine pythonScriptEngine;

    @Autowired
    public ScriptCalculationService(@Value(value="${script-engine.callback-timeout}") int callbackTimeoutMs, NashornJsService jsService, PythonScriptEngine pythonScriptEngine) {
        this.callbackTimeoutMs = callbackTimeoutMs;
        this.jsService = jsService;
        this.pythonScriptEngine = pythonScriptEngine;
    }

    public Object processScript(JwtSecurityUser user, ViewField viewField, ScriptLanguage language, String fieldName, Map<String, Object> fieldToValuesMap, String script, long startTs, long endTs, String groupBy, ZoneId zoneId, Map<String, Object> rowDataMap) {
        return this.safeExecute(() -> this.processScript(user, viewField, language, fieldToValuesMap, script, startTs, endTs, groupBy, zoneId, rowDataMap), fieldName, script, this.getArgNames(fieldToValuesMap), language, CalculationFieldType.SIMPLE);
    }

    public List<FieldValue> processBatchedScript(JwtSecurityUser user, ViewField viewField, ScriptLanguage language, String fieldName, Map<String, List<FieldValue>> fieldToValuesMap, String script, List<String> argNames, long startTs, long endTs, String groupBy, ZoneId zoneId) {
        return (List)this.safeExecute(() -> this.processBatchedScript(user, viewField, language, fieldToValuesMap, script, argNames, startTs, endTs, groupBy, zoneId), fieldName, script, argNames, language, CalculationFieldType.BATCH);
    }

    public List<FieldValue> processNativeScript(JwtSecurityUser user, UUID itemId, BusinessEntityType entityType, ViewField viewField, ScriptLanguage language, String fieldName, String script, long startTs, long endTs, String groupBy, ZoneId zoneId) {
        return this.processNativeScript(user, itemId, entityType, viewField, language, fieldName, script, startTs, endTs, groupBy, zoneId, null);
    }

    public List<FieldValue> processNativeScript(JwtSecurityUser user, UUID itemId, BusinessEntityType entityType, ViewField viewField, ScriptLanguage language, String fieldName, String script, long startTs, long endTs, String groupBy, ZoneId zoneId, List<String> logsContainer) {
        return (List)this.safeExecute(() -> this.processNativeScript(user, itemId, entityType, viewField, language, script, startTs, endTs, groupBy, zoneId, logsContainer), fieldName, script, Collections.emptyList(), language, CalculationFieldType.NATIVE);
    }

    private Object processScript(JwtSecurityUser user, ViewField viewField, ScriptLanguage language, Map<String, Object> fieldToValuesMap, String script, long startTs, long endTs, String groupBy, ZoneId zoneId, Map<String, Object> rowDataMap) {
        viewField.setScriptDebugLogId(UUID.randomUUID());
        return switch (2.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$ScriptLanguage[language.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                List argNames = this.getArgNames(fieldToValuesMap);
                Object[] args = this.prepareArguments(argNames, fieldToValuesMap, rowDataMap, startTs, endTs, groupBy, zoneId, viewField.getScriptDebugLogId());
                yield this.jsService.execute(viewField, script, argNames, args);
            }
            case 2 -> {
                JavaType type = JsonUtils.getObjectMapper().getTypeFactory().constructType(String.class);
                HashMap<String, Object> input = new HashMap<String, Object>(fieldToValuesMap);
                this.populateInputMapWithGeneralParams(input, startTs, endTs, groupBy, zoneId);
                input.put("row", rowDataMap);
                ScriptExecutionResult executionResult = (ScriptExecutionResult)DonReactive.block((Mono)this.pythonScriptEngine.runScript(user, script, type, input, viewField.getScriptDebugLogId()), (Duration)Duration.ofMillis(this.callbackTimeoutMs));
                yield executionResult.getResult();
            }
        };
    }

    private List<FieldValue> processBatchedScript(JwtSecurityUser user, ViewField viewField, ScriptLanguage language, Map<String, List<FieldValue>> fieldToValuesMap, String script, List<String> argNames, long startTs, long endTs, String groupBy, ZoneId zoneId) throws Exception {
        argNames.sort(String::compareTo);
        return switch (2.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$ScriptLanguage[language.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                Object[] args = this.prepareBatchedArguments(argNames, fieldToValuesMap, startTs, endTs, groupBy, zoneId, viewField.getScriptDebugLogId());
                Object object = this.jsService.execute(viewField, script, argNames, args);
                yield this.mapToBatchedValues(object);
            }
            case 2 -> {
                CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, FieldDto.class);
                Map<String, Object> input = fieldToValuesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, i -> ((List)i.getValue()).stream().map(FieldDto::fromField).collect(Collectors.toList())));
                this.populateInputMapWithGeneralParams(input, startTs, endTs, groupBy, zoneId);
                ScriptExecutionResult executionResult = (ScriptExecutionResult)this.pythonScriptEngine.runScript(user, script, (JavaType)type, input, viewField.getScriptDebugLogId()).toFuture().get(this.callbackTimeoutMs, TimeUnit.MILLISECONDS);
                yield this.mapResultToFields(executionResult.getResult());
            }
        };
    }

    private List<FieldValue> processNativeScript(JwtSecurityUser user, UUID itemId, BusinessEntityType entityType, ViewField viewField, ScriptLanguage language, String script, long startTs, long endTs, String groupBy, ZoneId zoneId, List<String> logsContainer) throws Exception {
        if (language != ScriptLanguage.PYTHON) {
            throw new IllegalArgumentException("Unsupported script language: " + String.valueOf(language));
        }
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, FieldDto.class);
        HashMap input = new HashMap();
        this.populateInputMapWithGeneralParams(input, startTs, endTs, groupBy, zoneId);
        script = "import requests\nimport json\n\n_base_url = \"http://localhost:8181\"\n_originator_type = \"%s\"\n_originator_id = \"%s\"\n\ndef get_originator_type():\n    return _originator_type\n\ndef get_originator_id():\n    return _originator_id\n\ndef _post_json(url, body):\n    headers = {\n        \"Content-Type\": \"application/json\"\n    }\n    try:\n        resp = requests.post(url, headers=headers, json=body, timeout=30)\n    except requests.RequestException as e:\n        raise requests.RequestException(\n            f\"[REQUEST ERROR] {e}\\nURL: {url}\\nRequest body: {body}\"\n        ) from e\n\n    if resp.status_code >= 400:\n        # \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0434\u043e\u0441\u0442\u0430\u0442\u044c JSON, \u0438\u043d\u0430\u0447\u0435 \u0432\u043e\u0437\u044c\u043c\u0451\u043c \u0442\u0435\u043a\u0441\u0442\n        try:\n            detail = json.dumps(resp.json(), ensure_ascii=False)\n        except Exception:\n            detail = resp.text\n        # \u0414\u043e\u0431\u0430\u0432\u0438\u043c \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435\n        msg = (\n            f\"[HTTP {resp.status_code}] POST {url}\\n\"\n            f\"Request body: {body}\\n\"\n            f\"Response: {detail[:4000]}\"\n        )\n        # \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u043c \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c \u0441 raise_for_status, \u043d\u043e \u0441 \u0431\u043e\u0433\u0430\u0442\u044b\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c\n        http_err = requests.HTTPError(msg, response=resp)\n        raise http_err\n\n    # \u0412\u0435\u0440\u043d\u0451\u043c JSON, \u0435\u0441\u043b\u0438 \u043e\u043d \u0435\u0441\u0442\u044c, \u0438\u043d\u0430\u0447\u0435 \u0441\u043e\u043e\u0431\u0449\u0438\u043c \u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0435 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430\n    try:\n        return resp.json()\n    except ValueError:\n        raise ValueError(\n            f\"[PARSE ERROR] Expected JSON but got:\\n{resp.text[:4000]}\\nURL: {url}\"\n        )\n\ndef get_telemetries(keys, from_ts=startTs, to_ts=endTs, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/telemetry/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"startTs\": from_ts,\n        \"endTs\": to_ts,\n        \"keys\": keys\n    }\n    return _post_json(url, body)\n\ndef get_attributes(attributes, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/attributes/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"attributes\": attributes\n    }\n    return _post_json(url, body)\n\ndef get_relations(entity_id=_originator_id, entity_type=_originator_type, direction=None, relation_type=None, target_entity_type=None, target_entity_profile_name=None):\n    url = f\"{_base_url}/proxy/relations/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id\n    }\n    if direction is not None:\n        body[\"direction\"] = direction\n    if relation_type is not None:\n        body[\"relationType\"] = relation_type\n    if target_entity_type is not None:\n        body[\"targetEntityType\"] = target_entity_type\n    if target_entity_profile_name is not None:\n        body[\"targetEntityProfileName\"] = target_entity_profile_name\n\n    return _post_json(url, body)\n\n%s\n".formatted(entityType, itemId, script == null ? "" : script);
        ScriptExecutionResult executionResult = (ScriptExecutionResult)this.pythonScriptEngine.runScript(user, script, (JavaType)type, input, viewField.getScriptDebugLogId()).toFuture().get(this.callbackTimeoutMs, TimeUnit.MILLISECONDS);
        if (logsContainer != null) {
            logsContainer.addAll(executionResult.getLogs());
        }
        return this.mapResultToFields(executionResult.getResult());
    }

    private <T> T safeExecute(Callable<T> supplier, String fieldName, String script, List<String> argNames, ScriptLanguage language, CalculationFieldType calculationFieldType) {
        try {
            return supplier.call();
        }
        catch (ScriptEngineException scriptEngineException) {
            throw this.processScriptEngineException(scriptEngineException, fieldName, script, argNames, language, calculationFieldType);
        }
        catch (ScriptFormatException scriptFormatException) {
            throw new ScriptProcessingException(fieldName, script, argNames, language, (Throwable)scriptFormatException, calculationFieldType);
        }
        catch (RuntimeException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof ScriptEngineException) {
                ScriptEngineException scriptEngineException = (ScriptEngineException)throwable;
                throw this.processScriptEngineException(scriptEngineException, fieldName, script, argNames, language, calculationFieldType);
            }
            throw exception;
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof ScriptEngineException) {
                ScriptEngineException scriptEngineException = (ScriptEngineException)throwable;
                throw this.processScriptEngineException(scriptEngineException, fieldName, script, argNames, language, calculationFieldType);
            }
            throw new RuntimeException(exception);
        }
    }

    private List<String> getArgNames(Map<String, Object> fieldToValuesMap) {
        return fieldToValuesMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    private Object[] prepareArguments(List<String> keyList, Map<String, Object> fieldToValuesMap, Map<String, Object> rowDataMap, long startTs, long endTs, String groupBy, ZoneId zoneId, UUID executionId) {
        String tzName = zoneId.getId();
        long tzOffsetMs = DateTimeUtils.getOffsetInMilliseconds((ZoneId)zoneId);
        List<String> alwaysPresentArguments = List.of("startTs", "endTs", "groupBy", "row", "tzName", "tzOffsetMs", EXECUTION_ID_SCRIPT_ARGUMENT);
        int entryCount = keyList.size();
        Object[] args = new Object[entryCount + alwaysPresentArguments.size()];
        for (int i = 0; i < entryCount; ++i) {
            String key = keyList.get(i);
            Object value = fieldToValuesMap.get(key);
            args[i] = JsonUtils.toJson((Object)value);
        }
        keyList.addAll(alwaysPresentArguments);
        args[entryCount] = "" + startTs;
        args[entryCount + 1] = "" + endTs;
        args[entryCount + 2] = JsonUtils.toJson((Object)groupBy);
        args[entryCount + 3] = JsonUtils.toJson(rowDataMap);
        args[entryCount + 4] = JsonUtils.toJson((Object)tzName);
        args[entryCount + 5] = "" + tzOffsetMs;
        args[entryCount + 6] = JsonUtils.toJson((Object)executionId);
        return args;
    }

    private Object[] prepareBatchedArguments(List<String> argNames, Map<String, List<FieldValue>> fieldToValuesMap, long startTs, long endTs, String groupBy, ZoneId zoneId, UUID scriptExecutionRunId) {
        String tzName = zoneId.getId();
        long tzOffsetMs = DateTimeUtils.getOffsetInMilliseconds((ZoneId)zoneId);
        List<String> scriptArgsList = List.of("startTs", "endTs", "groupBy", "tzName", "tzOffsetMs", EXECUTION_ID_SCRIPT_ARGUMENT);
        int coreScriptArgsCount = scriptArgsList.size();
        Object[] argValuesArr = new Object[argNames.size() + coreScriptArgsCount];
        for (int i = 0; i < argNames.size(); ++i) {
            boolean blank;
            String key = argNames.get(i);
            List<FieldValue> values = fieldToValuesMap.get(key);
            boolean bl = blank = values.size() == 1 && values.get(0).getFieldType() == FieldType.BLANK;
            if (blank) {
                argValuesArr[i] = "[]";
                continue;
            }
            List collect = values.stream().map(FieldDto::fromField).collect(Collectors.toList());
            argValuesArr[i] = JsonUtils.toJson(collect);
        }
        int argumentsCount = argNames.size();
        argNames.addAll(scriptArgsList);
        argValuesArr[argumentsCount] = "" + startTs;
        argValuesArr[argumentsCount + 1] = "" + endTs;
        argValuesArr[argumentsCount + 2] = JsonUtils.toJson((Object)groupBy);
        argValuesArr[argumentsCount + 3] = JsonUtils.toJson((Object)tzName);
        argValuesArr[argumentsCount + 4] = "" + tzOffsetMs;
        argValuesArr[argumentsCount + 5] = JsonUtils.toJson((Object)scriptExecutionRunId);
        return argValuesArr;
    }

    private List<FieldValue> mapToBatchedValues(Object raw) {
        try {
            if (raw == null) {
                return Collections.emptyList();
            }
            List values = (List)JsonUtils.fromJson((String)raw.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return values.stream().map(FieldDto::toField).collect(Collectors.toList());
        }
        catch (Exception exception) {
            String message = String.format("The calculated field must return list of (ts, value) data!\nReturned wrong data: %s", raw);
            throw new IllegalStateException(message, exception);
        }
    }

    private RuntimeException processScriptEngineException(ScriptEngineException e, String fieldName, String script, List<String> argNames, ScriptLanguage language, CalculationFieldType fieldType) {
        Throwable throwable = e.getCause();
        if (throwable instanceof PythonExecutorException) {
            PythonExecutorException cause = (PythonExecutorException)throwable;
            ErrorMessage errorMessage = cause.getErrorMessage();
            if (errorMessage.getType() == ErrorMessageType.RUNTIME) {
                PythonException pythonException = new PythonException(errorMessage.getExecutionResult());
                return new ScriptProcessingException(fieldName, script, argNames, language, (Throwable)pythonException, fieldType);
            }
            return cause;
        }
        if (e.getCause() instanceof PythonException) {
            return new ScriptProcessingException(fieldName, script, argNames, language, e.getCause(), fieldType);
        }
        if (e instanceof JsException) {
            return new ScriptProcessingException(fieldName, script, argNames, language, (Throwable)e, fieldType);
        }
        return new RuntimeException(e.getCause());
    }

    private void populateInputMapWithGeneralParams(Map<String, Object> input, long startTs, long endTs, String groupBy, ZoneId zoneId) {
        String tzName = zoneId.getId();
        if ("Europe/Kiev".equals(tzName)) {
            tzName = "Europe/Kyiv";
        }
        long tzOffsetMs = DateTimeUtils.getOffsetInMilliseconds((ZoneId)zoneId);
        input.put("startTs", startTs);
        input.put("endTs", endTs);
        input.put("groupBy", groupBy);
        input.put("tzName", tzName);
        input.put("tzOffsetMs", tzOffsetMs);
    }

    private List<FieldValue> mapResultToFields(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            List<FieldValue> result = list.stream().filter(FieldDto.class::isInstance).map(FieldDto.class::cast).map(FieldDto::toField).collect(Collectors.toList());
            if (result.size() == list.size()) {
                return result;
            }
            throw new ScriptFormatException("Invalid element types! All list items must be in format: {'value': <value>, 'ts': <ts>}");
        }
        throw new ScriptFormatException("Incorrect output format! Script should return data in format: [{'value': <value>, 'ts': <ts>}, ...]");
    }
}

