/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.calculatedfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationKey;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.FieldState;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CalculatedFieldProcessor {
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldProcessor.class);
    private static final Object NULL_SCRIPT_RESULT = new Object();
    private final ScriptCalculationService scriptCalculationService;

    @Autowired
    public CalculatedFieldProcessor(ScriptCalculationService scriptCalculationService) {
        this.scriptCalculationService = scriptCalculationService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.CALCULATION_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Flux<AggregatedValue> processCalculatedField(Row row, ViewField viewField, ViewRequest viewRequest, ViewContext ctx) {
        try {
            ViewField lowestDateField = this.getLowestDateField(viewRequest);
            boolean rawDateAggregationPresent = this.isRawDateAggregationPresent(viewRequest);
            Set dateGroups = this.extractAllDateGroupsForCalculation(viewField, viewRequest, row);
            boolean withoutDateGroups = dateGroups.isEmpty();
            if (withoutDateGroups) {
                dateGroups.add(null);
            }
            HashMap dateGroupToCalculationMap = new HashMap();
            for (DateAggregationGroup dateGroup : dateGroups) {
                List fieldDataFromRow = this.getFieldDataFromRow(row, dateGroup, rawDateAggregationPresent, lowestDateField);
                Map rowData = fieldDataFromRow.stream().collect(HashMap::new, (m, v) -> m.put((String)v.getLeft(), v.getRight()), HashMap::putAll);
                Map fieldToValuesMapList = this.getConditionalFieldsDataFromRow(row, viewField, dateGroup);
                List combinedData = this.combineData(fieldToValuesMapList);
                ArrayList<Object> calculationList = new ArrayList<Object>();
                dateGroupToCalculationMap.put(dateGroup, calculationList);
                for (Map fieldToValuesMap : combinedData) {
                    Object calculation2 = this.proceedCalculation(ctx.getUser(), fieldToValuesMap, viewField, viewRequest, rowData);
                    Object calculationResultOrNullString = Objects.requireNonNullElse(calculation2, NULL_SCRIPT_RESULT);
                    calculationList.add(calculationResultOrNullString);
                }
            }
            if (withoutDateGroups) {
                List calculationList = (List)dateGroupToCalculationMap.get(null);
                return Flux.fromIterable((Iterable)calculationList).map(calculation -> {
                    FieldValue fieldValue = CalculatedFieldProcessor.getFieldValue((Object)calculation, (Long)0L);
                    return new AggregatedValue(fieldValue, Collections.emptySet());
                }).defaultIfEmpty((Object)this.getEmptyValue());
            }
            int valuesCount = ((List)dateGroupToCalculationMap.values().iterator().next()).size();
            ArrayList<AggregatedValue> result = new ArrayList<AggregatedValue>();
            for (int i = 0; i < valuesCount; ++i) {
                HashMap<DateAggregationGroup, FieldValue> resultDateGroups = new HashMap<DateAggregationGroup, FieldValue>();
                for (DateAggregationGroup dateGroup : dateGroups) {
                    DateAggregationKey key = new DateAggregationKey(lowestDateField.getId(), lowestDateField.getDateGrouping());
                    DateAggregationValue dateValue = dateGroup.get(key);
                    long ts = 0L;
                    if (rawDateAggregationPresent) {
                        ts = dateValue.getTs();
                    }
                    List calculationList = (List)dateGroupToCalculationMap.get(dateGroup);
                    Object calculation3 = calculationList.get(i);
                    resultDateGroups.put(dateGroup, CalculatedFieldProcessor.getFieldValue(calculation3, (Long)ts));
                }
                AggregatedValue aggregatedValue = new AggregatedValue(null, Collections.emptySet(), resultDateGroups);
                result.add(aggregatedValue);
            }
            return Flux.fromIterable(result).defaultIfEmpty((Object)this.getEmptyValue());
        }
        catch (Throwable throwable) {
            throw new TrendzInternalException("Error during processing calculation field.", throwable);
        }
    }

    private static FieldValue getFieldValue(Object calculation, Long ts) {
        FieldValue fieldValue = NumberUtils.isCreatable((String)calculation.toString()) ? new FieldValue(Collections.emptySet(), FieldType.NUMERIC, (Object)Double.parseDouble(calculation.toString()), ts.longValue()) : (NULL_SCRIPT_RESULT.equals(calculation) ? new FieldValue(Collections.emptySet(), FieldType.BLANK, null, ts.longValue()) : new FieldValue(Collections.emptySet(), FieldType.STRING, calculation, ts.longValue()));
        return fieldValue;
    }

    private Set<DateAggregationGroup> extractAllDateGroupsForCalculation(ViewField field, ViewRequest viewRequest, Row row) {
        Set dateGroups = this.extractAllDateGroups(row);
        long lastAcceptableTs = viewRequest.getEndTs(field) + (long)field.getPredictionRangeSec() * 1000L;
        return dateGroups.stream().filter(dg -> ((DateAggregationValue)dg.getKeys().values().iterator().next()).getTs() < lastAcceptableTs).collect(Collectors.toSet());
    }

    private Set<DateAggregationGroup> extractAllDateGroups(Row row) {
        HashSet<DateAggregationGroup> dateGroups = new HashSet<DateAggregationGroup>();
        HashSet<DateAggregationGroup> latestDateGroups = new HashSet<DateAggregationGroup>();
        for (ViewField viewField : row.getOrderedFields()) {
            FieldState fieldState = (FieldState)row.getFieldStates().get(viewField.getId());
            if (!fieldState.isProcessed()) continue;
            AggregatedValue aggregatedValue = fieldState.getValue();
            Set groups = Optional.ofNullable(aggregatedValue.getDateGroups()).map(Map::keySet).orElse(Collections.emptySet());
            if (viewField.getAggregationType() == FieldAggregation.LATEST) {
                latestDateGroups.addAll(groups);
                continue;
            }
            if (!aggregatedValue.hasDateGroups()) continue;
            dateGroups.addAll(groups);
        }
        if (dateGroups.isEmpty()) {
            return latestDateGroups;
        }
        return dateGroups;
    }

    private Map<String, List<Object>> getConditionalFieldsDataFromRow(Row row, ViewField viewField, DateAggregationGroup dateGroup) {
        return viewField.getConditionFieldIds().entrySet().stream().map(entry -> {
            String conditionKey = (String)entry.getKey();
            ViewField conditionField = (ViewField)entry.getValue();
            return this.extractDataFromRowByViewField(row, conditionKey, conditionField, dateGroup);
        }).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), (List)v.getValue()), HashMap::putAll);
    }

    private List<Triple<String, String, Object>> getFieldDataFromRow(Row row, DateAggregationGroup dateGroup, boolean rawDateAggregationPresent, ViewField lowestDateField) {
        ArrayList<Triple<String, String, Object>> rowData = new ArrayList<Triple<String, String, Object>>();
        List orderedFields = row.getOrderedFields();
        if (lowestDateField != null && rawDateAggregationPresent && dateGroup != null) {
            DateAggregationKey key = new DateAggregationKey(lowestDateField.getId(), lowestDateField.getDateGrouping());
            DateAggregationValue value = dateGroup.get(key);
            long ts = value.getTs();
            rowData.add((Triple<String, String, Object>)Triple.of((Object)"DateSUM", (Object)"row['DateSUM']", (Object)ts));
        }
        for (ViewField viewField : orderedFields) {
            if (viewField.isHidden() || viewField.isMissedRelationField()) continue;
            FieldState fieldState = row.getFieldState(viewField);
            if (!fieldState.isProcessed()) break;
            String key = viewField.getLabel() + String.valueOf(viewField.getAggregationType());
            Pair pair = this.extractDataFromRowByViewField(row, key, viewField, dateGroup);
            if (((List)pair.getValue()).size() != 1) {
                throw new IllegalStateException("Row data set can not be multiple.");
            }
            Object value = ((List)pair.getValue()).iterator().next();
            rowData.add((Triple<String, String, Object>)Triple.of((Object)((String)pair.getKey()), (Object)("row['" + viewField.getLabel() + String.valueOf(viewField.getAggregationType()) + "']"), value));
        }
        return rowData;
    }

    private Pair<String, List<Object>> extractDataFromRowByViewField(Row row, String viewFieldKey, ViewField viewField, DateAggregationGroup dateGroup) {
        if (viewField.isMissedRelationField()) {
            throw new IllegalStateException("Missed relation view field can not be used!");
        }
        FieldState fieldState = row.getFieldState(viewField);
        if (fieldState == null) {
            throw new TrendzInternalException("Can not find field state of the needed argument data.");
        }
        if (!fieldState.isProcessed()) {
            throw new TrendzInternalException("Field state of the needed argument data is not processed yet.");
        }
        AggregatedValue aggregatedValue = fieldState.getValue();
        if (viewField.getAggregationType() == FieldAggregation.LATEST && aggregatedValue.getDateGroups() != null) {
            FieldValue fieldValue = (FieldValue)aggregatedValue.getDateGroups().values().iterator().next();
            return Pair.of((Object)viewFieldKey, Collections.singletonList(fieldValue.getInnerValue()));
        }
        if (aggregatedValue.hasDateGroups()) {
            Map dateGroups = aggregatedValue.getDateGroups();
            FieldValue fieldValue = (FieldValue)dateGroups.get(dateGroup);
            Object value = fieldValue == null ? null : fieldValue.getInnerValue();
            return Pair.of((Object)viewFieldKey, Collections.singletonList(value));
        }
        if (aggregatedValue.getFieldValue() != null) {
            FieldValue fieldValue = aggregatedValue.getFieldValue();
            Object innerValue = fieldValue.getInnerValue();
            boolean hidden = viewField.isHidden();
            if (innerValue == null) {
                return Pair.of((Object)viewFieldKey, Collections.singletonList(null));
            }
            if (hidden) {
                Set valueSet = (Set)innerValue;
                return Pair.of((Object)viewFieldKey, new ArrayList(valueSet));
            }
            return Pair.of((Object)viewFieldKey, Collections.singletonList(innerValue));
        }
        throw new IllegalStateException("Not valid aggregation value");
    }

    private List<Map<String, Object>> combineData(Map<String, List<Object>> input) {
        if (input.isEmpty()) {
            return Collections.singletonList(new HashMap());
        }
        boolean isValid = input.values().stream().map(List::size).distinct().allMatch(i -> i == 1);
        if (!isValid) {
            throw new IllegalStateException("Input values for calculation fields has ambiguous values.");
        }
        ArrayList<Map<String, Object>> combinedData = new ArrayList<Map<String, Object>>();
        ArrayList<String> keys = new ArrayList<String>(input.keySet());
        int size = input.get(keys.get(0)).size();
        for (int i2 = 0; i2 < size; ++i2) {
            HashMap<String, Object> combinedMap = new HashMap<String, Object>();
            for (String key : keys) {
                List<Object> values = input.get(key);
                combinedMap.put(key, values.get(i2));
            }
            combinedData.add(combinedMap);
        }
        return combinedData;
    }

    private ViewField getLowestDateField(ViewRequest viewRequest) {
        DateAggregationType minimalDateAggregation = viewRequest.getMinimalDateAggregation();
        return viewRequest.getDateAggregationFieldsVisible().stream().filter(viewField -> viewField.getDateGrouping() == DateAggregationType.RAW).findAny().orElseGet(() -> viewRequest.getDateAggregationFieldsVisible().stream().filter(viewField -> viewField.getDateGrouping() == minimalDateAggregation).findAny().orElse(null));
    }

    private boolean isRawDateAggregationPresent(ViewRequest viewRequest) {
        return viewRequest.getDateAggregationFieldsVisible().stream().anyMatch(f -> f.getDateGrouping().equals((Object)DateAggregationType.RAW));
    }

    private Object proceedCalculation(JwtSecurityUser user, Map<String, Object> input, ViewField viewField, ViewRequest viewRequest, Map<String, Object> rowData) {
        return this.scriptCalculationService.processScript(user, viewField, viewField.getScriptLanguage(), viewField.getLabel(), input, viewField.getParsedCondition(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField), viewRequest.getGroupBy(), viewRequest.getZoneId(), rowData);
    }

    private AggregatedValue getEmptyValue() {
        Set items = Collections.emptySet();
        return new AggregatedValue(new FieldValue(items, FieldType.BLANK, null), items);
    }
}

