/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.calculatedfield;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class BatchFieldScriptProcessor {
    private static final Logger log = LoggerFactory.getLogger(BatchFieldScriptProcessor.class);
    private final ScriptCalculationService scriptCalculationService;

    @Autowired
    public BatchFieldScriptProcessor(ScriptCalculationService scriptCalculationService) {
        this.scriptCalculationService = scriptCalculationService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.BATCH_CALCULATION_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> processBatchedCalculatedField(Item item, ViewField viewField, ViewRequest viewRequest, ViewContext ctx, Mono<Map<String, List<FieldValue>>> itemDataBundleLoaderLoadValues) {
        return itemDataBundleLoaderLoadValues.map(fieldToValuesMap -> this.scriptCalculationService.processBatchedScript(ctx.getUser(), viewField, viewField.getScriptLanguage(), viewField.getLabel(), fieldToValuesMap, viewField.getParsedCondition(), (List)Lists.newArrayList(viewField.getConditionFieldIds().keySet()), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField), viewRequest.getGroupBy(), viewRequest.getZoneId())).map(resultFieldValues -> {
            if (viewField.getAggregationType() == FieldAggregation.COUNT) {
                return resultFieldValues.stream().map(fv -> new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs())).collect(Collectors.toList());
            }
            return resultFieldValues;
        }).doOnNext(resultFieldValues -> resultFieldValues.forEach(f -> f.setItems(Collections.singleton(item)))).flatMapIterable(l -> l).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }
}

