/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script;

public final class Scripts {
    public static final String DEFAULT_SCRIPT_TEMPLATE = "_script_execution_id = \"%s\"\n\n%s\n\n";
    public static final String NATIVE_CALCULATION_FIELD_LIB = "import requests\nimport json\n\n_base_url = \"http://localhost:8181\"\n_originator_type = \"%s\"\n_originator_id = \"%s\"\n\ndef get_originator_type():\n    return _originator_type\n\ndef get_originator_id():\n    return _originator_id\n\ndef _post_json(url, body):\n    headers = {\n        \"Content-Type\": \"application/json\"\n    }\n    try:\n        resp = requests.post(url, headers=headers, json=body, timeout=30)\n    except requests.RequestException as e:\n        raise requests.RequestException(\n            f\"[REQUEST ERROR] {e}\\nURL: {url}\\nRequest body: {body}\"\n        ) from e\n\n    if resp.status_code >= 400:\n        # \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0434\u043e\u0441\u0442\u0430\u0442\u044c JSON, \u0438\u043d\u0430\u0447\u0435 \u0432\u043e\u0437\u044c\u043c\u0451\u043c \u0442\u0435\u043a\u0441\u0442\n        try:\n            detail = json.dumps(resp.json(), ensure_ascii=False)\n        except Exception:\n            detail = resp.text\n        # \u0414\u043e\u0431\u0430\u0432\u0438\u043c \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435\n        msg = (\n            f\"[HTTP {resp.status_code}] POST {url}\\n\"\n            f\"Request body: {body}\\n\"\n            f\"Response: {detail[:4000]}\"\n        )\n        # \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u043c \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c \u0441 raise_for_status, \u043d\u043e \u0441 \u0431\u043e\u0433\u0430\u0442\u044b\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c\n        http_err = requests.HTTPError(msg, response=resp)\n        raise http_err\n\n    # \u0412\u0435\u0440\u043d\u0451\u043c JSON, \u0435\u0441\u043b\u0438 \u043e\u043d \u0435\u0441\u0442\u044c, \u0438\u043d\u0430\u0447\u0435 \u0441\u043e\u043e\u0431\u0449\u0438\u043c \u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0435 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430\n    try:\n        return resp.json()\n    except ValueError:\n        raise ValueError(\n            f\"[PARSE ERROR] Expected JSON but got:\\n{resp.text[:4000]}\\nURL: {url}\"\n        )\n\ndef get_telemetries(keys, from_ts=startTs, to_ts=endTs, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/telemetry/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"startTs\": from_ts,\n        \"endTs\": to_ts,\n        \"keys\": keys\n    }\n    return _post_json(url, body)\n\ndef get_attributes(attributes, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/attributes/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"attributes\": attributes\n    }\n    return _post_json(url, body)\n\ndef get_relations(entity_id=_originator_id, entity_type=_originator_type, direction=None, relation_type=None, target_entity_type=None, target_entity_profile_name=None):\n    url = f\"{_base_url}/proxy/relations/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id\n    }\n    if direction is not None:\n        body[\"direction\"] = direction\n    if relation_type is not None:\n        body[\"relationType\"] = relation_type\n    if target_entity_type is not None:\n        body[\"targetEntityType\"] = target_entity_type\n    if target_entity_profile_name is not None:\n        body[\"targetEntityProfileName\"] = target_entity_profile_name\n\n    return _post_json(url, body)\n\n%s\n";

    private Scripts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

