/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script;

import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.ScriptAdditionalService;
import org.thingsboard.trendz.service.script.ScriptFieldPreprocessor;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;
import org.thingsboard.trendz.service.script.engine.MyCustomLogger;
import org.thingsboard.trendz.service.script.state.StateCondition;
import org.thingsboard.trendz.service.script.state.StateConditionService;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Service
public class ScriptFieldPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(ScriptFieldPreprocessor.class);
    private static final Set<FieldAggregation> ALLOWED_STATE_FIELD_AGGREGATIONS = Set.of(FieldAggregation.NONE, FieldAggregation.UNIQ);
    private static final Map<FieldAggregation, String> FIELD_AGGREGATION_TO_FUNCTION_NAME_MAP = Map.of(FieldAggregation.SUM, "sum", FieldAggregation.AVG, "avg", FieldAggregation.MIN, "min", FieldAggregation.MAX, "max", FieldAggregation.LATEST, "latest", FieldAggregation.COUNT, "count", FieldAggregation.NONE, "none", FieldAggregation.UNIQ, "uniq");
    private final ScriptAdditionalService scriptAdditionalService;
    private final ScriptCalculationService scriptCalculationService;
    private final StateConditionService stateConditionService;
    private final MyCustomLogger customLogger;

    @Autowired
    public ScriptFieldPreprocessor(ScriptAdditionalService scriptAdditionalService, ScriptCalculationService scriptCalculationService, StateConditionService stateConditionService, MyCustomLogger customLogger) {
        this.scriptAdditionalService = scriptAdditionalService;
        this.scriptCalculationService = scriptCalculationService;
        this.stateConditionService = stateConditionService;
        this.customLogger = customLogger;
    }

    public void process(ViewRequest request, JwtSecurityUser user) {
        List viewFields = request.getFields().stream().filter(viewField -> viewField.isStateField() || viewField.isCalculatedField()).collect(Collectors.toList());
        List allConditionalFields = this.process(viewFields, user);
        request.getFields().addAll(allConditionalFields);
    }

    public List<ViewField> process(ViewField viewField, JwtSecurityUser user) {
        return viewField.isNativeCalculation() ? this.processNative(viewField, user) : this.process(List.of(viewField), user);
    }

    private List<ViewField> process(List<ViewField> viewFields, JwtSecurityUser user) {
        Pair topologyMaps = this.scriptAdditionalService.getTopologyMaps(user);
        Map businessEntityMap = (Map)topologyMaps.getLeft();
        Map businessEntityFieldMap = (Map)topologyMaps.getRight();
        Map keyToEntityFieldsMap = this.scriptAdditionalService.getFieldKeys(businessEntityMap, businessEntityFieldMap);
        Map keyToClearKeyMap = this.scriptAdditionalService.defineClearKeys(keyToEntityFieldsMap);
        return viewFields.stream().map(viewField -> this.process(viewField, user, businessEntityMap, businessEntityFieldMap, keyToEntityFieldsMap, keyToClearKeyMap)).flatMap(Collection::stream).toList();
    }

    private List<ViewField> process(ViewField viewField, JwtSecurityUser user, Map<UUID, BusinessEntity> businessEntityMap, Map<UUID, BusinessEntityField> businessEntityFieldMap, Map<String, List<BusinessEntityField>> fieldKeys, Map<String, String> keyToClearKeyMap) {
        boolean emptyCalculationField;
        if (viewField.isNativeCalculation()) {
            return this.processNative(viewField, user);
        }
        boolean emptyStateField = viewField.isStateField() && StringUtils.isEmpty((CharSequence)viewField.getStateCondition());
        boolean bl = emptyCalculationField = viewField.isCalculatedField() && StringUtils.isEmpty((CharSequence)viewField.getCalcFunction());
        if (emptyStateField || emptyCalculationField) {
            throw new IllegalArgumentException("There is state/calculated fields with empty script: " + viewField.getLabel());
        }
        viewField.setParsedCondition(viewField.isStateField() ? viewField.getStateCondition() : viewField.getCalcFunction());
        viewField.setConditionFieldIds(new HashMap());
        ArrayList<ViewField> addedConditionalFields = new ArrayList<ViewField>();
        for (Map.Entry<String, List<BusinessEntityField>> entry : fieldKeys.entrySet()) {
            String key = entry.getKey();
            String clearKey = keyToClearKeyMap.get(key);
            List<BusinessEntityField> businessEntityFieldList = entry.getValue();
            ArrayList apply = new ArrayList();
            for (Map.Entry aggEntry : FIELD_AGGREGATION_TO_FUNCTION_NAME_MAP.entrySet()) {
                FieldAggregation agg = (FieldAggregation)aggEntry.getKey();
                String aggName = (String)aggEntry.getValue();
                Optional applied = this.processKey(viewField, key, clearKey, businessEntityFieldList, aggName, agg);
                applied.ifPresent(apply::add);
            }
            addedConditionalFields.addAll(apply);
        }
        if (viewField.getFillGapSettings() == null) {
            viewField.setFillGapSettings(FillGapSettings.getDefaultSettings());
        }
        this.validateConditionAndSetCurrentEntity(viewField, businessEntityMap, businessEntityFieldMap);
        log.debug("Validation is started, language = {}", (Object)viewField.getScriptLanguage());
        this.validateAllowedAggregations(viewField, addedConditionalFields);
        this.validateCompilation(user, viewField, businessEntityFieldMap);
        return addedConditionalFields;
    }

    private List<ViewField> processNative(ViewField viewField, JwtSecurityUser user) {
        viewField.setParsedCondition(viewField.getCalcFunction());
        viewField.setConditionFieldIds(new HashMap());
        if (viewField.getFillGapSettings() == null) {
            viewField.setFillGapSettings(FillGapSettings.getDefaultSettings());
        }
        this.validateNativeCompilation(viewField, user);
        return Collections.emptyList();
    }

    private void validateAllowedAggregations(ViewField viewField, List<ViewField> addedConditionalFields) {
        List invalidConditionalFields;
        if (viewField.isStateField() && !(invalidConditionalFields = addedConditionalFields.stream().filter(condField -> !ALLOWED_STATE_FIELD_AGGREGATIONS.contains(condField.getAggregationType())).map(ViewField::getLabel).collect(Collectors.toList())).isEmpty()) {
            String errLabels = String.join((CharSequence)", ", invalidConditionalFields);
            throw new IllegalArgumentException("Invalid aggregations for: " + errLabels);
        }
    }

    private Optional<ViewField> processKey(ViewField viewField, String key, String clearKey, List<BusinessEntityField> businessEntityFieldList, String func, FieldAggregation aggregation) {
        String pattern = func + "(" + key + ")";
        if (viewField.getParsedCondition().contains(pattern)) {
            if (businessEntityFieldList.size() > 1) {
                throw new TrendzInternalException("There are some fields with the same key [" + key + "], therefore there is ambiguity that cannot be resolved.");
            }
            BusinessEntityField beField = businessEntityFieldList.iterator().next();
            ViewField conditionField = new ViewField();
            conditionField.setId(TimeStampUUIDGenerator.generateId());
            conditionField.setLabel(String.format("%s (condition field of \"%s\")", beField.getName(), viewField.getLabel()));
            conditionField.setBusinessEntityId(beField.getBusinessEntityId());
            conditionField.setEntityFieldId(beField.getId());
            conditionField.setAggregationType(aggregation);
            conditionField.setHidden(true);
            conditionField.setVirtualDateField(false);
            conditionField.setFillGapSettings(viewField.getFillGapSettings());
            conditionField.setLocalTimeRange(viewField.getLocalTimeRange());
            conditionField.setForStateCondition(!viewField.isSimpleCalculation());
            conditionField.setStateConditionPattern(pattern);
            conditionField.setParentStateField(viewField.getId());
            if (viewField.isCollectDebugDataSample()) {
                conditionField.setCollectDebugDataSample(true);
                conditionField.setDebugDataSample(new ConcurrentHashMap());
            }
            conditionField.setPredictionEnabled(viewField.isPredictionEnabled());
            conditionField.setPredictionRangeSec(viewField.getPredictionRangeSec());
            conditionField.setPredictionMethod(viewField.getPredictionMethod());
            conditionField.setIncludeHistoricalData(viewField.isIncludeHistoricalData());
            conditionField.setCustomPredictionMethod(viewField.getCustomPredictionMethod());
            conditionField.setMultivariablePredictionFieldIdList(viewField.getMultivariablePredictionFieldIdList());
            String varName = String.valueOf(aggregation) + "_" + (clearKey == null ? key : clearKey).replaceAll("\\.", "_");
            String parsedCondition = StringUtils.replace((String)viewField.getParsedCondition(), (String)pattern, (String)varName);
            viewField.setParsedCondition(parsedCondition);
            viewField.getConditionFieldIds().put(varName, conditionField);
            return Optional.of(conditionField);
        }
        return Optional.empty();
    }

    private void validateConditionAndSetCurrentEntity(ViewField viewField, Map<UUID, BusinessEntity> businessEntityMap, Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        if (viewField.isSimpleCalculation()) {
            viewField.setBusinessEntityId(EntityId.NULL_UUID);
            return;
        }
        Map beToBeFieldsMap = viewField.getConditionFieldIds().values().stream().collect(Collectors.groupingBy(ViewField::getBusinessEntityId, Collectors.mapping(ViewField::getEntityFieldId, Collectors.toList())));
        List<BusinessEntity> businessEntitiesUsingTelemetryFields = beToBeFieldsMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(beFieldId -> ((BusinessEntityField)businessEntityFieldMap.get(beFieldId)).hasTime())).map(Map.Entry::getKey).map(businessEntityMap::get).toList();
        if (businessEntitiesUsingTelemetryFields.isEmpty()) {
            throw new BadConfiguredTaskException("The condition does not contain any reference to the entities!\n Field: " + viewField.getLabel());
        }
        if (businessEntitiesUsingTelemetryFields.size() > 1) {
            throw new BadConfiguredTaskException("The condition contains references of the multiple entities, but only one is allowed! \n Field: " + viewField.getLabel() + ", \n Entities: " + Arrays.toString(businessEntitiesUsingTelemetryFields.stream().map(BusinessEntity::getName).toArray()));
        }
        BusinessEntity entityWithTelemetry = businessEntitiesUsingTelemetryFields.iterator().next();
        viewField.setBusinessEntityId(entityWithTelemetry.getId());
    }

    private void validateNativeCompilation(ViewField viewField, JwtSecurityUser user) {
        viewField.setScriptDebugLogId(UUID.randomUUID());
        ZoneId zoneId = ZoneId.systemDefault();
        String groupBy = "minute";
        try {
            List result = this.scriptCalculationService.processNativeScript(user, EntityId.NULL_UUID, BusinessEntityType.DEVICE, viewField, viewField.getScriptLanguage(), viewField.getLabel(), viewField.getParsedCondition(), 0L, 1L, groupBy, zoneId);
            log.trace("Native validation proceed successfully, result: {}", (Object)result);
            this.customLogger.clearLog(viewField.getScriptDebugLogId());
        }
        catch (Exception e) {
            throw new BadConfiguredTaskException("Script validation (compilation and runtime) was failed.", (Throwable)e);
        }
    }

    private void validateCompilation(JwtSecurityUser user, ViewField viewField, Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        String fieldName = viewField.getLabel();
        String finalScript = viewField.getParsedCondition();
        Map keyToConditionFieldMap = viewField.getConditionFieldIds();
        viewField.setScriptDebugLogId(UUID.randomUUID());
        List<String> argNames = keyToConditionFieldMap.keySet().stream().sorted().collect(Collectors.toList());
        Map inputData = this.prepareValidationInputData(keyToConditionFieldMap, businessEntityFieldMap);
        ZoneId zoneId = ZoneId.systemDefault();
        String groupBy = "minute";
        try {
            Object result;
            if (viewField.isStateField()) {
                StateCondition stateCondition = StateCondition.builder().expression(finalScript).stateName(fieldName).parameterNames(argNames.toArray(new String[0])).build();
                result = this.stateConditionService.getStatesByCondition(user, viewField, viewField.getScriptLanguage(), inputData, -30610224000000L, 32503680000000L, stateCondition, new Item());
            } else if (viewField.isBatchCalculation()) {
                result = this.scriptCalculationService.processBatchedScript(user, viewField, viewField.getScriptLanguage(), fieldName, inputData, finalScript, argNames, 0L, 1L, groupBy, zoneId);
            } else {
                Map<String, Object> flatInputMap = inputData.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((FieldValue)((List)entry.getValue()).get(0)).getInnerValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map rowMap = viewField.isBatchCalculation() ? new HashMap() : this.processRowFields(viewField);
                result = this.scriptCalculationService.processScript(user, viewField, viewField.getScriptLanguage(), fieldName, flatInputMap, finalScript, 0L, 1L, groupBy, zoneId, rowMap);
            }
            log.trace("Validation proceed successfully, result: {}", result);
            this.customLogger.clearLog(viewField.getScriptDebugLogId());
        }
        catch (Exception e) {
            throw new BadConfiguredTaskException("Script validation (compilation and runtime) was failed.", (Throwable)e);
        }
    }

    private Map<String, List<FieldValue>> prepareValidationInputData(Map<String, ViewField> keyToConditionFieldMap, Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        HashMap<String, List<FieldValue>> inputData = new HashMap<String, List<FieldValue>>();
        ArrayList<String> argNames = new ArrayList<String>(keyToConditionFieldMap.keySet());
        for (String fieldKey : argNames) {
            ViewField viewField = keyToConditionFieldMap.get(fieldKey);
            BusinessEntityField entityField = businessEntityFieldMap.get(viewField.getEntityFieldId());
            FieldValue fieldValue = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> new FieldValue(Collections.emptySet(), entityField.getType(), (Object)"{\"_TEST_\":\"_TEST_\"}", 0L);
                case 2 -> new FieldValue(Collections.emptySet(), entityField.getType(), (Object)false, 0L);
                case 3, 4 -> new FieldValue(Collections.emptySet(), entityField.getType(), (Object)1.0, 0L);
                case 5 -> new FieldValue(Collections.emptySet(), entityField.getType(), null, 0L);
            };
            inputData.put(fieldKey, Lists.newArrayList((Object[])new FieldValue[]{fieldValue}));
        }
        return inputData;
    }

    private Map<String, Object> processRowFields(ViewField viewField) {
        String script = viewField.getParsedCondition();
        HashSet<String> matchers = new HashSet<String>();
        String regex = "row\\[([\"'])([^\"']*)\\1]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(script);
        while (matcher.find()) {
            String match = matcher.group(0);
            matchers.add(match);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String match : matchers) {
            String key = match.substring(5, match.length() - 2);
            result.put(key, "{\"_TEST_\":\"_TEST_\"}");
        }
        return result;
    }
}

