/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class ScriptAdditionalService {
    private static final Logger log = LoggerFactory.getLogger(ScriptAdditionalService.class);
    private static final String patternOfDirtyKeysStr = "[\\s\\-\\\\/()<>#$!@%^*+?:\\[\\]]+";
    private static final Pattern patternOfDirtyKeys = Pattern.compile("[\\s\\-\\\\/()<>#$!@%^*+?:\\[\\]]+");
    private static final String dirtyKeysReplacement = "_";
    @Autowired
    private BusinessEntityService businessEntityService;

    public Pair<Map<UUID, BusinessEntity>, Map<UUID, BusinessEntityField>> getTopologyMaps(JwtSecurityUser user) {
        HashMap<UUID, BusinessEntity> businessEntityMap = new HashMap<UUID, BusinessEntity>();
        HashMap<UUID, BusinessEntityField> businessEntityFieldMap = new HashMap<UUID, BusinessEntityField>();
        List allEntities = this.businessEntityService.getAllEntities(user);
        for (BusinessEntity entity : allEntities) {
            businessEntityMap.put(entity.getId(), entity);
            for (BusinessEntityField field : entity.getFields()) {
                businessEntityFieldMap.put(field.getId(), field);
            }
        }
        return Pair.of(businessEntityMap, businessEntityFieldMap);
    }

    public Map<String, List<BusinessEntityField>> getFieldKeys(Map<UUID, BusinessEntity> businessEntityMap, Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        HashMap<String, List<BusinessEntityField>> keys = new HashMap<String, List<BusinessEntityField>>();
        for (BusinessEntityField beField : businessEntityFieldMap.values()) {
            BusinessEntity businessEntity = businessEntityMap.get(beField.getBusinessEntityId());
            String key = businessEntity.getName() + "." + beField.getName();
            keys.computeIfAbsent(key, i -> new ArrayList()).add(beField);
        }
        return keys;
    }

    public Map<String, String> defineClearKeys(Map<String, List<BusinessEntityField>> keyToEntityFieldsMap) {
        HashMap<String, String> keyToClearKeyMap = new HashMap<String, String>();
        HashSet<Object> uniqueClearKeys = new HashSet<Object>();
        for (Map.Entry<String, List<BusinessEntityField>> entry : keyToEntityFieldsMap.entrySet()) {
            String key = entry.getKey();
            if (!patternOfDirtyKeys.matcher(key).find()) continue;
            Object clearKey = key.replaceAll(patternOfDirtyKeysStr, dirtyKeysReplacement);
            while (keyToEntityFieldsMap.containsKey(clearKey) || uniqueClearKeys.contains(clearKey)) {
                clearKey = (String)clearKey + dirtyKeysReplacement;
            }
            keyToClearKeyMap.put(key, (String)clearKey);
            uniqueClearKeys.add(clearKey);
        }
        return keyToClearKeyMap;
    }
}

