/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.version;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.SSLUtils;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Component
public class TbVersionChecker {
    private static final Logger log = LoggerFactory.getLogger(TbVersionChecker.class);
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("\\d.\\d.\\d");
    private final TokenExtractor tokenExtractor;
    private final WebClient webClient;
    private final String baseURL;
    private final boolean useDefaultSet;
    private final boolean useManualSet;
    private final TbVersion defaultVersion;
    private final TbVersion manualVersion;
    private TbVersion currentVersion;

    @Autowired
    public TbVersionChecker(TokenExtractor tokenExtractor, @Value(value="${tb.api.url}") String tbApiUrl, @Value(value="${tb.api.custom-dns.enabled}") boolean customDnsEnabled, @Value(value="${tb.api.custom-dns.dns-address}") String customDnsAddress, @Value(value="${tb.api.version-checker.use-default-set}") boolean useDefaultSet, @Value(value="${tb.api.version-checker.default-version}") TbVersionNumber defaultVersionNumber, @Value(value="${tb.api.version-checker.default-pe}") boolean defaultPe, @Value(value="${tb.api.version-checker.default-cloud}") boolean defaultCloud, @Value(value="${tb.api.version-checker.use-manual-set}") boolean useManualSet, @Value(value="${tb.api.version-checker.manual-version}") TbVersionNumber manualVersionNumber, @Value(value="${tb.api.version-checker.manual-pe}") boolean manualPe, @Value(value="${tb.api.version-checker.manual-cloud}") boolean manualCloud) throws Exception {
        HttpClient secure;
        this.tokenExtractor = tokenExtractor;
        this.baseURL = tbApiUrl;
        this.useDefaultSet = useDefaultSet;
        this.useManualSet = useManualSet;
        this.defaultVersion = new TbVersion(defaultPe, defaultCloud, defaultVersionNumber);
        this.manualVersion = new TbVersion(manualPe, manualCloud, manualVersionNumber);
        SSLUtils.turnOffSslChecking();
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        if (customDnsEnabled) {
            DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder().channelType(NioDatagramChannel.class).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(new InetSocketAddress(customDnsAddress, 53))).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).queryTimeoutMillis(5000L);
            DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(dnsNameResolverBuilder);
            secure = ((HttpClient)HttpClient.create().resolver((AddressResolverGroup)resolverGroup)).secure(t -> t.sslContext(sslContext));
        } else {
            secure = HttpClient.create().secure(t -> t.sslContext(sslContext));
        }
        ReactorClientHttpConnector httpConnector = new ReactorClientHttpConnector(secure);
        this.webClient = WebClient.builder().baseUrl(tbApiUrl).clientConnector((ClientHttpConnector)httpConnector).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbVersion getVersion(String jwtToken) {
        if (this.currentVersion != null) {
            return this.currentVersion;
        }
        TbVersionChecker tbVersionChecker = this;
        synchronized (tbVersionChecker) {
            if (this.currentVersion != null) {
                return this.currentVersion;
            }
            this.currentVersion = (TbVersion)DonReactive.block((Mono)this.makeVersionPublisher(jwtToken));
            return this.currentVersion;
        }
    }

    private Mono<TbVersion> makeVersionPublisher(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (this.useManualSet) {
                return Mono.just((Object)this.getManualVersion());
            }
            return this.checkAvailability().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.fetchVersionByApi(jwtToken).onErrorResume(throwable -> this.fetchVersionIndirectly(jwtToken)).onErrorResume(throwable -> Mono.just((Object)this.getDefaultVersion()));
                }
                return Mono.error((Throwable)new IllegalStateException("TB API is not available!"));
            });
        }).doOnNext(tbVersion -> log.info("TB version is discovered: {}", tbVersion));
    }

    private Mono<Boolean> checkAvailability() {
        return this.webClient.get().uri(this.baseURL, new Object[0]).retrieve().toBodilessEntity().thenReturn((Object)true).onErrorResume(throwable -> {
            log.warn("TB API is not available - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<TbVersion> fetchVersionByApi(String jwtToken) {
        return this.webClient.get().uri(this.baseURL + "/api/system/info", new Object[0]).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono(JsonNode.class).map(jsonResponse -> jsonResponse.get("version").textValue()).flatMap(version -> {
            String parsedVersion = this.getSubstringByRegex(version, VERSION_STRING_PATTERN);
            boolean isCloud = version.toLowerCase().contains("paas");
            boolean isPe = isCloud || version.toLowerCase().contains("pe");
            TbVersionNumber versionNumber = TbVersionNumber.fromValue((String)parsedVersion);
            if (versionNumber == null) {
                log.warn("ThingsBoard service tell the version is unknown!");
                return this.useDefaultSet ? Mono.just((Object)this.getDefaultVersion()) : Mono.error((Throwable)new IllegalStateException("Unsupported version:" + parsedVersion));
            }
            return Mono.just((Object)new TbVersion(isPe, isCloud, versionNumber));
        }).onErrorMap(throwable -> new IllegalStateException("Can't define ThingsBoard version.", (Throwable)throwable));
    }

    private Mono<TbVersion> fetchVersionIndirectly(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> this.isTb2Api(jwtToken)).flatMap(isTb2 -> {
            if (isTb2.booleanValue()) {
                return this.is2xPe(jwtToken).map(isPe -> new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_2_2_0));
            }
            return this.isTb3Api(jwtToken).flatMap(isTb3 -> this.is3xPe(jwtToken).flatMap(isPe -> {
                if (!isTb3.booleanValue()) {
                    return Mono.error((Throwable)new IllegalStateException("Can't define Thingsboard version, service is unavailable."));
                }
                return this.isTb3_3_2_Api(jwtToken).flatMap(isTb3_3_2 -> {
                    if (isTb3_3_2.booleanValue()) {
                        return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_3_2));
                    }
                    return this.isTb31FilterApi(jwtToken).flatMap(isTb31Filter -> {
                        if (isTb31Filter.booleanValue()) {
                            return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_1_0));
                        }
                        return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_0_0));
                    });
                });
            }));
        });
    }

    private Mono<Boolean> isTb2Api(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            JwtSecurityUser secUser = this.tokenExtractor.extractUser(jwtToken);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("limit", 1);
            params.put("type", "stubType");
            params.put("idOffset", "fd48a070-aef4-11ea-b3fd-91f05b9b652c");
            params.put("textOffset", " ");
            params.put("textSearch", " ");
            String path = "/api/tenant/assets?";
            if (!secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                params.put("customerId", secUser.getCustomerId());
                path = "/api/customer/{customerId}/assets?";
            }
            return this.webClient.get().uri(this.baseURL + path + "limit={limit}&type={type}&textOffset={textOffset}&textSearch={textSearch}&idOffset={idOffset}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API v2 not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> isTb3Api(String jwtToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 1);
        params.put("page", 1);
        params.put("type", "stubType");
        params.put("textSearch", " ");
        params.put("sortProperty", "name");
        params.put("sortOrder", "ASC");
        return Mono.just((Object)new Object()).flatMap(o -> {
            String path = "/api/entityGroups/DASHBOARD";
            return this.webClient.get().uri(this.baseURL + path, params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API v3 PE initial not supported - {}", (Object)throwable.getMessage());
            String path = "/api/tenant/devices?";
            return this.webClient.get().uri(this.baseURL + path + "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API v3 CE not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> isTb31FilterApi(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            DeviceTypeFilter filter = new DeviceTypeFilter("default", "");
            List keyFilters = Collections.emptyList();
            List entityFields = Collections.emptyList();
            List latestValues = Collections.emptyList();
            EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
            EntityDataPageLink pageLink = new EntityDataPageLink(10, 0, null, sortOrder);
            EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityFields, latestValues, keyFilters);
            return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.baseURL + "/api/entitiesQuery/find", new Object[0])).body(BodyInserters.fromValue((Object)query)).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API v3.1_filter not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> isTb3_3_2_Api(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("pageSize", 1);
            params.put("page", 0);
            String path = "/api/otaPackages?";
            return this.webClient.get().uri(this.baseURL + path + "page={page}&pageSize={pageSize}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API v3.3.2 not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> is3xPe(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            String path = "/api/entityGroups/DASHBOARD";
            return this.webClient.get().uri(this.baseURL + path, new HashMap()).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API PEv3 not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> is2xPe(String jwtToken) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("limit", 1);
            params.put("type", "GENERIC");
            params.put("idOffset", EntityId.NULL_UUID);
            params.put("textOffset", " ");
            params.put("textSearch", " ");
            return this.webClient.get().uri(this.baseURL + "/api/roles?limit={limit}&type={type}&idOffset={idOffset}&textSearch={textSearch}&textOffset={textOffset}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().toBodilessEntity().thenReturn((Object)true);
        }).onErrorResume(throwable -> {
            log.warn("TB API PEv2 not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private TbVersion getDefaultVersion() {
        log.warn("Thingsboard version is not recognized, using default version: {}", (Object)this.defaultVersion.getVersion());
        return this.defaultVersion;
    }

    private TbVersion getManualVersion() {
        log.warn("Trendz using manual version: {}", (Object)this.manualVersion.getVersion());
        return this.manualVersion;
    }

    private String getSubstringByRegex(String where, Pattern pattern) {
        Matcher matcher = pattern.matcher(where);
        if (!matcher.find()) {
            throw new IllegalStateException("Can't find pattern in the string.");
        }
        return matcher.group();
    }
}

