/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DynamicValue;

public class FilterPredicateValue<T> {
    private final T defaultValue;
    private final T userValue;
    private final DynamicValue<T> dynamicValue;

    public FilterPredicateValue(T defaultValue) {
        this(defaultValue, null, null);
    }

    @JsonCreator
    public FilterPredicateValue(@JsonProperty(value="defaultValue") T defaultValue, @JsonProperty(value="userValue") T userValue, @JsonProperty(value="dynamicValue") DynamicValue<T> dynamicValue) {
        this.defaultValue = defaultValue;
        this.userValue = userValue;
        this.dynamicValue = dynamicValue;
    }

    @JsonIgnore
    public T getValue() {
        if (this.userValue != null) {
            return (T)this.userValue;
        }
        if (this.dynamicValue != null && this.dynamicValue.getResolvedValue() != null) {
            return (T)this.dynamicValue.getResolvedValue();
        }
        return (T)this.defaultValue;
    }

    public static FilterPredicateValue<Double> fromDouble(double value) {
        return new FilterPredicateValue((Object)value);
    }

    public static FilterPredicateValue<String> fromString(String value) {
        return new FilterPredicateValue((Object)value);
    }

    public static FilterPredicateValue<Boolean> fromBoolean(boolean value) {
        return new FilterPredicateValue((Object)value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterPredicateValue)) {
            return false;
        }
        FilterPredicateValue other = (FilterPredicateValue)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Object this$userValue = this.getUserValue();
        Object other$userValue = other.getUserValue();
        if (this$userValue == null ? other$userValue != null : !this$userValue.equals(other$userValue)) {
            return false;
        }
        DynamicValue this$dynamicValue = this.getDynamicValue();
        DynamicValue other$dynamicValue = other.getDynamicValue();
        return !(this$dynamicValue == null ? other$dynamicValue != null : !this$dynamicValue.equals(other$dynamicValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterPredicateValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Object $userValue = this.getUserValue();
        result = result * 59 + ($userValue == null ? 43 : $userValue.hashCode());
        DynamicValue $dynamicValue = this.getDynamicValue();
        result = result * 59 + ($dynamicValue == null ? 43 : $dynamicValue.hashCode());
        return result;
    }

    public String toString() {
        return "FilterPredicateValue(defaultValue=" + String.valueOf(this.getDefaultValue()) + ", userValue=" + String.valueOf(this.getUserValue()) + ", dynamicValue=" + String.valueOf(this.getDynamicValue()) + ")";
    }

    public T getDefaultValue() {
        return (T)this.defaultValue;
    }

    public T getUserValue() {
        return (T)this.userValue;
    }

    public DynamicValue<T> getDynamicValue() {
        return this.dynamicValue;
    }
}

