/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.graph.RelationGraphService;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.AssetSearchQueryFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.AssetTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.BooleanFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.ComplexFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceSearchQueryFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityListFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityNameFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.FilterPredicateValue;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.KeyFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.KeyFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.NumericFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.RelationEntityTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.RelationsQueryFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.StringFilterPredicate;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Service
public class TbFilterQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(TbFilterQueryBuilder.class);
    @Autowired
    private RelationGraphService relationGraphService;

    public EntityDataQuery buildFilterQuery(EntityType entityType, String type, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, int pageSize) {
        EntityFilter entityFilter = this.getEntityFilter(entityType, type, businessEntity, request, ctx);
        List keyFilters = this.buildKeyFilters(businessEntity, request, ctx);
        List entityFields = this.getEntityKeys(businessEntity, request, ctx);
        List latestValues = this.getLatestKeys(businessEntity, request, ctx);
        EntityDataPageLink pageLink = this.getDefaultPageLink(pageSize);
        return new EntityDataQuery(entityFilter, pageLink, entityFields, latestValues, keyFilters);
    }

    public EntityDataQuery buildRelationQuery(EntityId entityId, EntitySearchDirection direction, BusinessEntity businessEntity, ViewRequest request, String relatedEntityType, EntityType entityType, ViewContext ctx, String relationType, int pageSize) {
        EntityFilter entityFilter = this.buildRelatedEntityFilter(entityType, relatedEntityType, direction, relationType, entityId);
        List keyFilters = this.buildKeyFilters(businessEntity, request, ctx);
        List entityFields = this.getEntityKeys(businessEntity, request, ctx);
        List latestValues = this.getLatestKeys(businessEntity, request, ctx);
        EntityDataPageLink pageLink = this.getDefaultPageLink(pageSize);
        return new EntityDataQuery(entityFilter, pageLink, entityFields, latestValues, keyFilters);
    }

    public Optional<EntityDataQuery> buildMultiRelationQuery(Set<EntityId> entityIds, ViewRequest request, ViewContext ctx, int pageSize) {
        RelationsQueryFilter entityFilter = new RelationsQueryFilter();
        entityFilter.setFetchLastLevelOnly(false);
        entityFilter.setMaxLevel(10);
        entityFilter.setMultiRoot(true);
        entityFilter.setMultiRootEntityIds(entityIds.stream().map(id -> id.getId().toString()).collect(Collectors.toSet()));
        entityFilter.setMultiRootEntitiesType(((EntityId)entityIds.stream().findFirst().orElseThrow()).getEntityType());
        entityFilter.setFilters(new ArrayList());
        ArrayList keyFilters = new ArrayList();
        ArrayList entityFields = new ArrayList();
        ArrayList latestValues = new ArrayList();
        HashSet<UUID> processedBeIds = new HashSet<UUID>();
        for (ViewField viewField : ctx.getOrderedFields()) {
            UUID rootEntityId;
            UUID entityId;
            Map entityMap = ctx.getBusinessEntityMap();
            BusinessEntity childBusinessEntity = (BusinessEntity)entityMap.get(entityId = viewField.getBusinessEntityId());
            if (childBusinessEntity == null || processedBeIds.contains(entityId) || childBusinessEntity.getQuery() != null && BusinessEntityType.EXTERNAL.equals((Object)childBusinessEntity.getQuery().getEntityType())) continue;
            processedBeIds.add(entityId);
            RelationGraph relationGraph = ctx.getRelationGraph();
            Optional optParentBeId = this.relationGraphService.getParentEntity(relationGraph, rootEntityId = request.getRootEntityId(), entityId);
            if (!optParentBeId.isPresent()) continue;
            UUID parentEntityId = (UUID)optParentBeId.get();
            Relation relation = ctx.getParentChildRelation(parentEntityId, entityId);
            entityFilter.getFilters().add(this.buildRelationEntityTypeFilter(relation, childBusinessEntity));
            if (entityFilter.getDirection() == null) {
                entityFilter.setDirection(this.getSearchDirection(relation));
            } else if (entityFilter.getDirection() != this.getSearchDirection(relation)) {
                BusinessEntity businessEntityRoot = (BusinessEntity)entityMap.get(request.getRootEntityId());
                log.warn("Bidirectional multi-root relation query detected, root = [{}]", (Object)businessEntityRoot.getName());
            }
            List localLatestValues = this.getLatestKeys(childBusinessEntity, request, ctx);
            List localEntityFields = this.getEntityKeys(childBusinessEntity, request, ctx);
            localEntityFields.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "parentId"));
            entityFields.addAll(localEntityFields);
            latestValues.addAll(localLatestValues);
        }
        if (CollectionUtils.isEmpty((Collection)entityFilter.getFilters())) {
            return Optional.empty();
        }
        EntityDataPageLink pageLink = this.getDefaultPageLink(pageSize);
        EntityDataQuery entityDataQuery = new EntityDataQuery((EntityFilter)entityFilter, pageLink, new ArrayList(new HashSet(entityFields)), latestValues, keyFilters);
        return Optional.of(entityDataQuery);
    }

    private RelationEntityTypeFilter buildRelationEntityTypeFilter(Relation relation, BusinessEntity childBE) {
        BusinessEntityType beType = childBE.getQuery().getEntityType();
        EntityType entityType = EntityType.ASSET;
        if (beType == BusinessEntityType.DEVICE) {
            entityType = EntityType.DEVICE;
        } else if (beType == BusinessEntityType.CUSTOMER) {
            entityType = EntityType.CUSTOMER;
        }
        return new RelationEntityTypeFilter(relation.getName(), List.of(entityType));
    }

    private EntitySearchDirection getSearchDirection(Relation relation) {
        return relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
    }

    private List<KeyFilter> buildKeyFilters(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList<KeyFilter> keyFilters = new ArrayList<KeyFilter>();
        if (businessEntity == null || request == null || ctx == null) {
            return keyFilters;
        }
        Map businessEntityFieldMap = ctx.getBusinessEntityFieldMap();
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List<ViewField> viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).toList();
        List runtimeFilters = request.getRuntimeFilters();
        block7: for (ViewField viewField : viewFields) {
            UUID entityFieldId = viewField.getEntityFieldId();
            BusinessEntityField businessEntityField = (BusinessEntityField)businessEntityFieldMap.get(entityFieldId);
            BusinessEntityFieldQuery query = businessEntityField.getQuery();
            FieldQueryType queryType = query.getQueryType();
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[queryType.ordinal()]) {
                case 1: {
                    log.debug("Entity ID filtration is disabled");
                    continue block7;
                }
                case 2: {
                    request.getRuntimeFilters().stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst().filter(arg_0 -> this.isNotEmptyFilter(arg_0)).ifPresent(nameFilter -> keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.ENTITY_FIELD, "name", nameFilter, request, ctx)));
                    continue block7;
                }
                case 3: {
                    runtimeFilters.stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst().filter(arg_0 -> this.isNotEmptyFilter(arg_0)).ifPresent(labelFilter -> keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.ENTITY_FIELD, "label", labelFilter, request, ctx)));
                    continue block7;
                }
                case 4: {
                    runtimeFilters.stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst().filter(arg_0 -> this.isNotEmptyFilter(arg_0)).ifPresent(attrFilter -> {
                        switch (query.getScope()) {
                            case "CLIENT_SCOPE": {
                                keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.CLIENT_ATTRIBUTE, query.getKey(), attrFilter, request, ctx));
                                break;
                            }
                            case "SHARED_SCOPE": {
                                keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.SHARED_ATTRIBUTE, query.getKey(), attrFilter, request, ctx));
                                break;
                            }
                            case "SERVER_SCOPE": {
                                keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.SERVER_ATTRIBUTE, query.getKey(), attrFilter, request, ctx));
                            }
                        }
                    });
                    continue block7;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    log.debug("{} field type not supported in filter API. Skipping...", (Object)queryType);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unsupported entity Field type for query filter: " + String.valueOf(queryType));
        }
        return keyFilters;
    }

    private List<EntityKey> getEntityKeys(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList<EntityKey> entityKeys = new ArrayList<EntityKey>();
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "id"));
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "name"));
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "label"));
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "type"));
        ArrayList<EntityKey> latestKeys = new ArrayList<EntityKey>();
        if (businessEntity == null || request == null || ctx == null) {
            return entityKeys;
        }
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List<ViewField> viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).toList();
        block15: for (ViewField viewField : viewFields) {
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[businessEntityField.getQuery().getQueryType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    continue block15;
                }
                case 4: {
                    BusinessEntityFieldQuery tbQuery = businessEntityField.getQuery();
                    switch (tbQuery.getScope()) {
                        case "CLIENT_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.CLIENT_ATTRIBUTE, tbQuery.getKey()));
                            break;
                        }
                        case "SHARED_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SHARED_ATTRIBUTE, tbQuery.getKey()));
                            break;
                        }
                        case "SERVER_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, tbQuery.getKey()));
                        }
                    }
                    continue block15;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    log.debug("{} field type not supported in filter API. Skip", (Object)businessEntityField.getQuery().getQueryType());
                    continue block15;
                }
            }
            throw new IllegalStateException("Unsupported entity Field type for query keys " + String.valueOf(businessEntityField.getQuery().getQueryType()));
        }
        return entityKeys;
    }

    private List<EntityKey> getLatestKeys(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList latestKeys = Lists.newArrayList();
        if (businessEntity == null || request == null || ctx == null) {
            return latestKeys;
        }
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List<ViewField> viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).toList();
        for (ViewField viewField : viewFields) {
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            BusinessEntityFieldQuery tbQuery = businessEntityField.getQuery();
            block0 : switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[businessEntityField.getQuery().getQueryType().ordinal()]) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (viewField.getAggregationType() != FieldAggregation.LATEST) break;
                    latestKeys.add(new EntityKey(EntityKeyType.TIME_SERIES, tbQuery.getKey()));
                    break;
                }
                case 4: {
                    switch (tbQuery.getScope()) {
                        case "CLIENT_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.CLIENT_ATTRIBUTE, tbQuery.getKey()));
                            break block0;
                        }
                        case "SHARED_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SHARED_ATTRIBUTE, tbQuery.getKey()));
                            break block0;
                        }
                        case "SERVER_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, tbQuery.getKey()));
                        }
                    }
                }
            }
        }
        return latestKeys;
    }

    private EntityDataPageLink getDefaultPageLink(int pageSize) {
        EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
        EntityDataPageLink pageLink = new EntityDataPageLink(pageSize, 0, null, sortOrder);
        log.trace("Default page link created: {}", (Object)pageLink);
        return pageLink;
    }

    private boolean isNotEmptyFilter(RuntimeFilterField filterField) {
        return !this.isEmptyFilter(filterField);
    }

    private boolean isEmptyFilter(RuntimeFilterField filterField) {
        FilterCondition condition = filterField.getCondition();
        boolean isEmptyStringParam = false;
        isEmptyStringParam |= condition == FilterCondition.START_WITH;
        isEmptyStringParam |= condition == FilterCondition.END_WITH;
        isEmptyStringParam |= condition == FilterCondition.CONTAINS;
        if (isEmptyStringParam |= condition == FilterCondition.NO_CONTAINS) {
            return filterField.getStrParam() == null;
        }
        boolean isEmptyNumericParam = false;
        isEmptyNumericParam |= condition == FilterCondition.GREATER;
        isEmptyNumericParam |= condition == FilterCondition.GREATER_EQUALS;
        isEmptyNumericParam |= condition == FilterCondition.LOWER;
        isEmptyNumericParam |= condition == FilterCondition.LOWER_EQUALS;
        isEmptyNumericParam |= condition == FilterCondition.BEFORE;
        isEmptyNumericParam |= condition == FilterCondition.BEFORE_EQUALS;
        isEmptyNumericParam |= condition == FilterCondition.AFTER;
        if (isEmptyNumericParam |= condition == FilterCondition.AFTER_EQUALS) {
            return filterField.getNumericParam() == null;
        }
        return condition == FilterCondition.ANY || (condition == FilterCondition.ONE_OF || condition == FilterCondition.NO_ONE_OF) && (filterField.getSelection() == null || filterField.getSelection().isEmpty());
    }

    private KeyFilter buildEntityKeyFilter(EntityKeyType keyType, String keyName, RuntimeFilterField filterField, ViewRequest request, ViewContext ctx) {
        ViewField filteredViewField = request.getFields().stream().filter(viewField -> filterField.getViewFieldId().equals(viewField.getId())).findAny().orElseThrow();
        BusinessEntityField filteredBusinessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(filteredViewField.getEntityFieldId());
        KeyFilter filter = new KeyFilter();
        filter.setKey(new EntityKey(keyType, keyName));
        ArrayList<Object> nameOptions = new ArrayList<Object>();
        FilterCondition condition = filterField.getCondition();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[condition.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                StringFilterPredicate.StringOperation operation = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                    case 1 -> StringFilterPredicate.StringOperation.STARTS_WITH;
                    case 2 -> StringFilterPredicate.StringOperation.CONTAINS;
                    case 3 -> StringFilterPredicate.StringOperation.NOT_CONTAINS;
                    case 4 -> StringFilterPredicate.StringOperation.ENDS_WITH;
                    default -> null;
                };
                StringFilterPredicate predicate = new StringFilterPredicate();
                predicate.setValue(FilterPredicateValue.fromString((String)filterField.getStrParam()));
                predicate.setOperation(operation);
                predicate.setIgnoreCase(true);
                nameOptions.add(predicate);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                StringFilterPredicate.StringOperation operation = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                    case 5 -> NumericFilterPredicate.NumericOperation.GREATER;
                    case 6 -> NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL;
                    case 7 -> NumericFilterPredicate.NumericOperation.LESS;
                    case 8 -> NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL;
                    default -> null;
                };
                NumericFilterPredicate predicate = new NumericFilterPredicate();
                predicate.setValue(FilterPredicateValue.fromDouble((double)filterField.getNumericParam()));
                predicate.setOperation((NumericFilterPredicate.NumericOperation)operation);
                nameOptions.add(predicate);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                StringFilterPredicate.StringOperation operation = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                    case 9 -> NumericFilterPredicate.NumericOperation.GREATER;
                    case 10 -> NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL;
                    case 11 -> NumericFilterPredicate.NumericOperation.LESS;
                    case 12 -> NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL;
                    default -> null;
                };
                NumericFilterPredicate predicate = new NumericFilterPredicate();
                predicate.setValue(FilterPredicateValue.fromDouble((double)filterField.getNumericParam()));
                predicate.setOperation((NumericFilterPredicate.NumericOperation)operation);
                nameOptions.add(predicate);
                break;
            }
            case 13: 
            case 14: {
                ComplexFilterPredicate.ComplexOperation complexOperation = condition == FilterCondition.ONE_OF ? ComplexFilterPredicate.ComplexOperation.OR : ComplexFilterPredicate.ComplexOperation.AND;
                Set selection = filterField.getSelection();
                ComplexFilterPredicate complexFilterPredicate = new ComplexFilterPredicate();
                complexFilterPredicate.setOperation(complexOperation);
                switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[filteredBusinessEntityField.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        NumericFilterPredicate.NumericOperation numericOperation = condition == FilterCondition.ONE_OF ? NumericFilterPredicate.NumericOperation.EQUAL : NumericFilterPredicate.NumericOperation.NOT_EQUAL;
                        for (String value : selection) {
                            NumericFilterPredicate predicate = new NumericFilterPredicate();
                            predicate.setValue(FilterPredicateValue.fromDouble((double)Double.parseDouble(value)));
                            predicate.setOperation(numericOperation);
                            nameOptions.add(predicate);
                        }
                        break;
                    }
                    case 3: {
                        BooleanFilterPredicate.BooleanOperation booleanOperation = condition == FilterCondition.ONE_OF ? BooleanFilterPredicate.BooleanOperation.EQUAL : BooleanFilterPredicate.BooleanOperation.NOT_EQUAL;
                        for (String value : selection) {
                            BooleanFilterPredicate predicate = new BooleanFilterPredicate();
                            predicate.setValue(FilterPredicateValue.fromBoolean((boolean)Boolean.parseBoolean(value)));
                            predicate.setOperation(booleanOperation);
                            nameOptions.add(predicate);
                        }
                        break;
                    }
                    case 4: {
                        StringFilterPredicate.StringOperation stringOperation = condition == FilterCondition.ONE_OF ? StringFilterPredicate.StringOperation.EQUAL : StringFilterPredicate.StringOperation.NOT_EQUAL;
                        for (String name : selection) {
                            StringFilterPredicate predicate = new StringFilterPredicate();
                            predicate.setValue(FilterPredicateValue.fromString((String)name));
                            predicate.setOperation(stringOperation);
                            predicate.setIgnoreCase(true);
                            nameOptions.add(predicate);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Field type cannot be Calculated or Blank in the query builder.");
                    }
                }
                complexFilterPredicate.setPredicates(nameOptions);
                filter.setPredicate((KeyFilterPredicate)complexFilterPredicate);
            }
        }
        ComplexFilterPredicate complexFilterPredicate = new ComplexFilterPredicate();
        complexFilterPredicate.setOperation(ComplexFilterPredicate.ComplexOperation.OR);
        complexFilterPredicate.setPredicates(nameOptions);
        filter.setPredicate((KeyFilterPredicate)complexFilterPredicate);
        filter.setValueType(filteredBusinessEntityField.getType().makeTbValueType());
        return filter;
    }

    private EntityFilter buildRelatedEntityFilter(EntityType entityType, String type, EntitySearchDirection direction, String relationType, EntityId rootId) {
        DeviceSearchQueryFilter entityFilter = switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1 -> {
                DeviceSearchQueryFilter filter = new DeviceSearchQueryFilter();
                filter.setDeviceTypes(Collections.singletonList(type));
                filter.setDirection(direction);
                filter.setFetchLastLevelOnly(false);
                filter.setRelationType(relationType);
                filter.setMaxLevel(1);
                filter.setRootEntity(rootId);
                yield filter;
            }
            case 2 -> {
                DeviceSearchQueryFilter filter = new AssetSearchQueryFilter();
                filter.setAssetTypes(Collections.singletonList(type));
                filter.setDirection(direction);
                filter.setFetchLastLevelOnly(false);
                filter.setRelationType(relationType);
                filter.setMaxLevel(1);
                filter.setRootEntity(rootId);
                yield filter;
            }
            case 3 -> {
                RelationEntityTypeFilter typeFilter = new RelationEntityTypeFilter(relationType, Collections.emptyList());
                RelationsQueryFilter filter = new RelationsQueryFilter();
                filter.setDirection(direction);
                filter.setFetchLastLevelOnly(false);
                filter.setFilters((List)Lists.newArrayList((Object[])new RelationEntityTypeFilter[]{typeFilter}));
                filter.setMaxLevel(1);
                filter.setRootEntity(rootId);
                yield filter;
            }
            default -> throw new IllegalStateException("Entity type not supported: " + String.valueOf(entityType));
        };
        log.trace("Created related entity filter: {}", (Object)entityFilter);
        return entityFilter;
    }

    private EntityFilter getEntityFilter(EntityType entityType, String type, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        EntityFilter entityFilterByIdList = this.getEntityFilterByIdList(entityType, businessEntity, request, ctx);
        return entityFilterByIdList == null ? this.getEntityFilterByType(entityType, type) : entityFilterByIdList;
    }

    private EntityFilter getEntityFilterByIdList(EntityType entityType, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        if (businessEntity == null || request == null || ctx == null) {
            return null;
        }
        BusinessEntityField nameEntityField = businessEntity.getFields().stream().filter(field -> field.getQuery().getQueryType() == FieldQueryType.ENTITY_ID).findAny().orElseThrow();
        ViewField idViewField = request.getFields().stream().filter(viewField -> nameEntityField.getId().equals(viewField.getEntityFieldId())).findAny().orElse(null);
        if (idViewField == null) {
            return null;
        }
        List<RuntimeFilterField> idFilterFields = request.getRuntimeFilters().stream().filter(filter -> filter.getViewFieldId().equals(idViewField.getId())).toList();
        if (idFilterFields.isEmpty()) {
            return null;
        }
        RuntimeFilterField filterField = idFilterFields.iterator().next();
        if (filterField.getCondition() == FilterCondition.ANY) {
            return null;
        }
        if (filterField.getCondition() == FilterCondition.NO_ONE_OF) {
            throw new TrendzException("NO_ONE_OF condition is NOT allowed to use for ID fields");
        }
        if (filterField.getCondition() != FilterCondition.ONE_OF) {
            throw new TrendzException("Only ONE_OF or ANY condition is allowed to use for ID fields");
        }
        ArrayList entityList = new ArrayList(filterField.getSelection());
        if (entityList.isEmpty()) {
            return null;
        }
        EntityListFilter filter2 = new EntityListFilter();
        filter2.setEntityType(entityType);
        filter2.setEntityList(entityList);
        return filter2;
    }

    private EntityFilter getEntityFilterByType(EntityType entityType, String type) {
        DeviceTypeFilter entityFilter = switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1 -> new DeviceTypeFilter(type, "");
            case 2 -> new AssetTypeFilter(type, "");
            case 3 -> new EntityNameFilter(EntityType.CUSTOMER, "");
            default -> throw new IllegalStateException("Entity type not supported: " + String.valueOf(entityType));
        };
        log.trace("Created entity filter: {}", (Object)entityFilter);
        return entityFilter;
    }
}

