/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.PageDataIterableV3Filterable;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;

public class PageDataIterableV3Filterable<T>
implements Iterable<T>,
Iterator<T> {
    private final FetchFunction<T> function;
    private EntityDataQuery query;
    private List<T> currentItems;
    private int currentIdx;
    private boolean hasNextPack;
    private boolean initialized;

    public PageDataIterableV3Filterable(FetchFunction<T> function, EntityDataQuery query) {
        this.function = function;
        this.query = query;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.fetch();
            this.initialized = true;
        }
        if (this.currentIdx == this.currentItems.size() && this.hasNextPack) {
            this.fetch();
        }
        return this.currentIdx < this.currentItems.size();
    }

    private void fetch() {
        PageData pageData = this.function.fetch(this.query);
        this.currentIdx = 0;
        this.currentItems = pageData.getData();
        this.hasNextPack = pageData.hasNext();
        this.query = this.query.next();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)this.currentItems.get(this.currentIdx++);
    }
}

