/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.FilteredEntityDataTransformer;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class FilteredEntityDataTransformer {
    public PageData<Device> entityToDevicePageData(PageData<EntityData> entityPageData) {
        List devices = entityPageData.getData().stream().filter(ent -> ent.getEntityId() instanceof DeviceId).map(ent -> {
            EnhancedDevice device = new EnhancedDevice();
            device.setId((UUIDBased)((DeviceId)ent.getEntityId()));
            ConcurrentHashMap<String, TsValue> attrMap = new ConcurrentHashMap<String, TsValue>();
            ConcurrentHashMap latestTelemetry = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            device.setName(((TsValue)entityFields.get("name")).getValue());
                        }
                        if (entityFields.containsKey("type")) {
                            device.setType(((TsValue)entityFields.get("type")).getValue());
                        }
                        if (entityFields.containsKey("label")) {
                            device.setLabel(((TsValue)entityFields.get("label")).getValue());
                        }
                        if (!entityFields.containsKey("lastActivityTime")) break;
                        TsValue lastActivityTime = (TsValue)entityFields.get("lastActivityTime");
                        attrMap.put("lastActivityTime", lastActivityTime);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        attrMap.putAll(attrFields);
                        break;
                    }
                    case 5: {
                        Map latestTelemetryFields = (Map)entry.getValue();
                        latestTelemetry.putAll(latestTelemetryFields);
                    }
                }
            }
            device.setAttributes(attrMap);
            device.setLatestTelemetries(latestTelemetry);
            return device;
        }).collect(Collectors.toList());
        PageData devicePageData = new PageData(devices, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return devicePageData;
    }

    public PageData<Asset> entityToAssetPageData(PageData<EntityData> entityPageData) {
        List assets = entityPageData.getData().stream().filter(ent -> ent.getEntityId() instanceof AssetId).map(ent -> {
            EnhancedAsset asset = new EnhancedAsset();
            asset.setId((UUIDBased)((AssetId)ent.getEntityId()));
            ConcurrentHashMap<String, TsValue> attrMap = new ConcurrentHashMap<String, TsValue>();
            ConcurrentHashMap latestTelemetry = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            asset.setName(((TsValue)entityFields.get("name")).getValue());
                        }
                        if (entityFields.containsKey("type")) {
                            asset.setType(((TsValue)entityFields.get("type")).getValue());
                        }
                        if (entityFields.containsKey("label")) {
                            asset.setLabel(((TsValue)entityFields.get("label")).getValue());
                        }
                        if (!entityFields.containsKey("lastActivityTime")) break;
                        TsValue lastActivityTime = (TsValue)entityFields.get("lastActivityTime");
                        attrMap.put("lastActivityTime", lastActivityTime);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        attrMap.putAll(attrFields);
                        break;
                    }
                    case 5: {
                        Map latestTelemetryFields = (Map)entry.getValue();
                        latestTelemetry.putAll(latestTelemetryFields);
                    }
                }
            }
            asset.setAttributes(attrMap);
            asset.setLatestTelemetries(latestTelemetry);
            return asset;
        }).collect(Collectors.toList());
        PageData assetPageData = new PageData(assets, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return assetPageData;
    }

    public PageData<Customer> entityToCustomerPageData(PageData<EntityData> entityPageData) {
        List customers = entityPageData.getData().stream().map(ent -> {
            if (!(ent.getEntityId() instanceof CustomerId)) {
                return null;
            }
            EnhancedCustomer customer = new EnhancedCustomer();
            customer.setId((UUIDBased)((CustomerId)ent.getEntityId()));
            ConcurrentHashMap latestTelemetry = new ConcurrentHashMap();
            ConcurrentHashMap attrMap = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (!entityFields.containsKey("name")) break;
                        customer.setTitle(((TsValue)entityFields.get("name")).getValue());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        attrMap.putAll(attrFields);
                        break;
                    }
                    case 5: {
                        Map latestTelemetryFields = (Map)entry.getValue();
                        latestTelemetry.putAll(latestTelemetryFields);
                    }
                }
            }
            customer.setAttributes(attrMap);
            customer.setLatestTelemetries(latestTelemetry);
            return customer;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PageData customersPageData = new PageData(customers, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return customersPageData;
    }

    public PageData<Item> entityToItemPageData(PageData<EntityData> entityPageData) {
        List items = entityPageData.getData().stream().map(ent -> {
            String name = null;
            String label = null;
            String type = null;
            UUID parentId = null;
            ConcurrentHashMap<String, TsValue> attrMap = new ConcurrentHashMap<String, TsValue>();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            name = ((TsValue)entityFields.get("name")).getValue();
                        }
                        if (entityFields.containsKey("label")) {
                            label = ((TsValue)entityFields.get("label")).getValue();
                        }
                        if (entityFields.containsKey("type")) {
                            type = ((TsValue)entityFields.get("type")).getValue();
                        }
                        if (!entityFields.containsKey("parentId")) break;
                        parentId = UUID.fromString(((TsValue)entityFields.get("parentId")).getValue());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        for (Map.Entry valueEntry : attrFields.entrySet()) {
                            attrMap.put((String)valueEntry.getKey(), (TsValue)valueEntry.getValue());
                        }
                        break;
                    }
                }
            }
            Item item = new Item(ent.getEntityId().getId(), parentId, null, name, label);
            item.setType(type);
            if (MapUtils.isNotEmpty(attrMap)) {
                item.setAttributes(attrMap);
            }
            return item;
        }).collect(Collectors.toList());
        PageData itemPageData = new PageData(items, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return itemPageData;
    }

    public void fetchFilterValues(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, List<Item> itemList) {
        if (request != null) {
            Set entityFieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
            Set viewFields = request.getFields().stream().filter(f -> entityFieldIds.contains(f.getEntityFieldId())).collect(Collectors.toSet());
            Set viewFieldIds = viewFields.stream().map(ViewField::getId).collect(Collectors.toSet());
            List<RuntimeFilterField> reFetchFields = request.getRuntimeFilters().stream().filter(f -> !f.isBlankFilter()).filter(f -> viewFieldIds.contains(f.getViewFieldId())).toList();
            if (!reFetchFields.isEmpty() && !itemList.isEmpty()) {
                ctx.getFieldFilterOptionTasks().add(new FilterOptionTask(itemList, businessEntity));
            }
        }
    }

    public Flux<Asset> enrichAssetsWithCustomerIdAsync(Set<Asset> assets, Function<Set<UUID>, Mono<List<Asset>>> assetLoadingFunction) {
        Flux listFlux = Flux.fromIterable((Iterable)Lists.partition((List)Lists.newArrayList(assets), (int)100));
        Flux assetFlux = listFlux.flatMap(list -> {
            Map<UUID, Asset> assetMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            return ((Mono)assetLoadingFunction.apply(assetMap.keySet())).flatMapIterable(l -> l).doOnNext(d -> {
                Asset dd = (Asset)assetMap.get(d.getUuidId());
                if (dd != null) {
                    dd.setTenantId(d.getTenantId());
                    dd.setCustomerId(d.getCustomerId());
                }
            });
        }).collectList().flatMapIterable(l -> assets);
        return assetFlux;
    }

    public void enrichAssetsWithCustomerId(ViewContext ctx, Set<Asset> assets, String jwtToken, Function<Set<UUID>, List<Asset>> assetLoader) {
        for (List list : Lists.partition((List)Lists.newArrayList(assets), (int)100)) {
            Map<UUID, Asset> assetMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            List<Asset> assetsWithCustomer = assetLoader.apply(assetMap.keySet());
            for (Asset device : assetsWithCustomer) {
                Asset aa = assetMap.get(device.getUuidId());
                if (aa == null) continue;
                aa.setTenantId(device.getTenantId());
                aa.setCustomerId(device.getCustomerId());
            }
        }
    }

    public Flux<Device> enrichDevicesWithCustomerIdAsync(Set<Device> devices, Function<Set<UUID>, Mono<List<Device>>> deviceAsyncLoader) {
        Flux listFlux = Flux.fromIterable((Iterable)Lists.partition((List)Lists.newArrayList(devices), (int)100));
        Flux deviceFlux = listFlux.flatMap(list -> {
            Map<UUID, Device> deviceMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            return ((Mono)deviceAsyncLoader.apply(deviceMap.keySet())).flatMapIterable(l -> l).doOnNext(d -> {
                Device dd = (Device)deviceMap.get(d.getUuidId());
                if (dd != null) {
                    dd.setTenantId(d.getTenantId());
                    dd.setCustomerId(d.getCustomerId());
                }
            });
        }).collectList().flatMapIterable(l -> devices);
        return deviceFlux;
    }

    public void enrichDevicesWithCustomerId(Set<Device> devices, Function<Set<UUID>, List<Device>> deviceLoadFunction) {
        for (List list : Lists.partition((List)Lists.newArrayList(devices), (int)100)) {
            Map<UUID, Device> deviceMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            List<Device> devicesWithCustomer = deviceLoadFunction.apply(deviceMap.keySet());
            for (Device device : devicesWithCustomer) {
                Device dd = deviceMap.get(device.getUuidId());
                if (dd == null) continue;
                dd.setTenantId(device.getTenantId());
                dd.setCustomerId(device.getCustomerId());
            }
        }
    }
}

