/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.cache;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;

@Service
public class CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private final Map<CacheConfigurationName, Cache> cacheMap = new HashMap();

    @Autowired
    public CacheService(CacheManager cacheManager) {
        for (CacheConfigurationName name : CacheConfigurationName.values()) {
            Cache cache = cacheManager.getCache(name.getValue());
            if (cache == null) {
                String message = String.format("Cache was not found with current name: %s", name);
                throw new TrendzInternalException(message);
            }
            this.cacheMap.put(name, cache);
        }
    }

    public Cache getCache(CacheConfigurationName name) {
        return (Cache)this.cacheMap.get(name);
    }

    public void clearCaches(CacheConfigurationName name) {
        ((Cache)this.cacheMap.get(name)).clear();
    }

    public void clearCaches() {
        this.cacheMap.values().forEach(Cache::clear);
    }
}

