/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;

public class TelemetryPartitionQuery {
    private long startTs;
    private long endTs;
    private long interval;
    private String agg;
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public String toString() {
        return "TelemetryPartitionQuery(startTs=" + String.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.startTs), ZoneId.systemDefault())) + ", endTs=" + String.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.endTs), ZoneId.systemDefault())) + ", interval=[" + df.format((double)this.interval / (double)TimeUnit.DAYS.toMillis(1L)) + "] days, interval_count=[" + df.format((double)(this.endTs - this.startTs) / (double)this.interval) + "]), agg=" + this.agg;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getAgg() {
        return this.agg;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setAgg(String agg) {
        this.agg = agg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryPartitionQuery)) {
            return false;
        }
        TelemetryPartitionQuery other = (TelemetryPartitionQuery)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        String this$agg = this.getAgg();
        String other$agg = other.getAgg();
        return !(this$agg == null ? other$agg != null : !this$agg.equals(other$agg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TelemetryPartitionQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        String $agg = this.getAgg();
        result = result * 59 + ($agg == null ? 43 : $agg.hashCode());
        return result;
    }

    public TelemetryPartitionQuery(long startTs, long endTs, long interval, String agg) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.interval = interval;
        this.agg = agg;
    }
}

